/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swf;

import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.swf.ITagContainer;
import com.adobe.flash.swf.TagType;
import com.adobe.flash.swf.tags.DoABCTag;
import com.adobe.flash.swf.tags.ExportAssetsTag;
import com.adobe.flash.swf.tags.FrameLabelTag;
import com.adobe.flash.swf.tags.ICharacterTag;
import com.adobe.flash.swf.tags.IManagedTag;
import com.adobe.flash.swf.tags.ITag;
import com.adobe.flash.swf.tags.ShowFrameTag;
import com.adobe.flash.swf.tags.SymbolClassTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SWFFrame
implements ITagContainer {
    private final List<ITag> unfiledTags = new ArrayList<ITag>();
    private final List<DoABCTag> doABCTags = new ArrayList<DoABCTag>();
    private final LinkedHashSet<ICharacterTag> characterTags = new LinkedHashSet();
    protected SymbolClassTag symbolClass;
    protected ExportAssetsTag exportAssetsTag;
    protected FrameLabelTag frameLabel;

    public void addTag(ITag tag) {
        if (tag == null) {
            throw new NullPointerException("can't not add null to SWF frame");
        }
        if (tag.getTagType() == TagType.Undefined) {
            return;
        }
        if (tag instanceof IManagedTag) {
            throw new IllegalArgumentException("Can't add a managed tag to frame.");
        }
        if (tag.getTagType() == TagType.DoABC) {
            this.doABCTags.add((DoABCTag)tag);
        } else if (tag instanceof ICharacterTag) {
            this.characterTags.add((ICharacterTag)tag);
        } else {
            this.unfiledTags.add(tag);
        }
    }

    public void defineSymbol(ICharacterTag tag, String name) {
        this.defineSymbol(tag, name, null);
    }

    public void defineSymbol(ICharacterTag tag, String name, Map<Integer, ICharacterTag> dictionary) {
        assert (tag != null);
        assert (name != null);
        if (!(dictionary != null && dictionary.get(tag.getCharacterID()) != null || this.characterTags.contains(tag))) {
            throw new IllegalStateException("Tag not added to the frame yet: " + tag);
        }
        this.getSymbolClass().addSymbol(tag, name);
    }

    private SymbolClassTag getSymbolClass() {
        if (this.symbolClass == null) {
            this.symbolClass = new SymbolClassTag();
        }
        return this.symbolClass;
    }

    public String getSymbolName(ICharacterTag tag) {
        if (this.symbolClass == null) {
            return null;
        }
        return this.symbolClass.getSymbolName(tag);
    }

    public void defineExport(ICharacterTag tag, String name) {
        assert (tag != null);
        assert (name != null);
        if (!this.characterTags.contains(tag)) {
            throw new IllegalStateException("Tag not added to the frame yet: " + tag);
        }
        if (this.exportAssetsTag == null) {
            this.exportAssetsTag = new ExportAssetsTag();
        }
        this.exportAssetsTag.addExport(tag, name);
    }

    @Override
    public Iterator<ITag> iterator() {
        ArrayList<ITag> orderedTags = new ArrayList<ITag>();
        if (this.frameLabel != null) {
            orderedTags.add(this.frameLabel);
        }
        orderedTags.addAll(this.doABCTags);
        orderedTags.addAll(this.characterTags);
        if (this.symbolClass != null) {
            orderedTags.add(this.symbolClass);
        }
        if (this.exportAssetsTag != null) {
            orderedTags.add(this.exportAssetsTag);
        }
        orderedTags.addAll(this.unfiledTags);
        orderedTags.add(new ShowFrameTag());
        return orderedTags.iterator();
    }

    public void setName(String name, boolean isAnchor) {
        assert (name != null);
        assert (!"".equals(name));
        if (this.frameLabel == null) {
            this.frameLabel = new FrameLabelTag(name);
        }
        this.frameLabel.setNamedAnchorTag(isAnchor);
    }

    public String getName() {
        return this.frameLabel == null ? null : this.frameLabel.getName();
    }

    public boolean hasNamedAnchor() {
        return this.frameLabel == null ? false : this.frameLabel.isNamedAnchorTag();
    }

    public static final void forceSymbolClassTag(SWFFrame frame) {
        frame.getSymbolClass();
    }

    @Override
    public Collection<ICompilerProblem> getProblems() {
        return Collections.emptyList();
    }
}

