/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swc.io;

import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCDigest;
import com.adobe.flash.swc.ISWCFileEntry;
import com.adobe.flash.swc.ISWCLibrary;
import com.adobe.flash.swc.SWCDigest;
import com.adobe.flash.swc.catalog.StAXCatalogWriter;
import com.adobe.flash.swc.io.ISWCWriter;
import com.adobe.flash.swc.io.ISWFWriterFactory;
import com.adobe.flash.swf.Header;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;

abstract class SWCWriterBase
implements ISWCWriter {
    protected static final String CATALOG_XML = "catalog.xml";
    private final boolean compressLibrarySWF;
    protected final boolean enableDebug;
    protected final ISWFWriterFactory swfWriterFactory;

    protected SWCWriterBase(boolean compressLibrarySWF, boolean enableDebug, ISWFWriterFactory swfWriterFactory) {
        assert (swfWriterFactory != null);
        this.compressLibrarySWF = compressLibrarySWF;
        this.enableDebug = enableDebug;
        this.swfWriterFactory = swfWriterFactory;
    }

    public boolean compressLibrarySWF() {
        return this.compressLibrarySWF;
    }

    public Header.Compression getLibrarySWFCompression() {
        return this.compressLibrarySWF() ? Header.Compression.ZLIB : Header.Compression.NONE;
    }

    @Override
    public void write(ISWC swc) throws IOException {
        if (swc == null) {
            throw new NullPointerException("SWC model can't be null.");
        }
        this.prepare(swc);
        for (ISWCLibrary library : swc.getLibraries()) {
            this.writeLibrary(library);
        }
        this.writeCatalog(swc);
        for (ISWCFileEntry fileEntry : swc.getFiles().values()) {
            this.writeFile(fileEntry);
        }
        this.finish(swc);
    }

    abstract void prepare(ISWC var1) throws IOException;

    abstract void writeCatalog(ISWC var1) throws IOException;

    abstract void writeLibrary(ISWCLibrary var1) throws IOException;

    abstract void writeFile(ISWCFileEntry var1) throws IOException;

    abstract void finish(ISWC var1) throws IOException;

    protected final void writeCatalogXML(ISWC swc, Writer writer) {
        try {
            StAXCatalogWriter xmlWriter = new StAXCatalogWriter(swc, writer);
            xmlWriter.write();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    protected DigestOutputStream getDigestOutputStream(ISWCLibrary library, OutputStream outputStream) {
        DigestOutputStream digestStream = null;
        MessageDigest messageDigest = null;
        if (!this.hasUnsignedDigest(library)) {
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
                digestStream = new DigestOutputStream(outputStream, messageDigest);
            }
            catch (NoSuchAlgorithmException e) {
                // empty catch block
            }
        }
        return digestStream;
    }

    protected void addDigestToLibrary(DigestOutputStream digestStream, ISWCLibrary library) {
        if (library == null) {
            throw new NullPointerException("library may not be null");
        }
        if (digestStream != null) {
            SWCDigest swcDigest = new SWCDigest();
            swcDigest.setType("SHA-256");
            swcDigest.setValue(digestStream.getMessageDigest().digest());
            library.addDigest(swcDigest);
        }
    }

    private boolean hasUnsignedDigest(ISWCLibrary library) {
        List<ISWCDigest> digests = library.getDigests();
        for (ISWCDigest digest : digests) {
            if (digest.isSigned()) continue;
            return true;
        }
        return false;
    }
}

