/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swc.io;

import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCFileEntry;
import com.adobe.flash.swc.ISWCLibrary;
import com.adobe.flash.swc.io.ISWFWriterFactory;
import com.adobe.flash.swc.io.SWCWriterBase;
import com.adobe.flash.swf.ISWF;
import com.adobe.flash.swf.io.ISWFWriter;
import com.adobe.flash.swf.io.SWFWriterAndSizeReporter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.DigestOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class SWCWriter
extends SWCWriterBase {
    private final ZipOutputStream zipOutputStream;

    public SWCWriter(String filename) throws FileNotFoundException {
        this(filename, true, true, SWFWriterAndSizeReporter.getSWFWriterFactory(null));
    }

    public SWCWriter(String filename, boolean compressLibrarySWF, boolean enableDebug, ISWFWriterFactory swfWriterFactory) throws FileNotFoundException {
        super(compressLibrarySWF, enableDebug, swfWriterFactory);
        File outputFile = new File(filename);
        File outputDirectory = new File(outputFile.getAbsoluteFile().getParent());
        outputDirectory.mkdirs();
        this.zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        this.zipOutputStream.setLevel(0);
    }

    @Override
    void writeCatalog(ISWC swc) throws IOException {
        this.zipOutputStream.putNextEntry(new ZipEntry("catalog.xml"));
        OutputStreamWriter catalogXMLWriter = new OutputStreamWriter(this.zipOutputStream);
        this.writeCatalogXML(swc, catalogXMLWriter);
        ((Writer)catalogXMLWriter).flush();
        this.zipOutputStream.closeEntry();
    }

    @Override
    void writeLibrary(ISWCLibrary library) throws IOException {
        ISWF swf = library.getSWF();
        String path = library.getPath();
        assert (swf != null) : "Expect SWF model";
        assert (path != null) : "Expect SWF path";
        this.zipOutputStream.putNextEntry(new ZipEntry(path));
        ISWFWriter swfWriter = this.swfWriterFactory.createSWFWriter(swf, this.getLibrarySWFCompression(), this.enableDebug);
        DigestOutputStream digestStream = this.getDigestOutputStream(library, this.zipOutputStream);
        swfWriter.writeTo(digestStream != null ? digestStream : this.zipOutputStream);
        swfWriter.close();
        this.zipOutputStream.closeEntry();
        if (digestStream != null) {
            this.addDigestToLibrary(digestStream, library);
        }
    }

    @Override
    void writeFile(ISWCFileEntry fileEntry) throws IOException {
        this.zipOutputStream.putNextEntry(new ZipEntry(fileEntry.getPath()));
        InputStream fileInputStream = fileEntry.createInputStream();
        IOUtils.copy((InputStream)fileInputStream, (OutputStream)this.zipOutputStream);
        fileInputStream.close();
        this.zipOutputStream.closeEntry();
    }

    @Override
    void prepare(ISWC swc) {
    }

    @Override
    void finish(ISWC swc) throws IOException {
        this.zipOutputStream.flush();
        this.zipOutputStream.close();
    }
}

