/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swc;

import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.internal.caches.AssetTagCache;
import com.adobe.flash.compiler.internal.caches.CSSDocumentCache;
import com.adobe.flash.compiler.internal.caches.CacheStoreKeyBase;
import com.adobe.flash.compiler.internal.caches.ConcurrentCacheStoreBase;
import com.adobe.flash.compiler.internal.caches.FileScopeCache;
import com.adobe.flash.compiler.internal.caches.SWFCache;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.scopes.IFileScope;
import com.adobe.flash.compiler.workspaces.IWorkspace;
import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCLibrary;
import com.adobe.flash.swc.ISWCManager;
import com.adobe.flash.swc.ISWCScript;
import com.adobe.flash.swc.ISWCVersion;
import com.adobe.flash.swc.io.SWCReader;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SWCManager
extends ConcurrentCacheStoreBase<ISWC>
implements ISWCManager {
    private final SWFCache swfCache = new SWFCache(this);
    private final FileScopeCache fileScopeCache = new FileScopeCache(this);
    private final AssetTagCache assetTagCache = new AssetTagCache(this);
    private final CSSDocumentCache cssDocumentCache = new CSSDocumentCache();
    private final IWorkspace workspace;

    public SWCManager(IWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public SWFCache getSWFCache() {
        return this.swfCache;
    }

    @Override
    public FileScopeCache getFileScopeCache() {
        return this.fileScopeCache;
    }

    @Override
    public AssetTagCache getAssetTagCache() {
        return this.assetTagCache;
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    protected ISWC createEntryValue(CacheStoreKeyBase key) {
        if (key instanceof SWCCacheKey) {
            SWCCacheKey cacheKey = (SWCCacheKey)key;
            SWCReader reader = new SWCReader(cacheKey.file, this.workspace.getASDocDelegate().getPackageDitaParser());
            ISWC swc = reader.getSWC();
            assert (swc != null) : "Expect a SWC model object.";
            this.handleBrokenAlchemy1SWC(swc);
            return swc;
        }
        throw new IllegalArgumentException("Expected a SWCCacheKey.");
    }

    private void handleBrokenAlchemy1SWC(ISWC swc) {
        assert (swc != null);
        ISWCVersion swcVersion = swc.getVersion();
        if (!"1.0".equals(swcVersion.getSWCVersion())) {
            return;
        }
        if (!"2.0".equals(swcVersion.getFlexVersion())) {
            return;
        }
        Collection<ISWCLibrary> libraries = swc.getLibraries();
        if (libraries.size() != 1) {
            return;
        }
        ISWCLibrary library = (ISWCLibrary)Iterables.getOnlyElement(libraries);
        List<ISWCScript> scripts = library.getScripts();
        if (scripts.size() != 1) {
            return;
        }
        ISWCScript script = (ISWCScript)Iterables.getOnlyElement(scripts);
        Set<String> swcDefinitions = script.getDefinitions();
        if (swcDefinitions.size() != 1) {
            return;
        }
        Collection scopes = (Collection)this.fileScopeCache.get(FileScopeCache.createKey(swc, library.getPath(), script));
        for (IASScope scope : scopes) {
            assert (scope instanceof IFileScope);
            IFileScope fileScope = (IFileScope)scope;
            Collection<IDefinition> definitions = fileScope.getAllLocalDefinitions();
            for (IDefinition definition : definitions) {
                if (!definition.getNamespaceReference().isPublicOrInternalNamespace()) continue;
                script.addDefinition(definition.getQualifiedName());
            }
        }
    }

    @Override
    public ISWC get(File file) {
        ISWC result = (ISWC)this.get(new SWCCacheKey(file));
        return result;
    }

    @Override
    public void remove(File file) {
        ISWC removedSWC = (ISWC)this.remove(new SWCCacheKey(file));
        if (removedSWC == null) {
            return;
        }
        for (ISWCLibrary lib : removedSWC.getLibraries()) {
            String librarySWFPath = lib.getPath();
            for (ISWCScript script : lib.getScripts()) {
                this.fileScopeCache.remove(FileScopeCache.createKey(removedSWC, librarySWFPath, script));
                for (String scriptDefQName : script.getDefinitions()) {
                    this.assetTagCache.remove(AssetTagCache.createKey(removedSWC, librarySWFPath, script, scriptDefQName));
                }
            }
            this.swfCache.remove(SWFCache.createKey(removedSWC, lib.getPath()));
        }
        for (String defaultsCSSFileName : CSSDocumentCache.ALL_DEFAULTS_CSS_FILENAMES) {
            this.cssDocumentCache.remove(CSSDocumentCache.createKey(removedSWC, defaultsCSSFileName));
        }
        for (String fileInSWC : removedSWC.getFiles().keySet()) {
            this.swfCache.remove(SWFCache.createKey(removedSWC, fileInSWC));
        }
    }

    @Override
    public CSSDocumentCache getCSSDocumentCache() {
        return this.cssDocumentCache;
    }

    public static class SWCCacheKey
    extends CacheStoreKeyBase {
        private final File file;

        public SWCCacheKey(File file) {
            assert (file != null) : "SWC file can't be null.";
            this.file = file;
        }

        @Override
        public String generateKey() {
            try {
                return this.file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

