/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swc;

import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCDigest;
import com.adobe.flash.swc.ISWCLibrary;
import com.adobe.flash.swc.ISWCScript;
import com.adobe.flash.swc.io.SWCReader;
import com.adobe.flash.swf.ISWF;
import com.adobe.flash.swf.io.SWFReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;

public class SWCLibrary
implements ISWCLibrary {
    private final Map<String, ISWCScript> scripts = new LinkedHashMap<String, ISWCScript>();
    private final Set<String> keepAS3MetadataSet = new HashSet<String>();
    private final List<ISWCDigest> digests = new ArrayList<ISWCDigest>();
    private final String path;
    private final ISWF librarySWF;

    public SWCLibrary(String path, ISWF swf) {
        this.path = path;
        this.librarySWF = swf;
    }

    public SWCLibrary(String path) {
        this(path, null);
    }

    @Override
    public void addScript(ISWCScript script) {
        assert (script != null);
        String name = script.getName();
        assert (!this.scripts.containsKey(name)) : "Adding duplicated script: " + name;
        this.scripts.put(name, script);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<ISWCScript> getScripts() {
        return new ArrayList<ISWCScript>(this.scripts.values());
    }

    @Override
    public Set<String> getKeepAS3MetadataSet() {
        return this.keepAS3MetadataSet;
    }

    @Override
    public void addNameToKeepAS3MetadataSet(String name) {
        this.keepAS3MetadataSet.add(name);
    }

    @Override
    public void readSWFInputStream(SWFReader swfReader, ISWC swc) {
        ZipFile swcFile = null;
        try {
            swcFile = new ZipFile(swc.getSWCFile());
            BufferedInputStream inputStream = new BufferedInputStream(SWCReader.getInputStream(swcFile, this.path));
            swfReader.readFrom(inputStream, SWCReader.getReportingPath(swc.getSWCFile().getAbsolutePath(), this.path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (swcFile != null) {
                try {
                    swcFile.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public ISWCScript getScript(String name) {
        return this.scripts.get(name);
    }

    @Override
    public List<ISWCDigest> getDigests() {
        return this.digests;
    }

    @Override
    public ISWF getSWF() {
        return this.librarySWF;
    }

    @Override
    public void addDigest(ISWCDigest digest) {
        if (this.digests == null) {
            throw new NullPointerException("digest may not be null");
        }
        this.digests.add(digest);
    }

    public void removeDigest(ISWCDigest digest) {
        if (this.digests == null) {
            throw new NullPointerException("digest may not be null");
        }
        this.digests.remove(digest);
    }

    public String toString() {
        return this.getPath();
    }
}

