/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swc;

import com.adobe.flash.compiler.Messages;
import com.adobe.flash.compiler.clients.problems.ProblemPrinter;
import com.adobe.flash.compiler.clients.problems.ProblemQuery;
import com.adobe.flash.compiler.clients.problems.WorkspaceProblemFormatter;
import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.DependencyTypeSet;
import com.adobe.flash.compiler.common.VersionInfo;
import com.adobe.flash.compiler.config.CommandLineConfigurator;
import com.adobe.flash.compiler.config.Configuration;
import com.adobe.flash.compiler.config.ConfigurationBuffer;
import com.adobe.flash.compiler.config.ConfigurationPathResolver;
import com.adobe.flash.compiler.config.ConfigurationValue;
import com.adobe.flash.compiler.config.Configurator;
import com.adobe.flash.compiler.exceptions.ConfigurationException;
import com.adobe.flash.compiler.internal.config.annotations.Arguments;
import com.adobe.flash.compiler.internal.config.annotations.Config;
import com.adobe.flash.compiler.internal.config.annotations.InfiniteArguments;
import com.adobe.flash.compiler.internal.config.annotations.Mapping;
import com.adobe.flash.compiler.internal.config.annotations.SoftPrerequisites;
import com.adobe.flash.compiler.internal.config.localization.LocalizationManager;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.projects.LibraryDependencyGraph;
import com.adobe.flash.compiler.internal.targets.SWFTarget;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.ConfigurationProblem;
import com.adobe.flash.compiler.problems.FileIOProblem;
import com.adobe.flash.compiler.problems.InternalCompilerProblem;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.swc.catalog.XMLFormatter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SWCDepends {
    public static final String SWC_DEPENDENCY_ORDER_ELEMENT = "swc-dependency-order";
    public static final String SWC_DEPENDENCIES_ELEMENT = "swc-dependencies";
    public static final String SWC_ELEMENT = "swc";
    public static final String DEFINITION_DEPENDENCIES_ELEMENT = "definition-dependencies";
    public static final String DEFINITION_ELEMENT = "def";
    public static final String PATH_ATTRIBUTE = "path";
    public static final String ID_ATTRIBUTE = "id";
    static final String NEWLINE = System.getProperty("line.separator");
    private static final String DEFAULT_VAR = "no-default-arg";
    private static final String L10N_CONFIG_PREFIX = "com.adobe.flash.compiler.internal.config.configuration";
    protected Workspace workspace = new Workspace();
    protected FlexProject project = new FlexProject(this.workspace);
    protected DependencyConfiguration config;
    protected ProblemQuery problems = new ProblemQuery();
    protected ConfigurationBuffer configBuffer;
    protected Configurator projectConfigurator;
    protected ICompilationUnit mainCU;
    protected SWFTarget target;
    protected ITargetSettings targetSettings;
    private List<String> dependencyOrder;

    public static void main(String[] args) {
        int exitCode = SWCDepends.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        SWCDepends swcDepends = new SWCDepends();
        return swcDepends.mainNoExit(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mainNoExit(String[] args) {
        int result = 0;
        if (this.configure(args)) {
            XMLStreamWriter xmlWriter = null;
            try {
                List<String> showSwcs = this.config.getShowSwcs();
                DependencyTypeSet dependencyTypes = this.getDependencyTypeSet();
                LibraryDependencyGraph graph = this.project.createLibraryDependencyGraph(dependencyTypes);
                xmlWriter = new XMLFormatter(this.getXMLWriter());
                xmlWriter.writeStartDocument();
                xmlWriter.writeStartElement(SWC_DEPENDENCY_ORDER_ELEMENT);
                this.dependencyOrder = graph.getDependencyOrder();
                for (String swcName : this.dependencyOrder) {
                    if (!this.showSwc(swcName, showSwcs)) continue;
                    this.println(swcName + ":");
                    xmlWriter.writeStartElement(SWC_ELEMENT);
                    xmlWriter.writeAttribute(PATH_ATTRIBUTE, swcName);
                    this.printDependencies(swcName, xmlWriter, graph);
                    xmlWriter.writeEndElement();
                }
                xmlWriter.writeEndElement();
                xmlWriter.writeEndDocument();
                xmlWriter.flush();
                xmlWriter.close();
            }
            catch (IOException e) {
                FileIOProblem problem = new FileIOProblem(e);
                this.problems.add(problem);
            }
            catch (Exception e) {
                InternalCompilerProblem problem = new InternalCompilerProblem(e);
                this.problems.add(problem);
            }
            finally {
                if (xmlWriter != null) {
                    try {
                        xmlWriter.close();
                    }
                    catch (XMLStreamException e) {}
                }
            }
        } else {
            result = 1;
        }
        WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace, null);
        ProblemPrinter printer = new ProblemPrinter(formatter, System.err);
        printer.printProblems(this.problems.getFilteredProblems());
        if (this.problems.hasErrors()) {
            result = 1;
        }
        return result;
    }

    private boolean showSwc(String swcName, List<String> swcs) {
        boolean show = true;
        if (swcs.size() != 0) {
            show = false;
            for (String showSwc : swcs) {
                if (!swcName.endsWith(showSwc)) continue;
                show = true;
                break;
            }
        }
        return show;
    }

    private void printDependencies(String swcName, XMLStreamWriter xmlWriter, LibraryDependencyGraph graph) throws XMLStreamException {
        Set<String> dependencies;
        if (this.config.getShowDependencyList() && (dependencies = graph.getDependencies(swcName)).size() > 0) {
            xmlWriter.writeStartElement(SWC_DEPENDENCIES_ELEMENT);
            ArrayList<String> swcDependencies = new ArrayList<String>(graph.getDependencies(swcName));
            Collections.sort(swcDependencies, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return SWCDepends.this.dependencyOrder.indexOf(o1) - SWCDepends.this.dependencyOrder.indexOf(o2);
                }
            });
            List<String> swcFilter = this.config.getShowDependentSwcs();
            for (String swcDependency : swcDependencies) {
                if (!this.showSwc(swcDependency, swcFilter)) continue;
                this.println("\t" + swcDependency);
                xmlWriter.writeStartElement(SWC_ELEMENT);
                xmlWriter.writeAttribute(PATH_ATTRIBUTE, swcDependency);
                this.printExterns(swcName, swcDependency, xmlWriter, graph);
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
    }

    private void printExterns(String swcName, String swcDependency, XMLStreamWriter xmlWriter, LibraryDependencyGraph graph) throws XMLStreamException {
        if (this.config.getShowExterns()) {
            xmlWriter.writeStartElement(DEFINITION_DEPENDENCIES_ELEMENT);
            Map<String, DependencyTypeSet> dependencyMap = graph.getDependencySet(swcName, swcDependency);
            for (Map.Entry<String, DependencyTypeSet> entry : dependencyMap.entrySet()) {
                xmlWriter.writeStartElement(DEFINITION_ELEMENT);
                xmlWriter.writeAttribute(ID_ATTRIBUTE, entry.getKey());
                if (this.config.getShowTypes()) {
                    System.out.print("\t\t" + entry.getKey() + "\t");
                    StringBuilder sb = new StringBuilder();
                    Iterator<DependencyType> iter = entry.getValue().iterator();
                    while (iter.hasNext()) {
                        DependencyType type = iter.next();
                        System.out.print(type.getSymbol());
                        sb.append(type.getSymbol());
                        if (!iter.hasNext()) continue;
                        sb.append(",");
                        System.out.print(" ");
                    }
                    this.println("");
                    xmlWriter.writeAttribute("types", sb.toString());
                } else {
                    this.println("\t\t" + entry.getKey());
                }
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
    }

    private XMLStreamWriter getXMLWriter() throws XMLStreamException, IOException {
        Writer writer = null;
        writer = this.config.getDependencyReport() != null ? new FileWriter(this.config.getDependencyReport()) : new StringWriter();
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        assert (xmlOutputFactory != null) : "Expect XMLOutputFactory implementation.";
        return xmlOutputFactory.createXMLStreamWriter(writer);
    }

    private DependencyTypeSet getDependencyTypeSet() {
        List<String> desiredDependencies = this.config.getDesiredScriptDependencyTypes();
        if (desiredDependencies != null) {
            DependencyTypeSet dependencySet = DependencyTypeSet.noneOf();
            ArrayList<String> validDependencies = new ArrayList<String>();
            for (DependencyType type : DependencyTypeSet.allOf()) {
                validDependencies.add(String.valueOf(type.getSymbol()));
            }
            for (String desiredDependency : desiredDependencies) {
                if (!validDependencies.contains(desiredDependency)) continue;
                dependencySet.add(DependencyType.get(desiredDependency.charAt(0)));
            }
            return dependencySet;
        }
        return DependencyTypeSet.allOf();
    }

    protected boolean configure(String[] args) {
        this.projectConfigurator = this.createConfigurator();
        try {
            ConfigurationPathResolver resolver = new ConfigurationPathResolver(System.getProperty("user.dir"));
            this.projectConfigurator.setConfigurationPathResolver(resolver);
            this.projectConfigurator.setConfiguration(args, this.getConfigurationDefaultVariable());
            this.projectConfigurator.applyToProject(this.project);
            this.problems = new ProblemQuery(this.projectConfigurator.getCompilerProblemSettings());
            this.config = (DependencyConfiguration)this.projectConfigurator.getConfiguration();
            Messages.setLocale(this.config.getToolsLocale());
            this.configBuffer = this.projectConfigurator.getConfigurationBuffer();
            this.problems.addAll(this.projectConfigurator.getConfigurationProblems());
            if (this.configBuffer.getVar("version") != null) {
                this.println(VersionInfo.buildMessage());
                return false;
            }
            List<ConfigurationValue> helpVar = this.configBuffer.getVar("help");
            if (helpVar != null) {
                this.processHelp(helpVar);
                return false;
            }
            for (String fileName : this.projectConfigurator.getLoadedConfigurationFiles()) {
                this.println(Messages.getString("MXMLC.Loading_configuration_format", Collections.singletonMap("configurationName", fileName)));
            }
            this.println("");
            return !this.problems.hasErrors();
        }
        catch (Exception e) {
            ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            this.problems.add(problem);
            return false;
        }
    }

    private void processHelp(List<ConfigurationValue> helpVar) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        for (ConfigurationValue val : helpVar) {
            Iterator<String> i$ = val.getArgs().iterator();
            while (i$.hasNext()) {
                String element;
                String keyword = element = i$.next();
                while (keyword.startsWith("-")) {
                    keyword = keyword.substring(1);
                }
                keywords.add(keyword);
            }
        }
        if (keywords.size() == 0) {
            keywords.add("help");
        }
        String usages = CommandLineConfigurator.usage(this.getProgramName(), DEFAULT_VAR, this.configBuffer, keywords, LocalizationManager.get(), L10N_CONFIG_PREFIX);
        this.println(this.getStartMessage());
        this.println(usages);
    }

    protected void println(String msg) {
        System.out.println(msg);
    }

    private String getStartMessage() {
        String message = "SWC Dependency utility (swcdepends)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE + "Copyright 2012 Adobe Systems Incorporated. All rights reserved." + NEWLINE;
        return message;
    }

    private String getConfigurationDefaultVariable() {
        return DEFAULT_VAR;
    }

    private Configurator createConfigurator() {
        return new Configurator(DependencyConfiguration.class);
    }

    private String getProgramName() {
        return "swcdepends";
    }

    public static class DependencyConfiguration
    extends Configuration {
        private boolean showExterns = false;
        private boolean showDependencyList = true;
        private boolean showTypes = false;
        private List<String> desiredTypes = new LinkedList<String>();
        private List<String> showSwcs = new LinkedList<String>();
        private List<String> showDependentSwcs = new LinkedList<String>();
        private String dependencyReportFileName;

        public boolean getShowExterns() {
            return this.showExterns;
        }

        @Config
        @Mapping(value={"dependency", "show-external-classes"})
        public void setShowExternalClasses(ConfigurationValue cv, boolean showExterns) throws ConfigurationException {
            this.showExterns = showExterns;
        }

        public boolean getShowDependencyList() {
            return this.showDependencyList;
        }

        @Config
        @Mapping(value={"dependency", "show-dependency-list"})
        public void setShowDependencyList(ConfigurationValue cv, boolean showSwcDependencies) throws ConfigurationException {
            this.showDependencyList = showSwcDependencies;
        }

        public boolean getShowTypes() {
            return this.showTypes;
        }

        @Config
        @Mapping(value={"dependency", "show-types"})
        @SoftPrerequisites(value={"show-external-classes"})
        public void setShowTypes(ConfigurationValue cv, boolean showTypes) throws ConfigurationException {
            this.showTypes = showTypes;
            if (showTypes) {
                this.showExterns = true;
            }
        }

        public List<String> getDesiredScriptDependencyTypes() {
            return this.desiredTypes;
        }

        @Config(allowMultiple=true)
        @Mapping(value={"dependency", "types"})
        @Arguments(value={"type"})
        @InfiniteArguments
        public void setTypes(ConfigurationValue cfgval, String[] types) throws ConfigurationException {
            for (int i = 0; i < types.length; ++i) {
                this.desiredTypes.add(types[i]);
            }
        }

        public List<String> getShowSwcs() {
            return this.showSwcs;
        }

        @Config(allowMultiple=true)
        @Mapping(value={"dependency", "show-swcs"})
        @Arguments(value={"swc-name"})
        @InfiniteArguments
        public void setShowSwcs(ConfigurationValue cfgval, String[] swcs) throws ConfigurationException {
            for (int i = 0; i < swcs.length; ++i) {
                this.showSwcs.add(swcs[i]);
            }
        }

        public List<String> getShowDependentSwcs() {
            return this.showDependentSwcs;
        }

        @Config(allowMultiple=true)
        @Mapping(value={"dependency", "show-dependent-swcs"})
        @Arguments(value={"swc-name"})
        @InfiniteArguments
        public void setShowDependentSwcs(ConfigurationValue cfgval, String[] swcs) throws ConfigurationException {
            for (int i = 0; i < swcs.length; ++i) {
                this.showDependentSwcs.add(swcs[i]);
            }
        }

        @Config(removed=true)
        @Mapping(value={"dependency", "minimize-dependency-set"})
        public void setMinimizeDependencySet(ConfigurationValue cv, boolean minimumSet) throws ConfigurationException {
        }

        public File getDependencyReport() {
            return this.dependencyReportFileName != null ? new File(this.dependencyReportFileName) : null;
        }

        @Config
        @Mapping(value={"dependency", "dependency-report"})
        @Arguments(value={"filename"})
        public void setDependencyReport(ConfigurationValue cv, String filename) {
            this.dependencyReportFileName = this.getOutputPath(cv, filename);
        }
    }
}

