/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swc;

import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCComponent;
import com.adobe.flash.swc.ISWCFileEntry;
import com.adobe.flash.swc.ISWCLibrary;
import com.adobe.flash.swc.ISWCVersion;
import com.adobe.flash.swc.SWCVersion;
import com.adobe.flash.swc.dita.IDITAList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SWC
implements ISWC {
    private final List<ISWCComponent> components;
    private final Map<String, ISWCLibrary> libraries;
    private final Map<String, ISWCFileEntry> files;
    private final ISWCVersion version;
    private final File swcFile;
    private IDITAList ditaList;
    private boolean isANE;
    private final Collection<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();

    public SWC(File file) {
        this.components = new ArrayList<ISWCComponent>();
        this.libraries = new HashMap<String, ISWCLibrary>(1);
        this.files = new HashMap<String, ISWCFileEntry>();
        this.swcFile = file;
        this.version = new SWCVersion();
    }

    public void addComponent(ISWCComponent component) {
        assert (component != null);
        this.components.add(component);
    }

    public void addLibrary(ISWCLibrary library) {
        assert (library != null);
        this.libraries.put(library.getPath(), library);
    }

    public void addFile(ISWCFileEntry file) {
        assert (file != null);
        this.files.put(file.getPath(), file);
    }

    public void addFile(final String path, final long mod, final byte[] contentByteArray) {
        ISWCFileEntry entry = new ISWCFileEntry(){

            @Override
            public String getPath() {
                return path;
            }

            @Override
            public long getLastModified() {
                return mod;
            }

            @Override
            public String getContainingSWCPath() {
                return SWC.this.swcFile.getAbsolutePath();
            }

            @Override
            public InputStream createInputStream() throws IOException {
                return new ByteArrayInputStream(contentByteArray);
            }
        };
        this.files.put(entry.getPath(), entry);
    }

    public void setDITAList(IDITAList list) {
        assert (list != null);
        this.ditaList = list;
    }

    public void setIsANE(boolean isANE) {
        this.isANE = isANE;
    }

    @Override
    public List<ISWCComponent> getComponents() {
        return this.components;
    }

    @Override
    public Collection<ISWCLibrary> getLibraries() {
        return this.libraries.values();
    }

    @Override
    public ISWCLibrary getLibrary(String libraryPath) {
        return this.libraries.get(libraryPath);
    }

    @Override
    public ISWCVersion getVersion() {
        return this.version;
    }

    @Override
    public Map<String, ISWCFileEntry> getFiles() {
        return this.files;
    }

    @Override
    public ISWCFileEntry getFile(String filename) {
        return this.files.get(filename);
    }

    @Override
    public File getSWCFile() {
        return this.swcFile;
    }

    @Override
    public IDITAList getDITAList() {
        return this.ditaList;
    }

    @Override
    public boolean isANE() {
        return this.isANE;
    }

    public String toString() {
        return this.getSWCFile().toString();
    }

    @Override
    public Collection<ICompilerProblem> getProblems() {
        return this.problems;
    }

    public void addProblem(ICompilerProblem problem) {
        this.problems.add(problem);
    }
}

