/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.fonts;

import com.adobe.flash.compiler.problems.EmbedInvalidUnicodeRangeProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.fonts.FontDescription;
import com.adobe.flash.swf.tags.CharacterTag;
import com.adobe.fontengine.fontmanagement.FontLoader;
import java.util.Collection;
import java.util.StringTokenizer;

public abstract class FontManager {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    protected final FontLoader loader = new FontLoader();

    protected FontManager() {
    }

    public abstract CharacterTag createDefineFont(FontDescription var1, Collection<ICompilerProblem> var2);

    public int[][] getUnicodeRanges(String value, Collection<ICompilerProblem> problems) {
        int[][] ranges = null;
        if (value != null) {
            value = value.replace(';', ' ').replace('\n', ' ').replace('\r', ' ').replace('\f', ' ');
            StringTokenizer st = new StringTokenizer(value, ",");
            int count = st.countTokens();
            ranges = new int[count][2];
            FontManager.parseRanges(st, ranges, problems);
        }
        return ranges;
    }

    private static void parseRanges(StringTokenizer st, int[][] ranges, Collection<ICompilerProblem> problems) {
        int i = 0;
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).trim().toUpperCase();
            if (element.startsWith("U+")) {
                String high;
                String low;
                String range = element.substring(2).trim();
                if (range.indexOf(63) > 0) {
                    low = range.replace('?', '0');
                    high = range.replace('?', 'F');
                } else if (range.indexOf(45) > 0) {
                    low = range.substring(0, range.indexOf(45));
                    String temp = range.substring(range.indexOf(45) + 1).trim();
                    high = temp.startsWith("U+") ? temp.substring(2).trim() : temp;
                } else if (range.length() <= 8) {
                    low = range;
                    high = range;
                } else {
                    problems.add(new EmbedInvalidUnicodeRangeProblem(range));
                    return;
                }
                try {
                    ranges[i][0] = Integer.parseInt(low, 16);
                    ranges[i][1] = Integer.parseInt(high, 16);
                }
                catch (Exception ex) {
                    problems.add(new EmbedInvalidUnicodeRangeProblem(range));
                    return;
                }
                ++i;
                continue;
            }
            if (element.length() == 0) continue;
            problems.add(new EmbedInvalidUnicodeRangeProblem(element));
            return;
        }
    }

    public static boolean isItalic(int style) {
        return style == 2 || style == 3;
    }

    public static boolean isBold(int style) {
        return style == 1 || style == 3;
    }

    public static void throwFontNotFound(String alias, String fontFamily, int style, String location) {
        StringBuilder message = new StringBuilder("Font for alias '");
        message.append(alias).append("' ");
        if (style == 1) {
            message.append("with bold weight ");
        } else if (style == 2) {
            message.append("with italic style ");
        } else if (style == 3) {
            message.append("with bold weight and italic style ");
        } else {
            message.append("with plain weight and style ");
        }
        if (location != null) {
            message.append("was not found at: ").append(location.toString());
        } else {
            message.append("was not found by family name '").append(fontFamily).append("'");
        }
        throw new FontNotFoundException(message.toString());
    }

    public static final class FontNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = -2385779348825570473L;

        public FontNotFoundException(String message) {
            super(message);
        }
    }

    public static class FontManagerException
    extends RuntimeException {
        private static final long serialVersionUID = 2738969153721830047L;

        public FontManagerException(String message) {
            super(message);
        }

        public FontManagerException(FontDescription desc, Exception e) {
            this(desc.source, e);
        }

        public FontManagerException(Object source, Exception e) {
            super("The font " + source + " is not usable: " + e.getMessage(), e);
        }
    }
}

