/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.fonts;

import com.adobe.flash.fonts.FSType;
import com.adobe.flash.fonts.FontFace;
import com.adobe.flash.fonts.ZoneRecordBuilder;
import com.adobe.flash.swf.builders.ITagBuilder;
import com.adobe.flash.swf.tags.DefineFont3Tag;
import com.adobe.flash.swf.tags.DefineFontAlignZonesTag;
import com.adobe.flash.swf.tags.DefineFontNameTag;
import com.adobe.flash.swf.tags.Tag;
import com.adobe.flash.swf.types.GlyphEntry;
import com.adobe.flash.swf.types.KerningRecord;
import com.adobe.flash.swf.types.Rect;
import com.adobe.flash.swf.types.Shape;
import com.adobe.flash.swf.types.ZoneRecord;
import com.adobe.flash.utils.IntMap;
import java.util.Iterator;
import java.util.Map;

public class FontBuilder
implements ITagBuilder {
    private DefineFont3Tag tag = new DefineFont3Tag();
    private boolean flashType;
    private IntMap glyphEntryMap;
    private FontFace defaultFace;
    private double fontHeight;
    private ZoneRecordBuilder zoneRecordBuilder;
    private static boolean useLicenseTag = true;
    private static final Rect IDENTITY_RECT = new Rect(0, 0);

    private FontBuilder(boolean hasLayout, boolean useFlashType) {
        this.tag.setFontFlagsHasLayout(hasLayout);
        this.tag.setFontFlagsWideCodes(true);
        this.glyphEntryMap = new IntMap(100);
        this.flashType = useFlashType;
    }

    public FontBuilder(FontFace fontFace, String alias, boolean flashType) {
        this(true, flashType);
        this.defaultFace = fontFace;
        this.init(alias);
    }

    private void init(String alias) {
        this.fontHeight = this.defaultFace.getPointSize();
        this.tag.setFontName(alias);
        this.tag.setFontFlagsBold(this.defaultFace.isBold());
        this.tag.setFontFlagsItalic(this.defaultFace.isItalic());
        if (this.tag.isFontFlagsHasLayout()) {
            this.tag.setFontAscent(this.defaultFace.getAscent());
            this.tag.setFontDescent(this.defaultFace.getDescent());
            this.tag.setFontLeading(this.defaultFace.getLineGap());
        }
        if (this.flashType) {
            GlyphEntry adfGE = this.defaultFace.getGlyphEntry('z');
            if (adfGE == null) {
                this.flashType = false;
            }
            if ((adfGE = this.defaultFace.getGlyphEntry('Z')) == null) {
                this.flashType = false;
            }
            if ((adfGE = this.defaultFace.getGlyphEntry('l')) == null) {
                this.flashType = false;
            }
            if ((adfGE = this.defaultFace.getGlyphEntry('L')) == null) {
                this.flashType = false;
            }
            this.zoneRecordBuilder = ZoneRecordBuilder.createInstance();
            if (this.zoneRecordBuilder != null) {
                this.zoneRecordBuilder.setFontAlias(alias);
                this.zoneRecordBuilder.setFontBuilder(this);
                this.zoneRecordBuilder.setFontFace(this.defaultFace);
            } else {
                this.flashType = false;
            }
        }
        this.addChar(' ');
    }

    @Override
    public Tag build() {
        int count = this.glyphEntryMap.size();
        if (!this.tag.isFontFlagsWideCodes() && count > 255) {
            this.tag.setFontFlagsWideCodes(true);
        }
        if (this.flashType) {
            DefineFontAlignZonesTag zones = new DefineFontAlignZonesTag();
            this.tag.setZones(zones);
            ZoneRecord[] zoneTable = new ZoneRecord[count];
            zones.setZoneTable(zoneTable);
            zones.setFontTag(this.tag);
            zones.setCsmTableHint(1);
        }
        this.tag.setNumGlyphs(count);
        this.tag.setGlyphShapeTable(new Shape[count]);
        this.tag.setCodeTable(new int[count]);
        if (this.tag.isFontFlagsHasLayout()) {
            this.tag.setFontAdvanceTable(new int[count]);
            this.tag.setFontBoundsTable(new Rect[count]);
        }
        Iterator<Map.Entry<Integer, Object>> it = this.glyphEntryMap.iterator();
        for (int i = 0; it.hasNext() && i < count; ++i) {
            GlyphEntry ge = (GlyphEntry)it.next().getValue();
            if (this.flashType) {
                this.tag.getZones().getZoneTable()[i] = ge.zoneRecord;
            }
            this.tag.getGlyphShapeTable()[i] = ge.shape;
            ge.setGlyphIndex(i);
            this.tag.getCodeTable()[i] = ge.character;
            if (!this.tag.isFontFlagsHasLayout()) continue;
            this.tag.getFontAdvanceTable()[i] = ge.getGlyphAdvance();
            this.tag.getFontBoundsTable()[i] = IDENTITY_RECT;
        }
        if (this.tag.isFontFlagsHasLayout()) {
            int kerningCount = 0;
            this.tag.setKerningCount(kerningCount);
            this.tag.setFontKerningTable(new KerningRecord[kerningCount]);
        }
        String name = this.getName();
        String copyright = this.getCopyright();
        if (useLicenseTag && (this.getFSType() != null && !this.getFSType().installable || copyright != null || name != null)) {
            DefineFontNameTag license = new DefineFontNameTag();
            license.setFontTag(this.tag);
            if (name != null) {
                license.setFontName(name);
            } else {
                license.setFontName("");
            }
            if (copyright != null) {
                license.setFontCopyright(copyright);
            } else {
                license.setFontCopyright("");
            }
            this.tag.setLicense(license);
        }
        return this.tag;
    }

    public void addAllChars() {
        this.addAllChars(this.defaultFace);
    }

    public void addAllChars(FontFace face) {
        int min = face.getFirstChar();
        int count = face.getNumGlyphs();
        this.addCharset(min, count);
    }

    public void addCharset(int fromChar, int count) {
        this.addCharset(this.defaultFace, fromChar, count);
    }

    public void addCharset(FontFace face, int fromChar, int count) {
        int remaining = count;
        for (int i = fromChar; remaining > 0 && i < 65535; ++i) {
            char c = (char)i;
            GlyphEntry ge = this.addChar(face, c);
            if (ge == null) continue;
            --remaining;
        }
    }

    public void addCharset(char[] chars) {
        this.addCharset(this.defaultFace, chars);
    }

    public void addCharset(FontFace face, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            this.addChar(face, c);
        }
    }

    public void addChar(char c) {
        this.addChar(this.defaultFace, c);
    }

    public GlyphEntry addChar(FontFace face, char c) {
        GlyphEntry ge = (GlyphEntry)this.glyphEntryMap.get(c);
        if (ge == null && (ge = face.getGlyphEntry(c)) != null) {
            this.glyphEntryMap.put(c, ge);
        }
        if (this.flashType && ge != null && ge.zoneRecord == null && this.zoneRecordBuilder != null) {
            ge.zoneRecord = this.zoneRecordBuilder.build(c);
        }
        return ge;
    }

    public String getCopyright() {
        return this.defaultFace.getCopyright();
    }

    public String getName() {
        return this.defaultFace.getFamily();
    }

    public FSType getFSType() {
        return this.defaultFace.getFSType();
    }

    public void setLangcode(int code) {
        if (code >= 0 && code < 6) {
            this.tag.setLanguageCode(code);
        }
    }

    public GlyphEntry getGlyph(char c) {
        return (GlyphEntry)this.glyphEntryMap.get(c);
    }

    public double getFontHeight() {
        return this.fontHeight;
    }

    public int size() {
        return this.glyphEntryMap.size();
    }
}

