/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.fonts;

import com.adobe.flash.compiler.clients.problems.ProblemPrinter;
import com.adobe.flash.compiler.clients.problems.ProblemQuery;
import com.adobe.flash.compiler.clients.problems.WorkspaceProblemFormatter;
import com.adobe.flash.compiler.common.VersionInfo;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.fonts.DefineFont3FontManager;
import com.adobe.flash.fonts.DefineFont4FontManager;
import com.adobe.flash.fonts.FontDescription;
import com.adobe.flash.fonts.FontManager;
import com.adobe.flash.swf.Header;
import com.adobe.flash.swf.SWF;
import com.adobe.flash.swf.SWFFrame;
import com.adobe.flash.swf.io.SWFWriter;
import com.adobe.flash.swf.tags.CharacterTag;
import com.adobe.flash.swf.tags.DefineFont3Tag;
import com.adobe.flash.swf.tags.DefineFont4Tag;
import com.adobe.flash.swf.types.RGB;
import com.adobe.flash.swf.types.Rect;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;

public class Font2SWF {
    private static final int flashVersion = 10;
    private static final int framerate = 24;
    private static final int height = 8000;
    private static final int width = 11000;
    private static final int background_red = 255;
    private static final int background_green = 255;
    private static final int background_blue = 255;
    private static final boolean compressed = true;

    public static void main(String[] args) {
        try {
            Font2SWF.print("Adobe Font SWF Conversion Utility");
            Font2SWF.print(VersionInfo.buildMessage());
            Font2SWF.print("Copyright 2009-2012 Adobe Systems Incorporated. All rights reserved.");
            Font2SWF.print("");
            long startTime = System.currentTimeMillis();
            DefineFontKind fontKind = DefineFontKind.DEFINEFONT4;
            String outputPath = null;
            String fontURL = null;
            String unicodeRange = null;
            String fontAlias = null;
            boolean advancedAntiAliasing = true;
            boolean bold = false;
            boolean italic = false;
            for (int i = 0; i < args.length; ++i) {
                String arg = Font2SWF.getArg(args, i);
                if (arg.equals("-?") || arg.equals("-h") || arg.equals("-help") || arg.equals("--help")) {
                    Font2SWF.showUsage(null);
                    continue;
                }
                if (arg.equals("-3")) {
                    fontKind = DefineFontKind.DEFINEFONT3;
                    continue;
                }
                if (arg.equals("-4")) {
                    fontKind = DefineFontKind.DEFINEFONT4;
                    continue;
                }
                if (arg.equals("-i") || arg.equals("-italic")) {
                    italic = true;
                    continue;
                }
                if (arg.equals("-b") || arg.equals("-bold")) {
                    bold = true;
                    continue;
                }
                if (arg.equals("-o") || arg.equals("-output")) {
                    if ((outputPath = Font2SWF.getArg(args, ++i)).toLowerCase().endsWith(".swf")) continue;
                    outputPath = outputPath + ".swf";
                    continue;
                }
                if (arg.equals("-a") || arg.equals("-alias")) {
                    fontAlias = Font2SWF.getArg(args, ++i);
                    continue;
                }
                if (arg.equals("-u") || arg.equals("-unicode-range")) {
                    if (!(unicodeRange = Font2SWF.getArg(args, ++i)).equals("*")) continue;
                    unicodeRange = null;
                    continue;
                }
                if (arg.equals("-aaa") || arg.equals("-advanced-anti-aliasing")) {
                    String aaa = Font2SWF.getArg(args, i + 1);
                    if (aaa == null || aaa.startsWith("-")) continue;
                    ++i;
                    advancedAntiAliasing = Boolean.valueOf(aaa);
                    continue;
                }
                if (arg.startsWith("-")) {
                    Font2SWF.showUsage("Unsupported option: " + arg);
                    continue;
                }
                if (fontURL == null) {
                    File f;
                    fontURL = arg;
                    if (fontURL == null || fontURL.startsWith("http:") || fontURL.startsWith("https:") || (f = new File(fontURL)).isAbsolute()) continue;
                    String dir = System.getProperty("user.dir");
                    fontURL = dir + File.separator + fontURL;
                    continue;
                }
                Font2SWF.showUsage("Unexpected argument: " + arg);
            }
            if (Font2SWF.isEmpty(fontURL)) {
                Font2SWF.showUsage("Missing font input path");
            }
            if (outputPath == null) {
                String basePath = fontURL;
                int dotAt = fontURL.lastIndexOf(46);
                if (dotAt > 0) {
                    basePath = basePath.substring(0, dotAt);
                }
                String FILE_PREFIX = "file:///";
                if (basePath.startsWith("file:///")) {
                    basePath = basePath.substring("file:///".length());
                }
                if (basePath.startsWith("http:")) {
                    Font2SWF.showUsage("For remote fonts please use -o to specify the output path");
                }
                outputPath = basePath + ".swf";
            } else {
                File f = new File(outputPath);
                if (!f.isAbsolute()) {
                    String dir = System.getProperty("user.dir");
                    outputPath = dir + File.separator + outputPath;
                }
            }
            if (Font2SWF.isEmpty(outputPath)) {
                Font2SWF.showUsage("Output file path not specified");
            }
            if (fontURL.startsWith("http:") || fontURL.startsWith("https:")) {
                Font2SWF.print("Remote fonts no longer supported.  Please save font locally before converting to SWF.");
                System.exit(1);
            } else if (fontURL.startsWith("file:")) {
                fontURL = fontURL.replaceFirst("file:///", "");
            }
            String fontTypeName = "";
            FontManager manager = null;
            switch (fontKind) {
                case DEFINEFONT3: {
                    fontTypeName = "DefineFont3Tag";
                    manager = new DefineFont3FontManager();
                    break;
                }
                case DEFINEFONT4: {
                    fontTypeName = "DefineFont4Tag";
                    manager = new DefineFont4FontManager();
                }
            }
            FontDescription fontDesc = new FontDescription();
            fontDesc.advancedAntiAliasing = advancedAntiAliasing;
            fontDesc.alias = fontAlias;
            fontDesc.compactFontFormat = true;
            fontDesc.source = new File(fontURL).toURI();
            fontDesc.style = (bold ? 1 : 0) + (italic ? 2 : 0);
            fontDesc.unicodeRanges = unicodeRange;
            Font2SWF.print("Reading font from " + fontDesc.source);
            LinkedList<ICompilerProblem> problems = new LinkedList<ICompilerProblem>();
            CharacterTag fontTag = manager.createDefineFont(fontDesc, problems);
            if (fontTag != null) {
                if (Font2SWF.isEmpty(fontAlias)) {
                    fontAlias = Font2SWF.getFontFamilyName(fontTag);
                }
                Font2SWF.createSWF(outputPath, fontAlias, fontTag, problems);
                Font2SWF.print("Created a " + fontTypeName + " tag with the symbol " + fontAlias);
            }
            ProblemQuery problemQuery = new ProblemQuery();
            problemQuery.addAll(problems);
            Workspace workspace = new Workspace();
            ProblemPrinter printer = new ProblemPrinter(new WorkspaceProblemFormatter(workspace));
            printer.printProblems(problemQuery.getFilteredProblems());
            long duration = System.currentTimeMillis() - startTime;
            Font2SWF.print("Generated SWF at " + outputPath + " in " + duration + "ms");
        }
        catch (Usage e) {
            if (e.error != null) {
                Font2SWF.print("Error: " + e.error);
            }
            Font2SWF.printUsage();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSWF(String outputPath, String alias, CharacterTag fontTag, Collection<ICompilerProblem> problems) throws IOException {
        SWF swf = new SWF();
        swf.setUseAS3(true);
        swf.setVersion(10);
        swf.setFrameRate(24.0f);
        swf.setFrameSize(new Rect(11000, 8000));
        swf.setBackgroundColor(new RGB(255, 255, 255));
        SWFFrame frame = new SWFFrame();
        swf.addFrame(frame);
        frame.addTag(fontTag);
        frame.defineExport(fontTag, alias);
        File outputSWF = new File(outputPath);
        if (!outputSWF.exists()) {
            outputSWF.getParentFile().mkdir();
            outputSWF.createNewFile();
        }
        Header.Compression compression = Header.Compression.ZLIB;
        SWFWriter swfWriter = new SWFWriter(swf, compression);
        try {
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outputSWF));
            swfWriter.writeTo(outStream);
        }
        finally {
            IOUtils.closeQuietly((Closeable)swfWriter);
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static String getFontFamilyName(CharacterTag fontTag) {
        assert (fontTag instanceof DefineFont3Tag || fontTag instanceof DefineFont4Tag) : "only DefineFont3Tag and DefineFont4Tag supported by Font2SWF";
        String alias = "";
        if (fontTag instanceof DefineFont3Tag) {
            alias = ((DefineFont3Tag)fontTag).getFontInfo().getFontName();
        } else if (fontTag instanceof DefineFont4Tag) {
            alias = ((DefineFont4Tag)fontTag).getFontName();
        }
        return alias;
    }

    private static String getArg(String[] args, int index) throws Usage {
        if (index >= 0 && index < args.length) {
            return args[index];
        }
        Font2SWF.showUsage("Missing argument");
        return null;
    }

    private static void showUsage(String error) throws Usage {
        throw new Usage(error);
    }

    private static void printUsage() {
        Font2SWF.print("Usage: fontswf [options] <Font File>");
        Font2SWF.print("options:");
        Font2SWF.print("  -a, -alias <name>\t\t- set the font alias (defaults to font family name)");
        Font2SWF.print("  -b, -bold\t\t\t- treat the font as bold");
        Font2SWF.print("  -i, -italic\t\t\t- treat the font as italic");
        Font2SWF.print("  -o, -output <file path>\t- specify the SWF output file path");
        Font2SWF.print("  -u, -unicode-range <range>\t- set a unicode character range (default is '*' which includes all characters)");
        Font2SWF.print("  -3\t\t\t\t- generate DefineFont3 SWF tag");
        Font2SWF.print("  -4\t\t\t\t- generate DefineFont4 SWF tag (default)");
        Font2SWF.print("  -aaa, -advanced-anti-aliasing [true|false]\t- toggle advanced anti-aliasing for DefineFont3 fonts (default is true)");
        Font2SWF.print("");
        Font2SWF.print("Example:");
        Font2SWF.print("  fontswf -4 -u U+0020-007F -bold -o C:/temp/myboldfont.swf C:/assets/fonts/myboldfont.ttf");
        Font2SWF.print("");
    }

    private static void print(String line) {
        System.out.println(line);
    }

    private static class Usage
    extends Exception {
        private static final long serialVersionUID = 3682607093576649213L;
        public final String error;

        public Usage(String error) {
            super(error);
            this.error = error;
        }
    }

    public static enum DefineFontKind {
        DEFINEFONT3,
        DEFINEFONT4;

    }
}

