/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.fonts;

import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.fonts.FontDescription;
import com.adobe.flash.fonts.FontManager;
import com.adobe.flash.swf.tags.CharacterTag;
import com.adobe.flash.swf.tags.DefineFont4Tag;
import com.adobe.flash.utils.DAByteArrayOutputStream;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontResolver;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontSearchAttributes;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class DefineFont4FontManager
extends FontManager {
    @Override
    public CharacterTag createDefineFont(FontDescription desc, Collection<ICompilerProblem> problems) {
        DefineFont4Tag tag = null;
        SWFFont4Description swfFontDesc = null;
        boolean isBold = DefineFont4FontManager.isBold(desc.style);
        boolean isItalic = DefineFont4FontManager.isItalic(desc.style);
        try {
            Font[] fonts = this.loader.load(desc.source.toURL());
            if (fonts != null && fonts.length > 0) {
                if (fonts.length == 1) {
                    Font font = fonts[0];
                    swfFontDesc = font.getSWFFont4Description();
                    tag = this.createDefineFont4(desc, swfFontDesc, problems);
                } else {
                    Font firstFont;
                    FXGFontResolver nameAndStyleResolver = FontLoader.getFXGFontResolverInstance();
                    for (int i = 0; i < fonts.length; ++i) {
                        Font font = fonts[i];
                        nameAndStyleResolver.addFont(font);
                    }
                    String familyName = desc.alias;
                    FXGFontSearchAttributes attr = new FXGFontSearchAttributes(familyName, isBold, isItalic);
                    Font font = nameAndStyleResolver.findFont(attr);
                    if (font == null && (font = nameAndStyleResolver.findFont(attr = new FXGFontSearchAttributes(familyName = (swfFontDesc = (firstFont = fonts[0]).getSWFFont4Description()).getFamily(), isBold, isItalic))) == null) {
                        font = firstFont;
                    }
                    if (font != null) {
                        swfFontDesc = font.getSWFFont4Description();
                        tag = this.createDefineFont4(desc, swfFontDesc, problems);
                    }
                }
            }
        }
        catch (FontLoadingException ex) {
            throw new FontManager.FontManagerException(desc, (Exception)ex);
        }
        catch (UnsupportedFontException ex) {
            throw new FontManager.FontManagerException(desc, (Exception)ex);
        }
        catch (InvalidFontException ex) {
            throw new FontManager.FontManagerException(desc, (Exception)ex);
        }
        catch (IOException ex) {
            throw new FontManager.FontManagerException(desc, (Exception)ex);
        }
        return tag;
    }

    private DefineFont4Tag createDefineFont4(FontDescription desc, SWFFont4Description swf4Desc, Collection<ICompilerProblem> problems) throws IOException, InvalidFontException, UnsupportedFontException {
        if (desc.alias == null) {
            desc.alias = swf4Desc.getFamily();
        }
        DefineFont4Tag tag = new DefineFont4Tag();
        tag.setFontName(desc.alias);
        tag.setFontFlagsBold(DefineFont4FontManager.isBold(desc.style));
        tag.setFontFlagsItalic(DefineFont4FontManager.isItalic(desc.style));
        DAByteArrayOutputStream baos = new DAByteArrayOutputStream(4096);
        if (desc.unicodeRanges != null) {
            Iterator<Integer> iterator = this.getCodePointIterator(desc.unicodeRanges, problems);
            swf4Desc.streamFontData(iterator, baos);
        } else {
            swf4Desc.streamFontData(baos);
        }
        tag.setFontData(baos.getDirectByteArray());
        tag.setFontFlagsHasFontData(true);
        return tag;
    }

    private Iterator<Integer> getCodePointIterator(String unicodeRanges, Collection<ICompilerProblem> problems) {
        int[][] charRanges = this.getUnicodeRanges(unicodeRanges, problems);
        Iterator<Integer> iterator = new CodePointIterator(charRanges);
        iterator = new SWFFont4Description.TLFSubsetCompletionIterator(iterator);
        iterator = new SWFFont4Description.FTESubsetCompletionIterator(iterator);
        return iterator;
    }

    private static class CodePointIterator
    implements Iterator<Integer> {
        private int i = 0;
        private int c = 0;
        private int rowCount = 0;
        private int rowEnd = 0;
        private int rowStart = 0;
        private int[][] chars;

        public CodePointIterator(int[][] charRanges) {
            this.chars = charRanges;
            if (this.chars != null) {
                int[] row;
                this.rowCount = this.chars.length;
                if (this.rowCount > 0 && (row = this.chars[this.i]) != null && row.length == 2) {
                    this.rowStart = row[0];
                    this.rowEnd = row[1];
                    this.c = this.rowStart;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.i < this.rowCount && this.c <= this.rowEnd;
        }

        @Override
        public Integer next() {
            Integer value = null;
            if (this.i < this.rowCount && this.c <= this.rowEnd) {
                value = this.c++;
            }
            if (this.c > this.rowEnd) {
                int[] row;
                ++this.i;
                if (this.i < this.rowCount && (row = this.chars[this.i]) != null && row.length == 2) {
                    this.rowStart = row[0];
                    this.rowEnd = row[1];
                    this.c = this.rowStart;
                }
            }
            return value;
        }

        @Override
        public void remove() {
        }
    }
}

