/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.fonts;

import com.adobe.flash.fonts.FSType;
import com.adobe.flash.fonts.FontFace;
import com.adobe.flash.swf.types.GlyphEntry;
import com.adobe.flash.utils.IntMapLRUCache;

public abstract class CachedFontFace
extends FontFace {
    protected int style;
    protected FSType fsType;
    protected String copyright;
    protected String trademark;
    public static final short MAX_GLYPHS_PER_FACE = 1000;
    public static final short GLYPH_CACHE_PURGE = 10;
    public final GlyphCache glyphCache = new GlyphCache(this, 200, 1000, 10);

    protected CachedFontFace() {
    }

    protected CachedFontFace(int style, FSType fsType, String copyright, String trademark) {
        this();
        this.style = style;
        this.fsType = fsType;
        this.copyright = copyright;
        this.trademark = trademark;
    }

    @Override
    public boolean isBold() {
        return CachedFontFace.isBold(this.style);
    }

    @Override
    public boolean isItalic() {
        return CachedFontFace.isItalic(this.style);
    }

    @Override
    public FSType getFSType() {
        return this.fsType;
    }

    @Override
    public void setFSType(FSType t) {
        this.fsType = t;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public void setCopyright(String c) {
        this.copyright = c;
    }

    @Override
    public String getTrademark() {
        return this.trademark;
    }

    @Override
    public void setTrademark(String t) {
        this.trademark = t;
    }

    public static boolean isBold(int style) {
        return style == 1 || style == 3;
    }

    public static boolean isItalic(int style) {
        return style == 2 || style == 3;
    }

    public static int guessStyleFromSubFamilyName(String subFamilyName) {
        int style = 0;
        if (subFamilyName != null) {
            if ((subFamilyName = subFamilyName.toLowerCase()).indexOf("regular") != -1) {
                style = 0;
            }
            if (subFamilyName.indexOf("bold") != -1) {
                ++style;
            }
            if (subFamilyName.indexOf("italic") != -1 || subFamilyName.indexOf("oblique") != -1) {
                style += 2;
            }
        }
        return style;
    }

    protected abstract GlyphEntry createGlyphEntry(char var1);

    protected abstract GlyphEntry createGlyphEntry(char var1, char var2);

    static class GlyphCache
    extends IntMapLRUCache {
        private CachedFontFace fontFace;

        GlyphCache(CachedFontFace face, int initialSize, int maxSize, int purgeSize) {
            super(initialSize, maxSize, purgeSize);
            this.fontFace = face;
        }

        @Override
        public Object fetch(int key) {
            char c = (char)key;
            if (this.fontFace.canDisplay(c)) {
                return this.fontFace.createGlyphEntry(c, c);
            }
            return null;
        }
    }
}

