/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.problems.collections;

import com.adobe.flash.compiler.clients.problems.IProblemFilter;
import com.adobe.flash.compiler.problems.ICompilerProblem;

public class CompositeProblemFilter
implements IProblemFilter {
    private IProblemFilter left;
    private IProblemFilter right;
    private CompositionOperator operator;

    @Override
    public boolean accept(ICompilerProblem problem) {
        switch (this.operator) {
            case And: {
                return this.left.accept(problem) && this.right.accept(problem);
            }
            case Or: {
                return this.left.accept(problem) || this.right.accept(problem);
            }
            case Not: {
                return !this.left.accept(problem);
            }
        }
        assert (false) : "Uncovered composition case " + (Object)((Object)this.operator);
        return false;
    }

    private CompositeProblemFilter(IProblemFilter left, IProblemFilter right, CompositionOperator operator) {
        this.left = left;
        this.right = right;
        this.operator = operator;
        assert (left != null);
        if (operator == CompositionOperator.Not ? !$assertionsDisabled && right != null : !$assertionsDisabled && right == null) {
            throw new AssertionError();
        }
    }

    public static IProblemFilter and(IProblemFilter left, IProblemFilter right) {
        return new CompositeProblemFilter(left, right, CompositionOperator.And);
    }

    public static IProblemFilter or(IProblemFilter left, IProblemFilter right) {
        return new CompositeProblemFilter(left, right, CompositionOperator.Or);
    }

    public static IProblemFilter not(IProblemFilter filter) {
        return new CompositeProblemFilter(filter, null, CompositionOperator.Not);
    }

    public static enum CompositionOperator {
        And,
        Or,
        Not;

    }
}

