/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.problems;

import com.adobe.flash.compiler.exceptions.ConfigurationException;
import com.adobe.flash.compiler.problems.CompilerProblem;

public class ConfigurationProblem
extends CompilerProblem {
    public static final String DESCRIPTION = "${reason}.\n${location}";
    public static final int errorCode = 1319;
    public final String reason;
    public final String location;

    public ConfigurationProblem(String fileName, int line, String reason) {
        this(fileName, -1, -1, line, -1, reason);
    }

    public ConfigurationProblem(String fileName, int start, int end, int line, int column, String reason) {
        super(fileName, start, end, line > 0 ? line - 1 : line, column, !"command line".equals(fileName));
        this.reason = reason;
        this.location = fileName != null && !"command line".equals(fileName) ? String.format("%s (line: %d)", fileName, line) : "";
    }

    public ConfigurationProblem(ConfigurationException e) {
        this(e.getSource(), -1, -1, e.getLine(), e.getColumn(), e.getMessage());
    }
}

