/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.problems;

import com.adobe.flash.compiler.clients.problems.ProblemFormatter;
import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.problems.CompilerProblemClassification;
import com.adobe.flash.compiler.problems.CompilerProblemSeverity;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.annotations.DefaultSeverity;
import com.adobe.flash.compiler.problems.annotations.ProblemClassification;
import com.adobe.flash.utils.FilenameNormalization;

@ProblemClassification(value=CompilerProblemClassification.DEFAULT)
@DefaultSeverity(value=CompilerProblemSeverity.ERROR)
public abstract class CompilerProblem
implements ICompilerProblem {
    private final String sourcePath;
    private final int start;
    private final int end;
    private final int line;
    private final int column;

    public CompilerProblem(String sourcePath, int start, int end, int line, int column, boolean normalizeFilePath) {
        if (sourcePath != null && normalizeFilePath) {
            sourcePath = FilenameNormalization.normalize(sourcePath);
        }
        this.sourcePath = sourcePath;
        this.start = start;
        this.end = end;
        this.line = line;
        this.column = column;
    }

    public CompilerProblem(String sourcePath, int start, int end, int line, int column) {
        this(sourcePath, start, end, line, column, true);
    }

    public CompilerProblem(String sourcePath) {
        this(sourcePath, -1, -1, -1, -1, true);
    }

    public CompilerProblem() {
        this(null, -1, -1, -1, -1, true);
    }

    public CompilerProblem(ISourceLocation site) {
        this(site.getSourcePath(), site.getStart(), site.getEnd(), site.getLine(), site.getColumn());
    }

    public CompilerProblem(IDefinition site) {
        this(site.getSourcePath(), site.getNameStart(), site.getNameEnd(), site.getNameLine(), site.getNameColumn());
    }

    public CompilerProblem(ASToken site) {
        this(site.getSourcePath(), site.getLocalStart(), site.getLocalEnd(), site.getLine(), site.getColumn());
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getAbsoluteStart() {
        return this.start;
    }

    @Override
    public int getAbsoluteEnd() {
        return this.end;
    }

    public String toString() {
        return ProblemFormatter.DEFAULT_FORMATTER.format(this);
    }
}

