/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.problems;

import com.adobe.flash.compiler.internal.tree.as.LabeledStatementNode;
import com.adobe.flash.compiler.problems.CodegenProblem;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Collection;

public final class AmbiguousGotoTargetProblem
extends CodegenProblem {
    public static final String DESCRIPTION = "Target of goto statement was ambiguous, possible targets (line:column): ${targets}";
    public static final int errorCode = 1306;
    public final String targets;

    public AmbiguousGotoTargetProblem(IASNode site, Collection<LabeledStatementNode> gotoLabels) {
        super(site);
        Iterable locationStrings = Iterables.transform(gotoLabels, (Function)new Function<LabeledStatementNode, String>(){

            public String apply(LabeledStatementNode targetLocation) {
                return Integer.toString(targetLocation.getLine() + 1) + ":" + Integer.toString(targetLocation.getColumn() + 1);
            }
        });
        this.targets = Joiner.on((String)", ").join(locationStrings);
    }
}

