/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.mxml;

import com.adobe.flash.compiler.common.PrefixMap;
import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.common.XMLName;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.mxml.EntityProcessor;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLToken;
import com.adobe.flash.compiler.mxml.MXMLData;
import com.adobe.flash.compiler.mxml.MXMLDatabindingValue;
import com.adobe.flash.compiler.mxml.MXMLEntityValue;
import com.adobe.flash.compiler.mxml.MXMLStateSplitter;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeValue;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextValue;
import com.adobe.flash.compiler.parsing.IMXMLToken;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.SyntaxProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;

public class MXMLTagAttributeData
extends SourceLocation {
    protected MXMLTagData parent;
    protected String attributeName;
    protected int valueStart;
    protected int valueLine;
    protected int valueColumn;
    private MXMLTagAttributeValue[] values = new MXMLTagAttributeValue[0];
    protected String stateName;
    protected int stateStart;
    protected String uri;

    MXMLTagAttributeData(MXMLToken nameToken, ListIterator<MXMLToken> tokenIterator, MXMLDialect mxmlDialect, IFileSpecification spec, Collection<ICompilerProblem> problems) {
        this.setStart(nameToken.getStart());
        this.setLine(nameToken.getLine());
        this.setColumn(nameToken.getColumn());
        this.setEnd(nameToken.getEnd());
        MXMLStateSplitter splitState = new MXMLStateSplitter(nameToken, mxmlDialect, problems, spec);
        this.attributeName = splitState.baseName;
        if (splitState.stateName != null) {
            this.stateName = splitState.stateName;
            this.stateStart = nameToken.getStart() + splitState.stateNameOffset;
        }
        MXMLToken token = null;
        if (tokenIterator.hasNext()) {
            token = tokenIterator.next();
            if (token.getType() != 144) {
                problems.add(new SyntaxProblem(token));
                tokenIterator.previous();
                return;
            }
            this.valueStart = token.getEnd() + 1;
            this.valueLine = token.getLine();
            this.valueColumn = token.getColumn();
        }
        ArrayList<MXMLTagAttributeValue> values = new ArrayList<MXMLTagAttributeValue>(3);
        while (tokenIterator.hasNext()) {
            token = tokenIterator.next();
            if (token.getType() == 150) {
                values.add(new MXMLDatabindingValue(token, tokenIterator, this));
                continue;
            }
            if (token.getType() == 137) {
                values.add(new MXMLTextValue(token, this));
                continue;
            }
            if (token.isEntity()) {
                values.add(new MXMLEntityValue(token, this));
                continue;
            }
            if (!MXMLToken.isTagEnd(token.getType()) && token.getType() != 141) {
                tokenIterator.previous();
                problems.add(new SyntaxProblem(token));
                break;
            }
            tokenIterator.previous();
            break;
        }
        this.values = values.toArray(new MXMLTagAttributeValue[0]);
        if (this.values.length > 0) {
            MXMLTagAttributeValue value = this.values[0];
            this.valueStart = value.getAbsoluteStart();
            this.valueLine = value.getLine();
            this.valueColumn = value.getColumn();
            int valueEnd = this.getValueEnd();
            this.setEnd(valueEnd + 1);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.buildAttributeString(false);
        return sb.toString();
    }

    public String buildAttributeString(boolean skipSrcPath) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append('=');
        sb.append('\"');
        sb.append(this.getRawValue());
        sb.append('\"');
        sb.append(' ');
        if (skipSrcPath) {
            sb.append(this.getOffsetsString());
        } else {
            sb.append(super.toString());
        }
        return sb.toString();
    }

    public MXMLTagData getParent() {
        return this.parent;
    }

    public void setParent(MXMLTagData parent) {
        this.parent = parent;
        this.setSourcePath(parent.getSourcePath());
    }

    public void adjustOffsets(int offsetAdjustment) {
        if (this.attributeName != null) {
            this.setStart(this.getAbsoluteStart() + offsetAdjustment);
            this.setEnd(this.getAbsoluteEnd() + offsetAdjustment);
        }
        if (this.hasValue()) {
            this.valueStart += offsetAdjustment;
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].setStart(this.values[i].getAbsoluteStart() + offsetAdjustment);
                this.values[i].setEnd(this.values[i].getAbsoluteEnd() + offsetAdjustment);
            }
        }
        if (this.stateName != null) {
            this.stateStart += offsetAdjustment;
        }
    }

    public String getName() {
        return this.attributeName;
    }

    public String getStateName() {
        return this.stateName != null ? this.stateName : "";
    }

    public boolean hasState() {
        return this.stateName != null;
    }

    public boolean hasValue() {
        return this.values.length > 0;
    }

    public MXMLTagAttributeValue[] getValues() {
        return this.values;
    }

    public String getValueWithQuotes() {
        StringBuilder value = new StringBuilder();
        int size = this.values.length;
        SourceLocation lastData = null;
        for (int i = 0; i < size; ++i) {
            MXMLTagAttributeValue data = this.values[i];
            if (lastData != null) {
                int s = 0;
                while (s < data.getAbsoluteStart() - lastData.getAbsoluteEnd()) {
                    value.append(" ");
                    ++i;
                }
            }
            value.append(data.getContent());
        }
        return value.toString();
    }

    public String getRawValue() {
        String value = this.getValueWithQuotes();
        if (value != null && value.length() > 0) {
            value = value.charAt(0) == value.charAt(value.length() - 1) && value.length() != 1 ? value.substring(1, value.length() - 1) : value.substring(1);
        }
        return value;
    }

    public ISourceFragment[] getValueFragments(Collection<ICompilerProblem> problems) {
        String value = this.getRawValue();
        SourceLocation location = this.getValueLocation();
        MXMLDialect mxmlDialect = this.getMXMLDialect();
        return EntityProcessor.parse(value, location, mxmlDialect, problems);
    }

    public IMXMLToken getRawValueToken() {
        String value;
        if (this.hasState() && this.values.length == 1 && this.values[0] instanceof MXMLTextValue && (value = this.getRawValue()) != null) {
            return new MXMLToken(137, this.getValueStart() + 1, this.getValueStart() + 1 + value.length(), -1, -1, value);
        }
        return null;
    }

    public IFileSpecification getSource() {
        return this.getParent().getSource();
    }

    public final int getNameLine() {
        return this.getLine();
    }

    public final int getNameColumn() {
        return this.getColumn();
    }

    public int getNameStart() {
        return this.getAbsoluteStart();
    }

    public int getNameEnd() {
        return this.getAbsoluteStart() + this.attributeName.length();
    }

    public int getValueStart() {
        return this.hasValue() ? this.valueStart + 1 : 0;
    }

    public int getValueEnd() {
        if (this.hasValue()) {
            String lastContent = this.values[this.values.length - 1].getContent();
            if (lastContent.charAt(0) == lastContent.charAt(lastContent.length() - 1)) {
                return this.getValueStart() + lastContent.length() - 2;
            }
            return this.getValueStart() + lastContent.length();
        }
        return -1;
    }

    public int getValueLine() {
        return this.hasValue() ? this.valueLine : 0;
    }

    public int getValueColumn() {
        return this.hasValue() ? this.valueColumn + 1 : 0;
    }

    public SourceLocation getValueLocation() {
        return new SourceLocation(this.getSourcePath(), this.getValueStart(), this.getValueEnd(), this.getValueLine(), this.getValueColumn());
    }

    public int getStateStart() {
        return this.stateName != null ? this.stateStart : 0;
    }

    public int getStateEnd() {
        return this.stateName != null ? this.stateStart + this.stateName.length() : 0;
    }

    protected boolean valueIsWellFormed() {
        if (this.hasValue()) {
            String lastContent = this.values[this.values.length - 1].getContent();
            return lastContent.charAt(0) == lastContent.charAt(lastContent.length() - 1);
        }
        return false;
    }

    public PrefixMap getCompositePrefixMap() {
        return this.parent.getCompositePrefixMap();
    }

    public boolean isInsideName(int offset) {
        if (this.attributeName != null) {
            return MXMLData.contains(this.getNameStart(), this.getNameEnd(), offset);
        }
        return false;
    }

    public boolean isInsideStateName(int offset) {
        if (this.stateName != null) {
            return MXMLData.contains(this.getStateStart(), this.getStateEnd(), offset);
        }
        return false;
    }

    public boolean isInsideValue(int offset) {
        if (this.hasValue()) {
            return MXMLData.contains(this.getValueStart() - 1, this.getValueEnd(), offset);
        }
        return false;
    }

    public String getPrefix() {
        String name = this.getName();
        int i = name.indexOf(58);
        return i != -1 ? name.substring(0, i) : null;
    }

    public String getShortName() {
        String name = this.getName();
        int i = name.indexOf(58);
        return i != -1 ? name.substring(i + 1) : name;
    }

    public XMLName getXMLName() {
        return new XMLName(this.getURI(), this.getShortName());
    }

    public String getURI() {
        if (this.uri == null) {
            String prefix = this.getPrefix();
            if (prefix == null) {
                return null;
            }
            for (MXMLTagData lookingAt = this.parent; lookingAt != null && lookingAt.getParent() != null; lookingAt = lookingAt.getParentTag()) {
                PrefixMap depth = lookingAt.getParent().getPrefixMapForData(lookingAt);
                if (depth == null || !depth.containsPrefix(prefix)) continue;
                this.uri = depth.getNamespaceForPrefix(prefix);
                break;
            }
        }
        return this.uri;
    }

    void invalidateURI() {
        this.uri = null;
    }

    public MXMLDialect getMXMLDialect() {
        return this.getParent().getParent().getMXMLDialect();
    }

    public boolean isSpecialAttribute(String name) {
        String languageURI = this.getMXMLDialect().getLanguageNamespace();
        return this.getName().equals(name) && (this.getPrefix() == null || this.getURI() == languageURI);
    }

    public boolean verify() {
        assert (this.getSourcePath() != null) : "Attribute has null source path: " + this.toString();
        assert (this.getStart() != -1) : "Attribute has unknown start: " + this.toString();
        assert (this.getEnd() != -1) : "Attribute has unknown end: " + this.toString();
        assert (this.getLine() != -1) : "Attribute has unknown line: " + this.toString();
        assert (this.getColumn() != -1) : "Attribute has unknown column: " + this.toString();
        return true;
    }
}

