/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.mxml;

import com.adobe.flash.compiler.mxml.IMXMLEntityData;
import com.adobe.flash.compiler.mxml.IMXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeValue;
import com.adobe.flash.compiler.parsing.IMXMLToken;
import java.util.HashMap;
import java.util.Map;

public class MXMLEntityValue
extends MXMLTagAttributeValue
implements IMXMLTextData,
IMXMLEntityData {
    private static final Map<String, String> NAMED_ENTITIES = new HashMap<String, String>(5);
    private final String content;
    private final int type;

    static final String getDecodedContent(String content, int type) {
        switch (type) {
            case 133: {
                return NAMED_ENTITIES.get(content);
            }
            case 135: {
                return String.valueOf(Integer.parseInt(content.substring(3, content.length() - 1), 16));
            }
            case 134: {
                return String.valueOf(Integer.parseInt(content.substring(3, content.length() - 1)));
            }
        }
        return null;
    }

    MXMLEntityValue(IMXMLToken token, MXMLTagAttributeData parent) {
        super(parent);
        this.content = token.getText();
        this.type = token.getType();
        this.setStart(token.getStart());
        this.setEnd(token.getEnd());
        this.setColumn(token.getColumn());
        this.setLine(token.getLine());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("|");
        sb.append(this.getContent());
        sb.append("| ");
        sb.append(this.getLine());
        sb.append(" ");
        sb.append(this.getColumn());
        return sb.toString();
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public IMXMLTextData.TextType getTextType() {
        return IMXMLTextData.TextType.ENTITY;
    }

    @Override
    public String getDecodedContent() {
        return MXMLEntityValue.getDecodedContent(this.content, this.type);
    }

    static {
        NAMED_ENTITIES.put("&amp;", "&");
        NAMED_ENTITIES.put("&apos;", "'");
        NAMED_ENTITIES.put("&gt;", ">");
        NAMED_ENTITIES.put("&lt;", "<");
        NAMED_ENTITIES.put("&quot;", "\"");
    }
}

