/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.mxml;

import com.adobe.flash.compiler.internal.parsing.mxml.MXMLToken;
import com.adobe.flash.compiler.mxml.IMXMLDatabindingData;
import com.adobe.flash.compiler.mxml.IMXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeValue;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.parsing.ICMToken;
import java.util.ArrayList;
import java.util.ListIterator;

public class MXMLDatabindingValue
extends MXMLTagAttributeValue
implements IMXMLDatabindingData {
    private ArrayList<IASToken> tokens = new ArrayList(5);

    MXMLDatabindingValue(MXMLToken start, ListIterator<MXMLToken> iterator, MXMLTagAttributeData parent) {
        super(parent);
        this.setStart(start.getStart());
        this.setColumn(start.getColumn());
        this.setLine(start.getLine());
        while (iterator.hasNext()) {
            MXMLToken token = iterator.next();
            this.setEnd(token.getEnd());
            if (!token.isASToken()) break;
            this.tokens.add(token);
        }
    }

    MXMLDatabindingValue(MXMLToken start, ListIterator<MXMLToken> iterator) {
        this(start, iterator, null);
    }

    @Override
    public String getContent() {
        StringBuilder builder = new StringBuilder();
        int size = this.tokens.size();
        ICMToken lastToken = null;
        for (int i = 0; i < size; ++i) {
            IASToken currentToken = this.tokens.get(i);
            if (lastToken != null) {
                int spaces = currentToken.getStart() - lastToken.getEnd();
                for (int s = 0; s < spaces; ++s) {
                    builder.append(" ");
                }
            }
            builder.append(currentToken.getText());
            lastToken = currentToken;
        }
        return builder.toString();
    }

    @Override
    public IMXMLTextData.TextType getTextType() {
        return IMXMLTextData.TextType.DATABINDING;
    }

    @Override
    public IASToken[] getDatabindingContent() {
        return this.tokens.toArray(new IASToken[0]);
    }
}

