/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.mxml;

import com.adobe.flash.compiler.common.MutablePrefixMap;
import com.adobe.flash.compiler.common.PrefixMap;
import com.adobe.flash.compiler.filespecs.FileSpecification;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.mxml.BalancingMXMLProcessor;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLToken;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLTokenizer;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLUnitDataIterator;
import com.adobe.flash.compiler.mxml.MXMLDatabindingData;
import com.adobe.flash.compiler.mxml.MXMLEntityData;
import com.adobe.flash.compiler.mxml.MXMLInstructionData;
import com.adobe.flash.compiler.mxml.MXMLTagBlobData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLUnitData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.SyntaxProblem;
import com.adobe.flash.utils.FastStack;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class MXMLData {
    private String path = null;
    private MXMLUnitData[] units;
    private boolean wasRepaired;
    private boolean shouldRepair = true;
    private HashMap<MXMLTagData, PrefixMap> nsMap;
    private Cursor cursor;
    private MXMLDialect mxmlDialect;
    private Collection<ICompilerProblem> problems = new ArrayList<ICompilerProblem>(2);
    private boolean fullContent = true;

    public MXMLData(List<MXMLToken> tokens, PrefixMap map, IFileSpecification fileSpec) {
        this.path = fileSpec.getPath();
        this.init(tokens, map);
    }

    public MXMLData(List<MXMLToken> tokens, PrefixMap map, IFileSpecification fileSpec, boolean shouldRepair) {
        this.path = fileSpec.getPath();
        this.shouldRepair = false;
        this.init(tokens, map);
    }

    public MXMLData(int startOffset, Reader mxmlText, IFileSpecification fileSpec) {
        TokenizerPayload payload = this.getTokens(startOffset, mxmlText);
        this.path = fileSpec.getPath();
        this.init(payload.getMXMLTokens(), payload.getPrefixMap());
    }

    public MXMLData(int startOffset, Reader mxmlText, String path, boolean fullContent) {
        this.fullContent = fullContent;
        TokenizerPayload payload = this.getTokens(startOffset, mxmlText);
        this.path = path;
        this.init(payload.getMXMLTokens(), payload.getPrefixMap());
    }

    public MXMLData(Reader mxmlText, IFileSpecification fileSpec) {
        this(0, mxmlText, fileSpec);
    }

    public MXMLData(Reader mxmlText, String path) {
        this(0, mxmlText, path != null ? path : null, true);
    }

    public MXMLData(IFileSpecification specification) {
        try {
            this.path = specification.getPath();
            TokenizerPayload payload = this.getTokens(specification.createReader());
            this.init(payload.getMXMLTokens(), payload.getPrefixMap());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void init(List<MXMLToken> tokens, PrefixMap map) {
        this.mxmlDialect = MXMLDialect.getMXMLDialect(map);
        this.initializeFromTokens(tokens);
    }

    public void updateMXMLVersion(PrefixMap map) {
        this.mxmlDialect = MXMLDialect.getMXMLDialect(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrefixMap getRootNamespaces(Reader reader) throws IOException {
        MXMLTokenizer tokenizer = new MXMLTokenizer();
        try {
            tokenizer.setReader(reader);
            PrefixMap prefixMap = tokenizer.getRootTagPrefixMap().clone();
            return prefixMap;
        }
        finally {
            tokenizer.close();
        }
    }

    protected TokenizerPayload getTokens(Reader reader) {
        return this.getTokens(0, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TokenizerPayload getTokens(int startOffset, Reader reader) {
        List<MXMLToken> tokens = null;
        MXMLTokenizer tokenizer = new MXMLTokenizer(startOffset);
        try {
            tokenizer.setIsRepairing(true);
            tokens = tokenizer.parseTokens(reader);
            this.wasRepaired = tokenizer.tokensWereRepaired();
            TokenizerPayload tokenizerPayload = new TokenizerPayload(tokens, tokenizer.getPrefixMap());
            return tokenizerPayload;
        }
        finally {
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
    }

    public MXMLDialect getMXMLDialect() {
        return this.mxmlDialect;
    }

    public PrefixMap getPrefixMapForData(MXMLTagData data) {
        MXMLTagData openTagData;
        PrefixMap result = this.nsMap.get(data);
        if (result != null) {
            return result;
        }
        if (data.isCloseTag() && (openTagData = data.getParent().findTagOrSurroundingTagContainingOffset(data.getAbsoluteStart())) != null) {
            return this.nsMap.get(openTagData);
        }
        return null;
    }

    void removePrefixMappingForTag(MXMLTagData data) {
        this.nsMap.remove(data);
    }

    void clearPrefixMappings() {
        this.nsMap.clear();
    }

    public void setPrefixMappings(HashMap<MXMLTagData, PrefixMap> map) {
        if (this.nsMap != null) {
            this.nsMap.clear();
        }
        this.nsMap = map;
    }

    public Map<MXMLTagData, PrefixMap> getTagToPrefixMap() {
        return this.nsMap;
    }

    public PrefixMap getDocumentPrefixMap() {
        MutablePrefixMap map = new MutablePrefixMap();
        for (PrefixMap tagMap : this.nsMap.values()) {
            assert (tagMap != null);
            map.addAll(tagMap);
        }
        return map.toImmutable();
    }

    public PrefixMap getRootTagPrefixMap() {
        MXMLTagData rootTag = this.getRootTag();
        if (rootTag != null) {
            return this.nsMap.get(rootTag);
        }
        return null;
    }

    public Collection<ICompilerProblem> getProblems() {
        return this.problems;
    }

    public boolean hasProblems() {
        return this.problems.size() > 0;
    }

    public boolean isDataRepaired() {
        return this.wasRepaired;
    }

    public void setWasRepaired(boolean wasRepaired) {
        this.wasRepaired = wasRepaired;
    }

    public IFileSpecification getFileSpecification() {
        return new FileSpecification(this.path);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected void initializeFromTokens(List<MXMLToken> tokens) {
        this.cursor = new Cursor();
        this.parse(this, tokens, this.mxmlDialect, this.problems);
        this.cursor.reset();
    }

    private void parse(MXMLData data, List<MXMLToken> tokens, MXMLDialect dialect, Collection<ICompilerProblem> problems) {
        ArrayList<MXMLUnitData> units = new ArrayList<MXMLUnitData>(tokens.size() / 6);
        this.nsMap = new HashMap();
        MXMLUnitData unit = null;
        MXMLToken currentComment = null;
        FastStack<Integer> depth = new FastStack<Integer>(tokens.size() / 8);
        FileSpecification spec = new FileSpecification(data.getPath() != null ? data.getPath() : "");
        depth.setStackDecorator(new FastStack.IFastStackDecorator<Integer>(){

            @Override
            public Integer decorate(Integer e) {
                if (e == null) {
                    return -1;
                }
                return e;
            }
        });
        int index = -1;
        int balancingIndex = 0;
        depth.push(index);
        ListIterator<MXMLToken> tokenIterator = tokens.listIterator();
        BalancingMXMLProcessor processor = new BalancingMXMLProcessor(this.getFileSpecification(), problems);
        block10: while (tokenIterator.hasNext()) {
            MXMLToken token = tokenIterator.next();
            switch (token.getType()) {
                case 28: {
                    currentComment = token;
                    unit = new MXMLTextData(token);
                    units.add(unit);
                    ++index;
                    if (!this.fullContent) continue block10;
                    unit.setParentUnitDataIndex((Integer)depth.peek());
                    unit.setLocation(data, index);
                    continue block10;
                }
                case 129: 
                case 130: 
                case 131: {
                    unit = new MXMLTextData(token);
                    units.add(unit);
                    ++index;
                    if (!this.fullContent) continue block10;
                    unit.setParentUnitDataIndex((Integer)depth.peek());
                    unit.setLocation(data, index);
                    continue block10;
                }
                case 138: {
                    unit = new MXMLTagData();
                    MutablePrefixMap map = ((MXMLTagData)unit).init(this, token, tokenIterator, dialect, spec, problems);
                    ((MXMLTagData)unit).setCommentToken(currentComment);
                    currentComment = null;
                    units.add(unit);
                    ++index;
                    if (this.fullContent) {
                        unit.setParentUnitDataIndex((Integer)depth.peek());
                        unit.setLocation(data, index);
                        if (!((MXMLTagData)unit).isEmptyTag()) {
                            processor.addOpenTag((MXMLTagData)unit, balancingIndex);
                        }
                    }
                    if (map != null) {
                        this.nsMap.put((MXMLTagData)unit, map.toImmutable());
                    }
                    if (((MXMLTagData)unit).isEmptyTag()) continue block10;
                    depth.push(index);
                    ++balancingIndex;
                    continue block10;
                }
                case 139: {
                    unit = new MXMLTagData();
                    ((MXMLTagData)unit).init(this, token, tokenIterator, dialect, spec, problems);
                    ((MXMLTagData)unit).setCommentToken(currentComment);
                    if (!((MXMLTagData)unit).isEmptyTag()) {
                        depth.pop();
                        --balancingIndex;
                    }
                    ++index;
                    if (this.fullContent) {
                        unit.setLocation(data, index);
                        unit.setParentUnitDataIndex((Integer)depth.peek());
                        processor.addCloseTag((MXMLTagData)unit, balancingIndex);
                    }
                    currentComment = null;
                    units.add(unit);
                    continue block10;
                }
                case 136: {
                    unit = new MXMLTextData(token);
                    units.add(unit);
                    ++index;
                    if (!this.fullContent) continue block10;
                    unit.setParentUnitDataIndex((Integer)depth.peek());
                    unit.setLocation(data, index);
                    continue block10;
                }
                case 30: {
                    unit = new MXMLTagBlobData(token);
                    units.add(unit);
                    ++index;
                    if (!this.fullContent) continue block10;
                    unit.setParentUnitDataIndex((Integer)depth.peek());
                    unit.setLocation(data, index);
                    continue block10;
                }
                case 150: {
                    unit = new MXMLDatabindingData(token, tokenIterator);
                    units.add(unit);
                    ++index;
                    if (!this.fullContent) continue block10;
                    unit.setParentUnitDataIndex((Integer)depth.peek());
                    unit.setLocation(data, index);
                    continue block10;
                }
                case 132: {
                    unit = new MXMLInstructionData(token);
                    units.add(unit);
                    ++index;
                    if (!this.fullContent) continue block10;
                    unit.setParentUnitDataIndex((Integer)depth.peek());
                    unit.setLocation(data, index);
                    continue block10;
                }
            }
            if (token.isEntity()) {
                unit = new MXMLEntityData(token);
                units.add(unit);
                ++index;
                if (!this.fullContent) continue;
                unit.setParentUnitDataIndex((Integer)depth.peek());
                unit.setLocation(data, index);
                continue;
            }
            problems.add(new SyntaxProblem(token));
        }
        this.units = units.toArray(new MXMLUnitData[0]);
        if (this.fullContent && this.shouldRepair) {
            this.units = processor.balance(this.units, this, this.nsMap);
            if (processor.wasRepaired()) {
                this.refreshPositionData();
            }
        }
    }

    public void refreshPositionData() {
        FastStack<Integer> depth = new FastStack<Integer>(this.units.length / 2);
        depth.setStackDecorator(new FastStack.IFastStackDecorator<Integer>(){

            @Override
            public Integer decorate(Integer e) {
                if (e == null) {
                    return -1;
                }
                return e;
            }
        });
        depth.clear();
        depth.push(-1);
        for (int i = 0; i < this.units.length; ++i) {
            if (this.units[i] instanceof MXMLTagData) {
                MXMLTagData currentTag = (MXMLTagData)this.units[i];
                if (currentTag.isCloseTag() && !currentTag.isEmptyTag()) {
                    depth.pop();
                }
                currentTag.setParentUnitDataIndex((Integer)depth.peek());
                currentTag.setLocation(this, i);
                if (!currentTag.isOpenTag() || currentTag.isEmptyTag()) continue;
                depth.push(i);
                continue;
            }
            this.units[i].setParentUnitDataIndex((Integer)depth.peek());
            this.units[i].setLocation(this, i);
        }
    }

    public MXMLUnitData[] getUnits() {
        return this.units;
    }

    public Iterator<MXMLUnitData> getUnitIterator() {
        return new MXMLUnitDataIterator(this.units);
    }

    public void setUnits(MXMLUnitData[] units) {
        this.units = units;
    }

    public MXMLUnitData getUnit(int i) {
        if (i < 0 || i >= this.units.length) {
            return null;
        }
        return this.units[i];
    }

    public int getNumUnits() {
        return this.units.length;
    }

    protected MXMLUnitData findNearestUnit(int offset) {
        int startOffset = 0;
        if (this.cursor.getOffset() <= offset) {
            startOffset = this.cursor.getUnitIndex();
        }
        if (startOffset < 0 || startOffset >= this.units.length) {
            startOffset = 0;
        }
        MXMLUnitData ret = null;
        for (int i = startOffset; i < this.units.length && ret == null; ++i) {
            MXMLUnitData unit = this.units[i];
            if (MXMLData.contains(unit.getAbsoluteStart(), unit.getContentEnd(), offset)) {
                ret = unit;
                continue;
            }
            if (unit.getAbsoluteStart() < offset) continue;
            ret = unit;
        }
        if (ret != null) {
            this.cursor.setCursor(offset, ret.getIndex());
        }
        return ret;
    }

    public MXMLUnitData findContainmentReferenceUnit(int offset) {
        return this.findNearestUnit(offset);
    }

    public MXMLUnitData findUnitContainingOffset(int offset) {
        MXMLUnitData unit = this.findNearestUnit(offset);
        if (unit != null && unit.containsOffset(offset)) {
            return unit;
        }
        return null;
    }

    public MXMLTagData findTagContainingOffset(int offset) {
        MXMLUnitData unit = this.findUnitContainingOffset(offset);
        if (unit != null && unit.isTag()) {
            return (MXMLTagData)unit;
        }
        return null;
    }

    public MXMLTagData findTagOrSurroundingTagContainingOffset(int offset) {
        MXMLUnitData unit = this.findUnitContainingOffset(offset);
        if (unit != null) {
            if (unit.isTag()) {
                return (MXMLTagData)unit;
            }
            if (unit.isText()) {
                MXMLTagData containingTag = unit.getContainingTag(unit.getAbsoluteStart());
                return containingTag;
            }
        }
        return null;
    }

    public MXMLTagData findAttributeListContainingOffset(int offset) {
        MXMLTagData tag = this.findTagContainingOffset(offset);
        if (tag != null && tag.isOpenTag()) {
            return tag.isOffsetInAttributeList(offset) ? tag : null;
        }
        return null;
    }

    public static boolean contains(int start, int end, int offset) {
        return start < offset && end >= offset;
    }

    public MXMLTagData getRootTag() {
        for (MXMLUnitData unit : this.units) {
            if (!(unit instanceof MXMLTagData)) continue;
            return (MXMLTagData)unit;
        }
        return null;
    }

    public int getEnd() {
        int n = this.getNumUnits();
        return n > 0 ? this.getUnit(n - 1).getAbsoluteEnd() : 0;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public boolean verify() {
        for (MXMLUnitData unit : this.getUnits()) {
            unit.verify();
        }
        return true;
    }

    void dumpUnits() {
        for (MXMLUnitData unit : this.getUnits()) {
            System.out.println(unit.toDumpString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        MXMLUnitData[] units = this.getUnits();
        int n = units.length;
        for (int i = 0; i < n; ++i) {
            sb.append('[');
            sb.append(i);
            sb.append(']');
            sb.append(' ');
            sb.append(units[i].toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileSpecification fileSpec = new FileSpecification(args[0]);
        MXMLTokenizer tokenizer = new MXMLTokenizer(fileSpec);
        List<MXMLToken> tokens = null;
        try {
            tokens = tokenizer.parseTokens(fileSpec.createReader());
            MXMLData mxmlData = new MXMLData(tokens, tokenizer.getPrefixMap(), (IFileSpecification)fileSpec);
            mxmlData.dumpUnits();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
    }

    public class Cursor {
        private int offset;
        private int unitIndex;

        public Cursor() {
            this.reset();
        }

        public void reset() {
            this.offset = 0;
            this.unitIndex = 0;
        }

        public void setCursor(int offset, int unitIndex) {
            this.offset = offset;
            this.unitIndex = unitIndex;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getUnitIndex() {
            return this.unitIndex;
        }
    }

    private final class TokenizerPayload {
        private List<MXMLToken> tokens;
        private PrefixMap prefixMap;

        public TokenizerPayload(List<MXMLToken> tokens, PrefixMap prefixMap) {
            this.tokens = tokens;
            this.prefixMap = prefixMap;
        }

        public List<MXMLToken> getMXMLTokens() {
            return this.tokens;
        }

        public PrefixMap getPrefixMap() {
            return this.prefixMap;
        }
    }
}

