/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.units.requests;

import com.adobe.flash.compiler.internal.embedding.EmbedData;
import com.adobe.flash.compiler.internal.embedding.transcoders.TranscoderBase;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.units.requests.ISWFTagsRequestResult;
import com.adobe.flash.swf.SWFFrame;
import com.adobe.flash.swf.tags.DoABCTag;
import com.adobe.flash.swf.tags.ICharacterTag;
import com.adobe.flash.swf.tags.ITag;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SWFTagsRequestResult
implements ISWFTagsRequestResult {
    private final byte[] abcData;
    private final String tagName;
    private final List<ITag> additionalTags;
    private final Map<String, ICharacterTag> assetTags;
    private final Collection<ICompilerProblem> problems;

    public SWFTagsRequestResult(byte[] abcData, String tagName) {
        this(abcData, tagName, Collections.emptySet());
    }

    public SWFTagsRequestResult(byte[] abcData, String tagName, Collection<EmbedData> embeddedAssets) {
        this.abcData = abcData;
        this.tagName = tagName;
        this.problems = new LinkedList<ICompilerProblem>();
        this.additionalTags = new LinkedList<ITag>();
        this.assetTags = new LinkedHashMap<String, ICharacterTag>();
        for (EmbedData embedData : embeddedAssets) {
            TranscoderBase transcoder = embedData.getTranscoder();
            Map<String, ICharacterTag> tags = transcoder.getTags(this.additionalTags, this.problems);
            if (tags == null) continue;
            this.assetTags.putAll(tags);
        }
    }

    @Override
    public ICompilerProblem[] getProblems() {
        return this.problems.toArray(new ICompilerProblem[this.problems.size()]);
    }

    @Override
    public boolean addToFrame(SWFFrame f) {
        if (this.abcData == null) {
            return false;
        }
        DoABCTag doABC = new DoABCTag();
        doABC.setABCData(this.abcData);
        doABC.setName(this.tagName);
        for (ITag iTag : this.additionalTags) {
            f.addTag(iTag);
        }
        f.addTag(doABC);
        for (Map.Entry entry : this.assetTags.entrySet()) {
            ICharacterTag assetTag = (ICharacterTag)entry.getValue();
            f.addTag(assetTag);
            f.defineSymbol(assetTag, (String)entry.getKey());
        }
        return true;
    }

    @Override
    public String getDoABCTagName() {
        return this.tagName;
    }
}

