/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.units.requests;

import com.adobe.flash.compiler.common.IDefinitionPriority;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.scopes.ASFileScope;
import com.adobe.flash.compiler.internal.units.requests.FileScopeRequestResultBase;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.MultipleExternallyVisibleDefinitionsProblem;
import com.adobe.flash.compiler.problems.NoMainDefinitionProblem;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ASFileScopeRequestResult
extends FileScopeRequestResultBase {
    private final String fileName;

    public ASFileScopeRequestResult(Collection<IDefinition> definitionPromises, IDefinitionPriority definitionPriority, Collection<ICompilerProblem> problems, ASFileScope fileScope, IFileSpecification fileSpec) {
        super(problems, Collections.singleton(fileScope));
        this.fileName = fileScope.getContainingPath();
        this.addProblems(this.checkExternallyVisibleDefinitions(this.fileName, definitionPromises));
    }

    @Override
    public Collection<ICompilerProblem> checkExternallyVisibleDefinitions(String dottedQName) {
        return this.checkExternallyVisibleDefinitions(this.fileName, dottedQName);
    }

    private Collection<ICompilerProblem> checkExternallyVisibleDefinitions(String fileName, String expectedQName) {
        boolean foundMainDefinition = false;
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>(this.definitions.size());
        for (IDefinition def : this.definitions) {
            String defQName = def.getQualifiedName();
            if (!foundMainDefinition && expectedQName.equals(defQName)) {
                foundMainDefinition = true;
                continue;
            }
            problems.add(new MultipleExternallyVisibleDefinitionsProblem(def, def.getQualifiedName()));
        }
        if (!foundMainDefinition) {
            problems.add(new NoMainDefinitionProblem(fileName, expectedQName));
        }
        return problems;
    }

    private Collection<ICompilerProblem> checkExternallyVisibleDefinitions(String fileName, Collection<IDefinition> definitionPromises) {
        if (definitionPromises.isEmpty()) {
            return Collections.emptyList();
        }
        assert (definitionPromises.size() == 1);
        IDefinition mainDefinitionPromise = (IDefinition)Iterables.getOnlyElement(definitionPromises);
        String mainDefinitionPromiseQName = mainDefinitionPromise.getQualifiedName();
        return this.checkExternallyVisibleDefinitions(fileName, mainDefinitionPromiseQName);
    }

    @Override
    public IDefinition getMainDefinition(String qname) {
        assert (qname != null) : "Excpect QName.";
        if (this.definitions.isEmpty()) {
            return null;
        }
        IDefinition definition = (IDefinition)this.definitions.iterator().next();
        if (qname.equals(definition.getQualifiedName())) {
            return definition;
        }
        return null;
    }
}

