/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.units;

import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.projects.DefinitionPriority;
import com.adobe.flash.compiler.internal.projects.ISourceFileHandler;
import com.adobe.flash.compiler.units.ICompilationUnit;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class SourceCompilationUnitFactory {
    private final CompilerProject project;
    private final Map<String, ISourceFileHandler> handlerMap;

    public SourceCompilationUnitFactory(CompilerProject project) {
        this.project = project;
        this.handlerMap = new HashMap<String, ISourceFileHandler>();
    }

    public void addHandler(ISourceFileHandler handler) {
        String[] extensions;
        for (String extension : extensions = handler.getExtensions()) {
            this.handlerMap.put(extension.toLowerCase().intern(), handler);
        }
    }

    private ISourceFileHandler getHandler(File file) {
        String extension = FilenameUtils.getExtension((String)file.getName());
        return this.handlerMap.get(extension);
    }

    public boolean canCreateCompilationUnitForFileType(String fileExtensionWithoutDot) {
        return this.handlerMap.containsKey(fileExtensionWithoutDot);
    }

    public boolean canCreateCompilationUnit(File file) {
        return this.getHandler(file) != null;
    }

    public boolean needCompilationUnit(File file, String qname, String locale) {
        ISourceFileHandler handler = this.getHandler(file);
        if (handler == null) {
            return false;
        }
        return handler.needCompilationUnit(this.project, file.getPath(), qname, locale);
    }

    public ICompilationUnit createCompilationUnit(File file, DefinitionPriority.BasePriority basePriority, int order, String qname, String locale) {
        ISourceFileHandler handler = this.getHandler(file);
        if (handler == null) {
            return null;
        }
        if (!this.needCompilationUnit(file, qname, locale)) {
            return null;
        }
        return handler.createCompilationUnit(this.project, file.getPath(), basePriority, order, qname, locale);
    }

    public String[] getHandledFileExtensions() {
        return this.handlerMap.keySet().toArray(new String[0]);
    }

    public boolean canCreateInvisibleCompilationUnit(File file) {
        ISourceFileHandler handler = this.getHandler(file);
        if (handler == null) {
            return false;
        }
        return handler.canCreateInvisibleCompilationUnit();
    }
}

