/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.units;

import com.adobe.flash.abc.ABCEmitter;
import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Nsset;
import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.Multiname;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.definitions.references.IResolvedQualifiersReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.abc.ClassGeneratorHelper;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.definitions.PackageDefinition;
import com.adobe.flash.compiler.internal.embedding.EmbedData;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.projects.DefinitionPriority;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.resourcebundles.PropertiesFileParser;
import com.adobe.flash.compiler.internal.resourcebundles.ResourceBundleUtils;
import com.adobe.flash.compiler.internal.scopes.ASFileScope;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.PackageScope;
import com.adobe.flash.compiler.internal.scopes.TypeScope;
import com.adobe.flash.compiler.internal.tree.as.ClassReferenceNode;
import com.adobe.flash.compiler.internal.tree.as.EmbedNode;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.LiteralNode;
import com.adobe.flash.compiler.internal.tree.properties.ResourceBundleEntryNode;
import com.adobe.flash.compiler.internal.tree.properties.ResourceBundleFileNode;
import com.adobe.flash.compiler.internal.units.CompilationUnitBase;
import com.adobe.flash.compiler.internal.units.EmbedCompilationUnitFactory;
import com.adobe.flash.compiler.internal.units.requests.ABCBytesRequestResult;
import com.adobe.flash.compiler.internal.units.requests.FileScopeRequestResultBase;
import com.adobe.flash.compiler.internal.units.requests.SWFTagsRequestResult;
import com.adobe.flash.compiler.internal.units.requests.SyntaxTreeRequestResult;
import com.adobe.flash.compiler.problems.CodegenInternalProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.InternalCompilerProblem;
import com.adobe.flash.compiler.problems.UnresolvedClassReferenceProblem;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.targets.ITarget;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IFileNodeAccumulator;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IABCBytesRequestResult;
import com.adobe.flash.compiler.units.requests.IFileScopeRequestResult;
import com.adobe.flash.compiler.units.requests.IOutgoingDependenciesRequestResult;
import com.adobe.flash.compiler.units.requests.ISWFTagsRequestResult;
import com.adobe.flash.compiler.units.requests.ISyntaxTreeRequestResult;
import com.adobe.flash.swc.ISWCFileEntry;
import com.adobe.flash.utils.FilenameNormalization;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ResourceBundleCompilationUnit
extends CompilationUnitBase {
    public static final String LOCALE = "locale";
    private final String bundleNameInColonSyntax;
    private final String locale;
    private final ISWCFileEntry fileEntry;

    public ResourceBundleCompilationUnit(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, String qname, String locale) {
        super(project, path, basePriority, ResourceBundleCompilationUnit.getQnames(project, qname, locale));
        this.locale = locale;
        this.bundleNameInColonSyntax = ResourceBundleUtils.convertBundleNameToColonSyntax(qname);
        this.fileEntry = null;
    }

    public ResourceBundleCompilationUnit(CompilerProject project, ISWCFileEntry fileEntry, String qname, String locale) {
        super(project, fileEntry.getContainingSWCPath(), DefinitionPriority.BasePriority.LIBRARY_PATH, ResourceBundleCompilationUnit.getQnames(project, qname, locale));
        this.bundleNameInColonSyntax = ResourceBundleUtils.convertBundleNameToColonSyntax(qname);
        this.fileEntry = fileEntry;
        this.locale = locale;
    }

    private static Collection<String> getQnames(CompilerProject project, String qname, String locale) {
        Collection<String> locales = locale == null ? ((FlexProject)project).getLocales() : Collections.singleton(locale);
        ArrayList<String> qnames = new ArrayList<String>();
        for (String loc : locales) {
            String qualifiedName = ResourceBundleUtils.getQualifiedName(loc, qname);
            qnames.add(qualifiedName);
        }
        return qnames;
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.RESOURCE_UNIT;
    }

    public String getBundleNameInColonSyntax() {
        return this.bundleNameInColonSyntax;
    }

    public String getLocale() {
        return this.locale;
    }

    private FlexProject getFlexProject() {
        return (FlexProject)this.getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        try {
            this.getProject().clearScopeCacheForCompilationUnit(this);
            LinkedList<ICompilerProblem> problems = new LinkedList<ICompilerProblem>();
            PropertiesFileParser parser = new PropertiesFileParser(this.getProject().getWorkspace());
            ResourceBundleFileNode fileNode = parser.parse(this.getFileName(), this.locale, this.getFileReader(problems), problems);
            ASFileScope fileScope = this.createFileScope(fileNode);
            this.addScopeToProjectScope(new ASFileScope[]{fileScope});
            SyntaxTreeRequestResult syntaxTreeRequestResult = new SyntaxTreeRequestResult(fileNode, (ImmutableSet<String>)ImmutableSet.of(), this.getRootFileSpecification().getLastModified(), problems);
            return syntaxTreeRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        try {
            ISyntaxTreeRequestResult syntaxTreeResult = this.getSyntaxTreeRequest().get();
            ResourceBundleFileNode rootNode = (ResourceBundleFileNode)syntaxTreeResult.getAST();
            IASScope fileScope = rootNode.getScope();
            assert (fileScope instanceof ASFileScope) : "Expect ASFileScope as the top-level scope, but found " + fileScope.getClass();
            FileScopeRequestResultBase fileScopeRequestResultBase = new FileScopeRequestResultBase(Collections.emptyList(), Collections.singleton(fileScope)){

                @Override
                public IDefinition getMainDefinition(String qname) {
                    assert (qname != null) : "Excpect QName.";
                    for (IDefinition def : this.definitions) {
                        if (!qname.equals(def.getQualifiedName())) continue;
                        return def;
                    }
                    return null;
                }
            };
            return fileScopeRequestResultBase;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        ISyntaxTreeRequestResult syntaxTreeResult = this.getSyntaxTreeRequest().get();
        IASNode rootNode = syntaxTreeResult.getAST();
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        try {
            LinkedList<ICompilerProblem> problems = new LinkedList<ICompilerProblem>();
            ABCEmitter emitter = new ABCEmitter();
            emitter.visit(46, 16);
            byte[] generatedBytes = null;
            try {
                for (IDefinition def : this.getDefinitionPromises()) {
                    String qualifiedClassName = def.getQualifiedName();
                    String locale = ResourceBundleUtils.getLocale(qualifiedClassName);
                    this.generateABCForBundle(emitter, (ResourceBundleFileNode)rootNode, qualifiedClassName, this.bundleNameInColonSyntax, locale, problems);
                }
                generatedBytes = emitter.emit();
            }
            catch (Throwable ex) {
                problems.add(new CodegenInternalProblem(rootNode, ex));
            }
            HashSet<EmbedData> embeds = new HashSet<EmbedData>();
            EmbedCompilationUnitFactory.collectEmbedDatas(this.getProject(), (IFileNodeAccumulator)((Object)rootNode), embeds, problems);
            ABCBytesRequestResult aBCBytesRequestResult = new ABCBytesRequestResult(generatedBytes, problems.toArray(new ICompilerProblem[0]), embeds);
            return aBCBytesRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        IABCBytesRequestResult abc = this.getABCBytesRequest().get();
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        try {
            String tagName = this.getDefinitionPromises().get(0).getQualifiedName();
            SWFTagsRequestResult sWFTagsRequestResult = new SWFTagsRequestResult(abc.getABCBytes(), tagName, abc.getEmbeds());
            return sWFTagsRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        ResourceBundleFileNode fileNode = (ResourceBundleFileNode)this.getSyntaxTreeRequest().get().getAST();
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        try {
            ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
            this.updateEmbedCompilationUnitDependencies(fileNode.getEmbedNodes(), problems);
            this.getABCBytesRequest().get();
            FlexProject project = this.getFlexProject();
            IResolvedQualifiersReference resourceBundleClassRef = ReferenceFactory.packageQualifiedReference(this.getProject().getWorkspace(), project.getResourceBundleClass());
            resourceBundleClassRef.resolve(project, this, DependencyType.INHERITANCE);
            IOutgoingDependenciesRequestResult iOutgoingDependenciesRequestResult = new IOutgoingDependenciesRequestResult(){

                @Override
                public ICompilerProblem[] getProblems() {
                    return IOutgoingDependenciesRequestResult.NO_PROBLEMS;
                }
            };
            return iOutgoingDependenciesRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        }
    }

    @Override
    public void waitForBuildFinish(Collection<ICompilerProblem> problems, ITarget.TargetType targetType) throws InterruptedException {
        assert (problems != null) : "Expected 'problems'. Do not ignore problems.";
        Collections.addAll(problems, this.getSyntaxTreeRequest().get().getProblems());
        Collections.addAll(problems, this.getFileScopeRequest().get().getProblems());
        Collections.addAll(problems, this.getOutgoingDependenciesRequest().get().getProblems());
        if (ITarget.TargetType.SWF.equals((Object)targetType)) {
            Collections.addAll(problems, this.getABCBytesRequest().get().getProblems());
            Collections.addAll(problems, this.getSWFTagsRequest().get().getProblems());
        }
    }

    @Override
    public void startBuildAsync(ITarget.TargetType targetType) {
        this.getSyntaxTreeRequest();
        this.getFileScopeRequest();
        this.getOutgoingDependenciesRequest();
        if (ITarget.TargetType.SWF.equals((Object)targetType)) {
            this.getABCBytesRequest();
            this.getSWFTagsRequest();
        }
    }

    public long getFileLastModified() {
        if (this.fileEntry != null) {
            return this.fileEntry.getLastModified();
        }
        return this.getRootFileSpecification().getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFileContent(Collection<ICompilerProblem> problems) {
        Reader reader = null;
        try {
            reader = this.getFileReader(problems);
            byte[] byArray = IOUtils.toByteArray((Reader)reader);
            return byArray;
        }
        catch (IOException ex) {
            problems.add(new InternalCompilerProblem(ex));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private String getFileName() {
        if (this.fileEntry != null) {
            return FilenameNormalization.normalize(this.getAbsoluteFilename() + ":" + this.fileEntry.getPath());
        }
        return this.getAbsoluteFilename();
    }

    private Reader getFileReader(Collection<ICompilerProblem> problems) {
        block4: {
            try {
                if (this.fileEntry != null) {
                    InputStream in = this.fileEntry.createInputStream();
                    if (in != null) {
                        return new InputStreamReader(in, "UTF-8");
                    }
                    break block4;
                }
                return this.getRootFileSpecification().createReader();
            }
            catch (IOException ex) {
                problems.add(new InternalCompilerProblem(ex));
            }
        }
        return null;
    }

    private ASFileScope createFileScope(ResourceBundleFileNode fileNode) {
        List<IDefinition> definitions = this.getDefinitionPromises();
        ASFileScope fileScope = new ASFileScope(fileNode);
        String packageName = Multiname.getPackageNameForQName(definitions.get(0).getQualifiedName());
        PackageScope packageScope = new PackageScope((ASScope)fileScope, packageName);
        packageScope.setContainingScope(fileScope);
        PackageDefinition packageDefinition = new PackageDefinition(packageName);
        packageDefinition.setContainedScope(packageScope);
        fileScope.addDefinition(packageDefinition);
        for (IDefinition def : definitions) {
            Multiname mname = Multiname.crackDottedQName(this.getProject(), def.getQualifiedName());
            INamespaceDefinition packageNS = (INamespaceDefinition)Iterables.getOnlyElement(mname.getNamespaceSet());
            ClassDefinition classDefinition = new ClassDefinition(mname.getBaseName(), (INamespaceReference)((Object)packageNS));
            IResolvedQualifiersReference baseClass = ReferenceFactory.packageQualifiedReference(this.getProject().getWorkspace(), this.getFlexProject().getResourceBundleClass());
            classDefinition.setBaseClassReference(baseClass);
            classDefinition.setExcludedClass();
            TypeScope classScope = new TypeScope((ASScope)packageScope, classDefinition);
            classScope.setContainingDefinition(classDefinition);
            classDefinition.setContainedScope(classScope);
            classDefinition.setupThisAndSuper();
            packageScope.addDefinition(classDefinition);
        }
        return fileScope;
    }

    private void generateABCForBundle(ABCEmitter emitter, ResourceBundleFileNode fileNode, String qualifiedClassName, String bundleName, String locale, Collection<ICompilerProblem> problems) {
        FlexProject project = this.getFlexProject();
        IResolvedQualifiersReference resourceBundleReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), project.getResourceBundleClass());
        InstructionList constructorInstructionList = new InstructionList();
        constructorInstructionList.addInstruction(208);
        constructorInstructionList.addInstruction(44, locale);
        constructorInstructionList.addInstruction(44, bundleName);
        constructorInstructionList.addInstruction(73, 2);
        constructorInstructionList.addInstruction(71);
        IResolvedQualifiersReference mainClassRef = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), qualifiedClassName);
        ClassGeneratorHelper classGen = new ClassGeneratorHelper(project, emitter, mainClassRef.getMName(), (ClassDefinition)resourceBundleReference.resolve(project), Collections.<Name>emptyList(), Collections.<Name>emptyList(), constructorInstructionList, true);
        InstructionList bodyInstructionList = new InstructionList();
        bodyInstructionList.addInstruction(208);
        bodyInstructionList.addInstruction(48);
        int entryCount = 0;
        block7: for (int i = 0; i < fileNode.getChildCount(); ++i) {
            IASNode node = fileNode.getChild(i);
            if (!(node instanceof ResourceBundleEntryNode)) continue;
            ++entryCount;
            ResourceBundleEntryNode entryNode = (ResourceBundleEntryNode)node;
            bodyInstructionList.addInstruction(44, entryNode.getKeyNode().getValue());
            ExpressionNodeBase valueNode = entryNode.getValueNode();
            switch (valueNode.getNodeID()) {
                case LiteralStringID: {
                    bodyInstructionList.addInstruction(44, ((LiteralNode)valueNode).getValue());
                    continue block7;
                }
                case ClassReferenceID: {
                    String className;
                    IResolvedQualifiersReference refClass;
                    ClassReferenceNode crn = (ClassReferenceNode)valueNode;
                    if (crn.getName() != null && (refClass = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), crn.getName())).resolve(project, crn.getASScope(), DependencyType.EXPRESSION, true) == null) {
                        UnresolvedClassReferenceProblem problem = new UnresolvedClassReferenceProblem(crn, crn.getName());
                        problems.add(problem);
                    }
                    if ((className = crn.getName()) == null) {
                        bodyInstructionList.addInstruction(32);
                        continue block7;
                    }
                    IResolvedQualifiersReference classRef = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), className);
                    bodyInstructionList.addInstruction(96, classRef.getMName());
                    continue block7;
                }
                case EmbedID: {
                    EmbedNode embedNode = (EmbedNode)valueNode;
                    try {
                        String name = embedNode.getName(project, problems);
                        IResolvedQualifiersReference embedClassRef = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), name);
                        bodyInstructionList.addInstruction(96, embedClassRef.getMName());
                    }
                    catch (InterruptedException ex) {
                        problems.add(new CodegenInternalProblem((IASNode)embedNode, ex));
                    }
                    continue block7;
                }
            }
        }
        bodyInstructionList.addInstruction(85, entryCount);
        bodyInstructionList.addInstruction(72);
        Name getContentsMethodName = new Name(7, new Nsset(classGen.getProtectedNamespace()), "getContent");
        classGen.addITraitsMethod(getContentsMethodName, Collections.<Name>emptyList(), new Name("Object"), Collections.<Object>emptyList(), false, false, true, bodyInstructionList);
        classGen.finishScript();
    }
}

