/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.units;

import com.adobe.flash.compiler.common.IDefinitionPriority;
import com.adobe.flash.compiler.common.IFileSpecificationGetter;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.internal.projects.ASProject;
import com.adobe.flash.compiler.internal.units.CompilationUnitBase;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.targets.ITarget;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.IInvisibleCompilationUnit;
import com.adobe.flash.compiler.units.requests.IABCBytesRequestResult;
import com.adobe.flash.compiler.units.requests.IFileScopeRequestResult;
import com.adobe.flash.compiler.units.requests.IOutgoingDependenciesRequestResult;
import com.adobe.flash.compiler.units.requests.IRequest;
import com.adobe.flash.compiler.units.requests.ISWFTagsRequestResult;
import com.adobe.flash.compiler.units.requests.ISyntaxTreeRequestResult;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InvisibleCompilationUnit
implements IInvisibleCompilationUnit {
    private final CompilationUnitBase delegate;

    public InvisibleCompilationUnit(CompilationUnitBase delegate, IFileSpecificationGetter fileSpecGetter) {
        assert (delegate != null);
        this.delegate = delegate;
        delegate.setFileSpecificationGetter(fileSpecGetter);
        delegate.makeInvisible(this);
    }

    @Override
    public ICompilerProject getProject() {
        assert (this.delegate.isInvisible());
        return this.delegate.getProject();
    }

    @Override
    public IRequest<ISyntaxTreeRequestResult, ICompilationUnit> getSyntaxTreeRequest() {
        assert (this.delegate.isInvisible());
        return this.delegate.getSyntaxTreeRequest();
    }

    @Override
    public IRequest<IFileScopeRequestResult, ICompilationUnit> getFileScopeRequest() {
        assert (this.delegate.isInvisible());
        return this.delegate.getFileScopeRequest();
    }

    @Override
    public IRequest<IOutgoingDependenciesRequestResult, ICompilationUnit> getOutgoingDependenciesRequest() {
        assert (this.delegate.isInvisible());
        return this.delegate.getOutgoingDependenciesRequest();
    }

    @Override
    public IRequest<IABCBytesRequestResult, ICompilationUnit> getABCBytesRequest() {
        assert (this.delegate.isInvisible());
        return this.delegate.getABCBytesRequest();
    }

    @Override
    public IRequest<ISWFTagsRequestResult, ICompilationUnit> getSWFTagsRequest() {
        assert (this.delegate.isInvisible());
        return this.delegate.getSWFTagsRequest();
    }

    @Override
    public List<String> getShortNames() throws InterruptedException {
        assert (this.delegate.isInvisible());
        return this.delegate.getShortNames();
    }

    @Override
    public List<String> getQualifiedNames() throws InterruptedException {
        assert (this.delegate.isInvisible());
        return this.delegate.getQualifiedNames();
    }

    @Override
    public String getName() {
        assert (this.delegate.isInvisible());
        return this.delegate.getName();
    }

    @Override
    public String getAbsoluteFilename() {
        assert (this.delegate.isInvisible());
        return this.delegate.getAbsoluteFilename();
    }

    @Override
    public List<IDefinition> getDefinitionPromises() {
        assert (this.delegate.isInvisible());
        return this.delegate.getDefinitionPromises();
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        assert (this.delegate.isInvisible());
        return this.delegate.getCompilationUnitType();
    }

    @Override
    public boolean clean(Map<ICompilerProject, Set<File>> invalidatedSWCFiles, Map<ICompilerProject, Set<ICompilationUnit>> cusToUpdate, boolean clearFileScope) {
        assert (this.delegate.isInvisible());
        this.clean();
        return true;
    }

    @Override
    public IDefinitionPriority getDefinitionPriority() {
        assert (this.delegate.isInvisible());
        return this.delegate.getDefinitionPriority();
    }

    @Override
    public void clearProject() {
        assert (this.delegate.isInvisible());
        this.delegate.clearProject();
    }

    @Override
    public synchronized void waitForBuildFinish(Collection<ICompilerProblem> problems, ITarget.TargetType targetType) throws InterruptedException {
        assert (this.delegate.isInvisible());
        this.delegate.waitForBuildFinish(problems, targetType);
    }

    @Override
    public void startBuildAsync(ITarget.TargetType targetType) {
        assert (this.delegate.isInvisible());
        this.delegate.startBuildAsync(targetType);
    }

    @Override
    public boolean isBuiltinCompilationUnit() {
        assert (this.delegate.isInvisible());
        return this.delegate.isBuiltinCompilationUnit();
    }

    @Override
    public boolean isInvisible() {
        assert (this.delegate.isInvisible());
        return true;
    }

    @Override
    public synchronized void getCompilerProblems(Collection<ICompilerProblem> problems) throws InterruptedException {
        assert (problems != null) : "A valid collection of ICompilerProblems should be passed";
        this.startBuildAsync(ITarget.TargetType.SWF);
        this.waitForBuildFinish(problems, ITarget.TargetType.SWF);
    }

    @Override
    public synchronized void clean() {
        this.delegate.clean(null, null, true);
    }

    @Override
    public synchronized void remove() {
        ((ASProject)this.getProject()).removeCompilationUnit(this.delegate);
    }

    @Override
    public Collection<String> getEmbeddedFilenames() {
        assert (this.delegate.isInvisible());
        return this.delegate.getEmbeddedFilenames();
    }

    public CompilationUnitBase getDelegate() {
        return this.delegate;
    }
}

