/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.units;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.Multiname;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.definitions.references.IResolvedQualifiersReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.fxg.flex.FXGSymbolClass;
import com.adobe.flash.compiler.fxg.flex.FlexFXG2SWFTranscoder;
import com.adobe.flash.compiler.internal.as.codegen.CodeGeneratorManager;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.definitions.PackageDefinition;
import com.adobe.flash.compiler.internal.fxg.resources.FXGFileResolver;
import com.adobe.flash.compiler.internal.fxg.sax.FXGSAXParser;
import com.adobe.flash.compiler.internal.parsing.as.ASParser;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.projects.DefinitionPriority;
import com.adobe.flash.compiler.internal.scopes.ASProjectScope;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.FXGFileScope;
import com.adobe.flash.compiler.internal.scopes.PackageScope;
import com.adobe.flash.compiler.internal.scopes.TypeScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.targets.TagSorter;
import com.adobe.flash.compiler.internal.tree.as.FileNode;
import com.adobe.flash.compiler.internal.units.CompilationUnitBase;
import com.adobe.flash.compiler.internal.units.requests.ABCBytesRequestResult;
import com.adobe.flash.compiler.internal.units.requests.ASFileScopeRequestResult;
import com.adobe.flash.compiler.internal.units.requests.SyntaxTreeRequestResult;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.InternalCompilerProblem2;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IABCBytesRequestResult;
import com.adobe.flash.compiler.units.requests.IFileScopeRequestResult;
import com.adobe.flash.compiler.units.requests.IOutgoingDependenciesRequestResult;
import com.adobe.flash.compiler.units.requests.ISWFTagsRequestResult;
import com.adobe.flash.compiler.units.requests.ISyntaxTreeRequestResult;
import com.adobe.flash.swf.SWFFrame;
import com.adobe.flash.swf.tags.DoABCTag;
import com.adobe.flash.swf.tags.ICharacterTag;
import com.adobe.flash.swf.tags.ITag;
import com.adobe.flash.utils.FilenameNormalization;
import com.google.common.collect.Iterables;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class FXGCompilationUnit
extends CompilationUnitBase {
    private static final String fxgBaseClassName = "spark.core.SpriteVisualElement";
    private String qname;
    private static final String SUB_SYSTEM = "FXGCompilationUnit";

    public FXGCompilationUnit(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, String qname) {
        super(project, path, basePriority, qname);
        this.qname = qname;
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.FXG_UNIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        this.getProject().clearScopeCacheForCompilationUnit(this);
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        IFXGNode fxgroot = null;
        try {
            fxgroot = new FXGSAXParser().parse(this.getRootFileSpecification().createReader(), this.qname, problems);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            problems.add(new InternalCompilerProblem2(this.getAbsoluteFilename(), ex, SUB_SYSTEM));
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        }
        return new FXGSyntaxTreeRequestResult(fxgroot, this.getRootFileSpecification().getLastModified(), problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        try {
            List<ICompilerProblem> noProblems = Collections.emptyList();
            IFileSpecification rootFileSpec = this.getRootFileSpecification();
            FXGFileScope fileScope = this.createFileScope();
            ASFileScopeRequestResult aSFileScopeRequestResult = new ASFileScopeRequestResult(this.getDefinitionPromises(), this.getDefinitionPriority(), noProblems, fileScope, rootFileSpec);
            return aSFileScopeRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        HashMap<ITag, ITag> extraTags = new HashMap<ITag, ITag>();
        FXGSymbolClass symbolClass = null;
        FileNode fileNode = null;
        ASProjectScope projectScope = this.getProject().getScope();
        try {
            FXGSyntaxTreeRequestResult syntaxTreeResult = (FXGSyntaxTreeRequestResult)this.getSyntaxTreeRequest().get();
            IFXGNode tree = syntaxTreeResult.getRootNode();
            FlexFXG2SWFTranscoder transcoder = new FlexFXG2SWFTranscoder(this.getProject());
            transcoder.setResourceResolver(new FXGFileResolver(FilenameUtils.getFullPath((String)this.getRootFileSpecification().getPath())));
            symbolClass = transcoder.transcode(tree, Multiname.getPackageNameForQName(this.qname), Multiname.getBaseNameForQName(this.qname), extraTags, problems);
            for (ITypeDefinition definition : transcoder.getDependencies()) {
                this.getProject().addDependency((ICompilationUnit)this, projectScope.getCompilationUnitForDefinition(definition), DependencyType.EXPRESSION, definition.getQualifiedName());
            }
            StringBuilder sb = new StringBuilder(symbolClass.getGeneratedSource());
            if (symbolClass.getAdditionalSymbolClasses() != null) {
                for (FXGSymbolClass symbol : symbolClass.getAdditionalSymbolClasses()) {
                    sb.append(symbol.getGeneratedSource());
                }
            }
            GeneratedSourceFileSpecfication virtualSymbolSource = new GeneratedSourceFileSpecfication(this.qname, sb.toString());
            fileNode = ASParser.parseFile(virtualSymbolSource, this.getProject().getWorkspace());
            fileNode.runPostProcess(EnumSet.of(PostProcessStep.POPULATE_SCOPE));
            projectScope.addScopeForCompilationUnit(this, fileNode.getFileScope());
            this.updateEmbedCompilationUnitDependencies(fileNode.getEmbedNodes(), problems);
        }
        catch (Exception e) {
            e.printStackTrace();
            problems.add(new InternalCompilerProblem2(this.getAbsoluteFilename(), e, SUB_SYSTEM));
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        }
        return new FXGOutgoingDependenciesResult(fileNode, symbolClass, extraTags, problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        FXGOutgoingDependenciesResult semanticResults = (FXGOutgoingDependenciesResult)this.getOutgoingDependenciesRequest().get();
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        try {
            byte[] abc = CodeGeneratorManager.getCodeGenerator().generate(this.getFilenameNoPath(), semanticResults.fileNode, this.getProject()).getABCBytes();
            ABCBytesRequestResult aBCBytesRequestResult = new ABCBytesRequestResult(abc);
            return aBCBytesRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        FXGOutgoingDependenciesResult semanticResults = (FXGOutgoingDependenciesResult)this.getOutgoingDependenciesRequest().get();
        IABCBytesRequestResult byteResult = this.getABCBytesRequest().get();
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        final FXGSymbolClass symbolClass = semanticResults.symbolClass;
        final Map<ITag, ITag> extraTags = semanticResults.extraTags;
        final ArrayList<InternalCompilerProblem2> problems = new ArrayList<InternalCompilerProblem2>();
        final DoABCTag abcTag = new DoABCTag();
        try {
            abcTag.setName(this.qname);
            abcTag.setABCData(byteResult.getABCBytes());
        }
        catch (Exception e) {
            InternalCompilerProblem2 problem = new InternalCompilerProblem2(this.getRootFileSpecification().getPath(), e, SUB_SYSTEM);
            problems.add(problem);
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        }
        return new ISWFTagsRequestResult(){

            @Override
            public boolean addToFrame(SWFFrame frame) {
                ICharacterTag symbolTag = symbolClass.getSymbol();
                List<ITag> symbolTags = TagSorter.sortFullGraph(Collections.singletonList(symbolTag));
                for (ITag tag : symbolTags) {
                    frame.addTag(tag);
                    if (!extraTags.containsKey(tag)) continue;
                    frame.addTag((ITag)extraTags.get(tag));
                }
                if (symbolClass.getAdditionalSymbolClasses() != null) {
                    for (FXGSymbolClass symbol : symbolClass.getAdditionalSymbolClasses()) {
                        frame.defineSymbol(symbol.getSymbol(), symbol.getQualifiedClassName());
                    }
                }
                frame.addTag(abcTag);
                frame.defineSymbol(symbolClass.getSymbol(), FXGCompilationUnit.this.qname);
                return true;
            }

            @Override
            public ICompilerProblem[] getProblems() {
                return problems.toArray(new ICompilerProblem[0]);
            }

            @Override
            public String getDoABCTagName() {
                return abcTag.getName();
            }
        };
    }

    private FXGFileScope createFileScope() {
        FXGFileScope fileScope = new FXGFileScope(this, this.getAbsoluteFilename());
        String packageName = Multiname.getPackageNameForQName(this.qname);
        PackageScope packageScope = new PackageScope((ASScope)fileScope, packageName);
        packageScope.setContainingScope(fileScope);
        PackageDefinition packageDefinition = new PackageDefinition(packageName);
        packageDefinition.setContainedScope(packageScope);
        fileScope.addDefinition(packageDefinition);
        Multiname mname = Multiname.crackDottedQName(this.getProject(), this.qname);
        INamespaceDefinition packageNS = (INamespaceDefinition)Iterables.getOnlyElement(mname.getNamespaceSet());
        ClassDefinition classDefinition = new ClassDefinition(mname.getBaseName(), (INamespaceReference)((Object)packageNS));
        IResolvedQualifiersReference baseClass = ReferenceFactory.packageQualifiedReference(this.getProject().getWorkspace(), fxgBaseClassName);
        classDefinition.setBaseClassReference(baseClass);
        TypeScope classScope = new TypeScope((ASScope)packageScope, classDefinition);
        classScope.setContainingDefinition(classDefinition);
        classDefinition.setContainedScope(classScope);
        classDefinition.setupThisAndSuper();
        packageScope.addDefinition(classDefinition);
        return fileScope;
    }

    private static class FXGOutgoingDependenciesResult
    implements IOutgoingDependenciesRequestResult {
        private Collection<ICompilerProblem> problems;
        protected FileNode fileNode;
        protected FXGSymbolClass symbolClass;
        protected Map<ITag, ITag> extraTags;

        public FXGOutgoingDependenciesResult(FileNode fileNode, FXGSymbolClass symbolClass, Map<ITag, ITag> extraTags, Collection<ICompilerProblem> problems) {
            this.problems = problems;
            this.fileNode = fileNode;
            this.symbolClass = symbolClass;
            this.extraTags = extraTags;
        }

        @Override
        public ICompilerProblem[] getProblems() {
            return this.problems.toArray(new ICompilerProblem[0]);
        }
    }

    private static class FXGSyntaxTreeRequestResult
    extends SyntaxTreeRequestResult {
        private IFXGNode rootNode;

        public FXGSyntaxTreeRequestResult(IFXGNode rootNode, long lastModified, Collection<ICompilerProblem> problems) {
            super(lastModified, problems);
            this.rootNode = rootNode;
        }

        public IFXGNode getRootNode() {
            return this.rootNode;
        }
    }

    private class GeneratedSourceFileSpecfication
    implements IFileSpecification {
        private final StringReader reader;
        private final String name;

        public GeneratedSourceFileSpecfication(String name, String content) {
            this.reader = new StringReader(content);
            this.name = FilenameNormalization.normalize(name);
        }

        @Override
        public String getPath() {
            return this.name;
        }

        @Override
        public Reader createReader() throws FileNotFoundException {
            return this.reader;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public boolean isOpenDocument() {
            return false;
        }
    }
}

