/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.units;

import com.adobe.flash.compiler.common.IEmbedResolver;
import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.definitions.metadata.IMetaTagAttribute;
import com.adobe.flash.compiler.internal.embedding.EmbedData;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.units.EmbedCompilationUnit;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.as.IFileNodeAccumulator;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class EmbedCompilationUnitFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmbedCompilationUnit getCompilationUnit(CompilerProject project, String containingSourceFilename, ISourceLocation location, IMetaTagAttribute[] attributes, Collection<ICompilerProblem> problems) throws InterruptedException {
        Workspace workspace = project.getWorkspace();
        workspace.embedLock.writeLock().lock();
        try {
            EmbedData data = EmbedCompilationUnitFactory.getEmbedData(project, null, containingSourceFilename, location, attributes, problems);
            if (data == null) {
                EmbedCompilationUnit embedCompilationUnit = null;
                return embedCompilationUnit;
            }
            EmbedCompilationUnit embedCompilationUnit = project.getCompilationUnit(data);
            if (embedCompilationUnit != null) {
                EmbedCompilationUnit embedCompilationUnit2 = embedCompilationUnit;
                return embedCompilationUnit2;
            }
            assert (data == project.getWorkspace().getCanonicalEmbedData(data)) : "EmbedData has not been canonicalized";
            embedCompilationUnit = new EmbedCompilationUnit(project, data);
            project.addEmbedCompilationUnit(embedCompilationUnit);
            EmbedCompilationUnit embedCompilationUnit3 = embedCompilationUnit;
            return embedCompilationUnit3;
        }
        finally {
            workspace.embedLock.writeLock().unlock();
        }
    }

    public static EmbedData getEmbedData(CompilerProject project, String specifiedQName, String containingSourceFilename, ISourceLocation location, IMetaTagAttribute[] attributes, Collection<ICompilerProblem> problems) {
        EmbedData data = new EmbedData(containingSourceFilename, specifiedQName);
        boolean hadError = false;
        for (IMetaTagAttribute attribute : attributes) {
            String value;
            String key = attribute.getKey();
            if (!data.addAttribute(project, location, key, value = attribute.getValue(), problems)) continue;
            hadError = true;
        }
        if (hadError || !data.createTranscoder(project, location, problems)) {
            return null;
        }
        return project.getWorkspace().getCanonicalEmbedData(data);
    }

    public static void collectEmbedDatas(ICompilerProject project, IFileNodeAccumulator fileNode, Set<EmbedData> embeds, Collection<ICompilerProblem> problems) throws InterruptedException {
        List<IEmbedResolver> embedNodes = fileNode.getEmbedNodes();
        for (IEmbedResolver embedNode : embedNodes) {
            EmbedCompilationUnit cu = (EmbedCompilationUnit)embedNode.resolveCompilationUnit(project);
            if (cu == null) continue;
            embeds.add(cu.getEmbedData());
        }
    }
}

