/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.units;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.DependencyTypeSet;
import com.adobe.flash.compiler.common.Multiname;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.internal.as.codegen.CodeGeneratorManager;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.embedding.EmbedAttribute;
import com.adobe.flash.compiler.internal.embedding.EmbedData;
import com.adobe.flash.compiler.internal.embedding.transcoders.TranscoderBase;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.projects.DefinitionPriority;
import com.adobe.flash.compiler.internal.scopes.ASFileScope;
import com.adobe.flash.compiler.internal.scopes.ASProjectScope;
import com.adobe.flash.compiler.internal.tree.as.FileNode;
import com.adobe.flash.compiler.internal.units.CompilationUnitBase;
import com.adobe.flash.compiler.internal.units.requests.ABCBytesRequestResult;
import com.adobe.flash.compiler.internal.units.requests.EmbedFileScopeRequestResult;
import com.adobe.flash.compiler.internal.units.requests.SWFTagsRequestResult;
import com.adobe.flash.compiler.internal.units.requests.SyntaxTreeRequestResult;
import com.adobe.flash.compiler.problems.EmbedUnresolvedClassReferenceProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IABCBytesRequestResult;
import com.adobe.flash.compiler.units.requests.IFileScopeRequestResult;
import com.adobe.flash.compiler.units.requests.IOutgoingDependenciesRequestResult;
import com.adobe.flash.compiler.units.requests.ISWFTagsRequestResult;
import com.adobe.flash.compiler.units.requests.ISyntaxTreeRequestResult;
import com.adobe.flash.swc.ISWCFileEntry;
import com.adobe.flash.swf.tags.ICharacterTag;
import com.adobe.flash.swf.tags.IImportClassName;
import com.adobe.flash.swf.tags.ITag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class EmbedCompilationUnit
extends CompilationUnitBase {
    private final EmbedData embedData;

    private static String getSourcePath(EmbedData data) {
        ISWCFileEntry swcFile = data.getSWCSource();
        if (swcFile != null) {
            return swcFile.getContainingSWCPath();
        }
        return (String)data.getAttribute(EmbedAttribute.SOURCE);
    }

    public EmbedCompilationUnit(CompilerProject project, EmbedData data) {
        super(project, EmbedCompilationUnit.getSourcePath(data), DefinitionPriority.BasePriority.SOURCE_LIST, true);
        this.embedData = data;
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.EMBED_UNIT;
    }

    @Override
    public String getName() {
        return this.embedData.getQName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        try {
            this.getProject().clearScopeCacheForCompilationUnit(this);
            TranscoderBase transcoder = this.embedData.getTranscoder();
            LinkedList<ICompilerProblem> problems = new LinkedList<ICompilerProblem>();
            FileNode fileNode = transcoder.buildAST(problems, this.getAbsoluteFilename());
            ASFileScope fileScope = fileNode.getFileScope();
            this.addScopeToProjectScope(new ASFileScope[]{fileScope});
            this.markClassAsEmbed(fileScope);
            SyntaxTreeRequestResult syntaxTreeRequestResult = new SyntaxTreeRequestResult(fileNode, fileNode.getIncludeHandler().getIncludedFiles(), this.getRootFileSpecification().getLastModified(), problems);
            return syntaxTreeRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        }
    }

    @Override
    protected void verifyAST(IASNode ast) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        ISyntaxTreeRequestResult syntaxTreeResult = this.getSyntaxTreeRequest().get();
        FileNode rootNode = (FileNode)syntaxTreeResult.getAST();
        if (rootNode == null) {
            return new EmbedFileScopeRequestResult(null);
        }
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        try {
            IASScope fileScope = rootNode.getScope();
            assert (fileScope instanceof ASFileScope) : "Expect ASFileScope as the top-level scope, but found " + fileScope.getClass();
            EmbedFileScopeRequestResult embedFileScopeRequestResult = new EmbedFileScopeRequestResult((ASFileScope)fileScope);
            return embedFileScopeRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        ISyntaxTreeRequestResult syntaxTreeResult = this.getSyntaxTreeRequest().get();
        IASNode rootNode = syntaxTreeResult.getAST();
        if (rootNode == null) {
            return new ABCBytesRequestResult(syntaxTreeResult.getProblems());
        }
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        try {
            ABCBytesRequestResult aBCBytesRequestResult = CodeGeneratorManager.getCodeGenerator().generate(this.getFilenameNoPath(), rootNode, this.getProject());
            return aBCBytesRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        IABCBytesRequestResult abc = this.getABCBytesRequest().get();
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        try {
            String qname = this.getName();
            String tagName = qname == null || "".equals(qname) ? "script" : qname.replace('.', '/');
            SWFTagsRequestResult sWFTagsRequestResult = new SWFTagsRequestResult(abc.getABCBytes(), tagName, abc.getEmbeds());
            return sWFTagsRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        try {
            IOutgoingDependenciesRequestResult result;
            final LinkedList<ICompilerProblem> problems = new LinkedList<ICompilerProblem>();
            this.analyze(problems);
            IOutgoingDependenciesRequestResult iOutgoingDependenciesRequestResult = result = new IOutgoingDependenciesRequestResult(){

                @Override
                public ICompilerProblem[] getProblems() {
                    return problems.isEmpty() ? IOutgoingDependenciesRequestResult.NO_PROBLEMS : problems.toArray(new ICompilerProblem[problems.size()]);
                }
            };
            return iOutgoingDependenciesRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        }
    }

    public EmbedData getEmbedData() {
        return this.embedData;
    }

    private void analyze(Collection<ICompilerProblem> problems) {
        HashMap<String, DependencyType> dependencies = new HashMap<String, DependencyType>();
        if (this.embedData.generatedClassExtendsAnother()) {
            dependencies.put(this.embedData.getTranscoder().getBaseClassQName(), DependencyType.INHERITANCE);
        }
        if (this.embedData.getTranscoder() != null) {
            HashSet<ITag> tags = new HashSet<ITag>();
            Map<String, ICharacterTag> symbolTags = this.embedData.getTranscoder().getTags(tags, problems);
            tags.addAll(symbolTags.values());
            for (ITag tag : tags) {
                if (!(tag instanceof IImportClassName)) continue;
                for (String className : ((IImportClassName)((Object)tag)).getClassNames()) {
                    dependencies.put(className, DependencyType.SIGNATURE);
                }
            }
        }
        ASProjectScope projectScope = this.getProject().getScope();
        for (Map.Entry dependencyEntry : dependencies.entrySet()) {
            IDefinition[] defs = projectScope.findAllDefinitionsByName(Multiname.crackDottedQName(this.getProject(), (String)dependencyEntry.getKey(), true));
            if (defs == null || defs.length == 0) {
                String source = (String)this.getEmbedData().getAttribute(EmbedAttribute.SOURCE);
                EmbedUnresolvedClassReferenceProblem problem = new EmbedUnresolvedClassReferenceProblem(source, (String)dependencyEntry.getKey());
                problems.add(problem);
                continue;
            }
            assert (defs != null && defs.length <= 1) : "Lookups using a fully qualified name should find at most 1 definition";
            ICompilationUnit referencedCU = projectScope.getCompilationUnitForScope(defs[0].getContainingScope());
            DependencyTypeSet dependencyTypes = DependencyTypeSet.copyOf(Collections.singleton(dependencyEntry.getValue()));
            this.getProject().addDependency((ICompilationUnit)this, referencedCU, dependencyTypes, defs[0].getQualifiedName());
        }
    }

    private void markClassAsEmbed(ASFileScope fileScope) {
        LinkedList<IDefinition> definitions = new LinkedList<IDefinition>();
        fileScope.collectExternallyVisibleDefinitions(definitions, false);
        for (IDefinition definition : definitions) {
            if (!(definition instanceof ClassDefinition)) continue;
            ClassDefinition classDefinition = (ClassDefinition)definition;
            classDefinition.setGeneratedEmbedClass();
            classDefinition.setExcludedClass();
        }
    }
}

