/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.units;

import com.adobe.flash.compiler.filespecs.IBinaryFileSpecification;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.abc.ABCScopeBuilder;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.projects.DefinitionPriority;
import com.adobe.flash.compiler.internal.scopes.ASFileScopeProvider;
import com.adobe.flash.compiler.internal.units.CompilationUnitBase;
import com.adobe.flash.compiler.internal.units.requests.ABCBytesRequestResult;
import com.adobe.flash.compiler.internal.units.requests.ABCFileScopeRequestResult;
import com.adobe.flash.compiler.internal.units.requests.SyntaxTreeRequestResult;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.InternalCompilerProblem2;
import com.adobe.flash.compiler.problems.InvalidABCByteCodeProblem;
import com.adobe.flash.compiler.problems.NoScopesInABCCompilationUnitProblem;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IABCBytesRequestResult;
import com.adobe.flash.compiler.units.requests.IFileScopeRequestResult;
import com.adobe.flash.compiler.units.requests.IOutgoingDependenciesRequestResult;
import com.adobe.flash.compiler.units.requests.ISWFTagsRequestResult;
import com.adobe.flash.compiler.units.requests.ISyntaxTreeRequestResult;
import com.adobe.flash.swf.SWFFrame;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ABCCompilationUnit
extends CompilationUnitBase {
    private static final String SUB_SYSTEM = "ABCCompilationUnit";

    public ABCCompilationUnit(CompilerProject project, String path) {
        super(project, path, DefinitionPriority.BasePriority.LIBRARY_PATH, false);
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.ABC_UNIT;
    }

    public ICompilationUnit.Operation[] notifyDependencyOperationResultsInvalid(ICompilationUnit dependency, ICompilationUnit.Operation[] invalidatedOperations) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        try {
            List<ICompilerProblem> noProblems = Collections.emptyList();
            SyntaxTreeRequestResult syntaxTreeRequestResult = new SyntaxTreeRequestResult(this.getRootFileSpecification().getLastModified(), noProblems);
            return syntaxTreeRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        }
    }

    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        this.getProject().clearScopeCacheForCompilationUnit(this);
        HashSet<ICompilerProblem> problems = new HashSet<ICompilerProblem>();
        byte[] abcData = this.getABCBytes(problems);
        List<IASScope> scopeList = null;
        try {
            String path = this.getAbsoluteFilename();
            ABCScopeBuilder abcScopeBuilder = new ABCScopeBuilder(this.getProject().getWorkspace(), abcData, path, ASFileScopeProvider.getInstance());
            scopeList = abcScopeBuilder.build();
            if (scopeList.isEmpty()) {
                NoScopesInABCCompilationUnitProblem problem = new NoScopesInABCCompilationUnitProblem(path);
                problems.add(problem);
            }
        }
        catch (Exception e) {
            InvalidABCByteCodeProblem problem = new InvalidABCByteCodeProblem(this.getRootFileSpecification().getPath());
            problems.add(problem);
        }
        ABCFileScopeRequestResult result = new ABCFileScopeRequestResult((Collection<ICompilerProblem>)problems, (Collection<IASScope>)scopeList);
        this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        return result;
    }

    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        ABCBytesRequestResult result = new ABCBytesRequestResult();
        this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        return result;
    }

    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        ISWFTagsRequestResult result = new ISWFTagsRequestResult(){

            @Override
            public boolean addToFrame(SWFFrame frame) {
                return true;
            }

            @Override
            public ICompilerProblem[] getProblems() {
                return IABCBytesRequestResult.ZEROPROBLEMS;
            }

            @Override
            public String getDoABCTagName() {
                return "";
            }
        };
        this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        return result;
    }

    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        IOutgoingDependenciesRequestResult result = new IOutgoingDependenciesRequestResult(){

            @Override
            public ICompilerProblem[] getProblems() {
                return IABCBytesRequestResult.ZEROPROBLEMS;
            }
        };
        this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getABCBytes(Collection<ICompilerProblem> problems) {
        IFileSpecification rootSource = this.getRootFileSpecification();
        byte[] abcData = null;
        if (rootSource instanceof IBinaryFileSpecification) {
            InternalCompilerProblem2 problem;
            IBinaryFileSpecification abcFileSpec = (IBinaryFileSpecification)rootSource;
            InputStream abcStream = null;
            try {
                abcStream = abcFileSpec.createInputStream();
                abcData = IOUtils.toByteArray((InputStream)abcStream);
                assert (abcData != null) : "No ABC byte code.";
            }
            catch (Exception e) {
                problem = new InternalCompilerProblem2(rootSource.getPath(), e, SUB_SYSTEM);
                problems.add(problem);
            }
            finally {
                if (abcStream != null) {
                    try {
                        abcStream.close();
                    }
                    catch (IOException e) {
                        problem = new InternalCompilerProblem2(rootSource.getPath(), e, SUB_SYSTEM);
                        problems.add(problem);
                    }
                }
            }
        } else {
            InvalidABCByteCodeProblem problem = new InvalidABCByteCodeProblem(rootSource.getPath());
            problems.add(problem);
        }
        return abcData;
    }
}

