/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Namespace;
import com.adobe.flash.abc.semantics.Nsset;
import com.adobe.flash.compiler.common.PrefixMap;
import com.adobe.flash.compiler.internal.as.codegen.InstructionListNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLBindingAttributeNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLBindingNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLDataBindingParser;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.IMXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLUnitData;
import com.adobe.flash.compiler.tree.mxml.IMXMLSingleDataBindingNode;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

class XMLBuilder {
    private MXMLInstanceNode parent;
    private MXMLTreeBuilder builder;
    private MXMLTagData rootTag;
    PrefixMap externalPrefixes;
    Set<String> referencedPrefixes = new HashSet<String>();
    private List<MXMLBindingNode> databindings = new ArrayList<MXMLBindingNode>();

    public XMLBuilder(MXMLInstanceNode parent, MXMLTagData rootTag, PrefixMap externalPrefixes, MXMLTreeBuilder builder) {
        this.parent = parent;
        this.rootTag = rootTag;
        this.externalPrefixes = externalPrefixes;
        this.builder = builder;
    }

    void processNode(MXMLTagData tag, StringWriter sw) {
        sw.write(60);
        if (tag.isCloseTag()) {
            sw.write(47);
        }
        sw.write(tag.getName());
        String tagPrefix = tag.getPrefix();
        if (tagPrefix != null) {
            this.lookupPrefix(tagPrefix, tag);
        }
        List<MXMLTagAttributeData> attrs = this.getAttributes(tag);
        for (MXMLTagAttributeData attr : attrs) {
            sw.write(32);
            sw.write(attr.getName());
            sw.write(61);
            sw.write(34);
            sw.write(attr.getRawValue());
            sw.write(34);
            String prefix = attr.getPrefix();
            if (prefix == null) continue;
            this.lookupPrefix(prefix, tag);
        }
        StringWriter childrenSW = new StringWriter();
        for (MXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            this.processNode(unit, childrenSW);
        }
        if (tag == this.rootTag) {
            for (String prefix : this.referencedPrefixes) {
                String uri = this.externalPrefixes.getNamespaceForPrefix(prefix);
                if (uri == null) continue;
                sw.write(" xmlns:");
                sw.write(prefix);
                sw.write("=\"");
                sw.write(uri);
                sw.write(34);
            }
        }
        if (tag.isEmptyTag()) {
            sw.write("/>");
        } else {
            sw.write(62);
        }
        sw.write(childrenSW.toString());
        MXMLTagData endTag = tag.findMatchingEndTag();
        if (endTag != null) {
            this.processNode(endTag, sw);
        }
    }

    void lookupPrefix(String prefix, MXMLTagData tag) {
        while (tag != null) {
            PrefixMap pm = tag.getPrefixMap();
            if (pm != null && pm.containsPrefix(prefix)) {
                return;
            }
            if (tag == this.rootTag) {
                tag = null;
                continue;
            }
            tag = tag.getParentTag();
        }
        if (this.externalPrefixes.containsPrefix(prefix)) {
            this.referencedPrefixes.add(prefix);
        }
    }

    void processNode(MXMLTextData tag, StringWriter sw) {
        switch (tag.getTextType()) {
            case CDATA: {
                sw.write(tag.getContent());
                break;
            }
            case TEXT: {
                IMXMLSingleDataBindingNode db = null;
                db = this.parseBindingExpression(tag);
                if (db != null) {
                    this.databindings.add(this.generateBindingNode(tag, db));
                    if (this.isOnlyTextChild(tag)) break;
                    sw.write("<![CDATA[]]>");
                    break;
                }
                sw.write(XMLBuilder.replaceBindingEscapes(tag.getContent()));
            }
        }
    }

    private MXMLBindingNode generateBindingNode(MXMLTextData tag, IMXMLSingleDataBindingNode dbnode) {
        return this.generateBindingNode(tag, null, dbnode);
    }

    private MXMLBindingNode generateBindingNode(MXMLTagAttributeData attr, IMXMLSingleDataBindingNode dbnode) {
        return this.generateBindingNode(attr.getParent(), attr, dbnode);
    }

    private MXMLBindingNode generateBindingNode(MXMLUnitData tag, MXMLTagAttributeData attr, IMXMLSingleDataBindingNode dbnode) {
        InstructionListNode destExpr = this.getTargetExprNode(tag, attr);
        MXMLBindingNode bindingNode = new MXMLBindingNode(this.parent);
        MXMLBindingAttributeNode target = new MXMLBindingAttributeNode(bindingNode, destExpr);
        destExpr.setParent(target);
        MXMLBindingAttributeNode source = new MXMLBindingAttributeNode(bindingNode, dbnode.getExpressionNode());
        bindingNode.setDestinationAttributeNode(target);
        bindingNode.setSourceAttributeNode(source);
        return bindingNode;
    }

    private IMXMLSingleDataBindingNode parseBindingExpression(MXMLTextData text) {
        Object o = MXMLDataBindingParser.parse(this.parent, text, text.getFragments(this.builder.getProblems()), this.builder.getProblems(), this.builder.getWorkspace(), this.builder.getMXMLDialect());
        if (o instanceof IMXMLSingleDataBindingNode) {
            return (IMXMLSingleDataBindingNode)o;
        }
        return null;
    }

    private IMXMLSingleDataBindingNode parseBindingExpression(MXMLTagAttributeData attr) {
        Object o = MXMLDataBindingParser.parse(this.parent, attr, attr.getValueFragments(this.builder.getProblems()), this.builder.getProblems(), this.builder.getWorkspace(), this.builder.getMXMLDialect());
        if (o instanceof IMXMLSingleDataBindingNode) {
            return (IMXMLSingleDataBindingNode)o;
        }
        return null;
    }

    private InstructionListNode getTargetExprNode(MXMLUnitData data, MXMLTagAttributeData attr) {
        InstructionListNode expr = null;
        InstructionList il = this.getTargetInstructions(data, attr);
        if (il != null) {
            expr = new InstructionListNode(il);
        }
        return expr;
    }

    private InstructionList getTargetInstructions(MXMLUnitData data, MXMLTagAttributeData attr) {
        MXMLUnitData d = data;
        Stack<MXMLUnitData> parentStack = new Stack<MXMLUnitData>();
        if (this.isOnlyTextChild(d)) {
            d = d.getParentUnitData();
        }
        MXMLUnitData target = d;
        while (d != null) {
            parentStack.add(d);
            d = d == this.rootTag ? null : d.getParentUnitData();
        }
        InstructionList il = new InstructionList();
        il.addInstruction(208);
        while (parentStack.size() > 1) {
            MXMLUnitData unitData = (MXMLUnitData)parentStack.pop();
            if (!(unitData instanceof MXMLTagData)) continue;
            this.generateGetInstructions(il, (MXMLTagData)unitData);
        }
        if (target instanceof MXMLTagData) {
            if (attr == null) {
                this.generateSetInstructions(il, (MXMLTagData)target);
            } else {
                this.generateGetInstructions(il, (MXMLTagData)target);
                this.generateSetInstructions(il, attr);
            }
        } else if (target instanceof MXMLTextData) {
            this.generateSetInstructions(il, (MXMLTextData)target);
        }
        return il;
    }

    private void generateGetInstructions(InstructionList il, MXMLTagData tag) {
        if (tag == this.rootTag) {
            il.addInstruction(102, this.getNameForTag(tag));
        } else {
            il.addInstruction(102, this.getNameForTag(tag));
            int index = this.getIndexOfTag(tag);
            il.addInstruction(102, new Name(String.valueOf(index)));
        }
    }

    private void generateSetInstructions(InstructionList il, MXMLTagData tag) {
        if (tag == this.rootTag) {
            il.addInstruction(209);
            il.addInstruction(97, this.getNameForTag(tag));
        } else {
            il.addInstruction(102, this.getNameForTag(tag));
            il.addInstruction(209);
            int index = this.getIndexOfTag(tag);
            il.addInstruction(97, new Name(String.valueOf(index)));
        }
    }

    private void generateSetInstructions(InstructionList il, MXMLTagAttributeData attr) {
        il.addInstruction(209);
        il.addInstruction(97, this.getNameForAttr(attr));
    }

    private void generateSetInstructions(InstructionList il, MXMLTextData text) {
        il.addInstruction(70, new Object[]{new Name("text"), 0});
        il.addInstruction(209);
        int index = this.getIndexOfText(text);
        il.addInstruction(97, new Name(String.valueOf(index)));
    }

    private int getIndexOfTag(MXMLTagData tag) {
        MXMLTagData parent = tag.getParentTag();
        int index = 0;
        for (MXMLTagData d = parent.getFirstChild(true); d != null && d != tag; d = d.getNextSibling(true)) {
            if (!d.getName().equals(tag.getName())) continue;
            ++index;
        }
        return index;
    }

    private int getIndexOfText(MXMLTextData text) {
        MXMLUnitData parent = text.getParentUnitData();
        MXMLTagData parentTag = parent instanceof MXMLTagData ? (MXMLTagData)parent : null;
        int index = 0;
        if (parentTag != null) {
            for (MXMLUnitData d = parentTag.getFirstChildUnit(); d != null && d != text; d = d.getNextSiblingUnit()) {
                if (!(d instanceof MXMLTextData) || ((MXMLTextData)d).getTextType() != IMXMLTextData.TextType.CDATA) continue;
                ++index;
            }
        }
        return index;
    }

    private boolean isOnlyTextChild(MXMLUnitData child) {
        if (child instanceof MXMLTextData && ((MXMLTextData)child).getTextType() == IMXMLTextData.TextType.TEXT) {
            MXMLTagData parent;
            MXMLUnitData p = child.getParentUnitData();
            MXMLTagData mXMLTagData = parent = p instanceof MXMLTagData ? (MXMLTagData)p : null;
            if (parent != null) {
                return parent.getFirstChildUnit() == child && child.getNextSiblingUnit() == null;
            }
        }
        return false;
    }

    private Name getNameForTag(MXMLTagData tag) {
        if (tag == this.rootTag) {
            return new Name(this.parent.getEffectiveID());
        }
        String uri = tag.getURI();
        if (uri != null) {
            return new Name(new Namespace(8, uri), tag.getShortName());
        }
        return new Name(tag.getShortName());
    }

    private Name getNameForAttr(MXMLTagAttributeData attr) {
        String uri = attr.getURI();
        if (uri != null) {
            return new Name(13, new Nsset(new Namespace(8, uri)), attr.getShortName());
        }
        return new Name(13, new Nsset(new Namespace(8, "")), attr.getShortName());
    }

    public static String replaceBindingEscapes(String toClean) {
        toClean = XMLBuilder.cleanupEscapedCharForXML('{', toClean);
        toClean = XMLBuilder.cleanupEscapedCharForXML('}', toClean);
        toClean = XMLBuilder.cleanupEscapedCharForXML('@', toClean);
        return toClean;
    }

    private static String cleanupEscapedCharForXML(char escapedChar, String toClean) {
        int i;
        if (toClean == null || toClean.indexOf(escapedChar) == -1 || toClean.indexOf(92) == -1) {
            return toClean;
        }
        StringBuilder buf = new StringBuilder(toClean.length());
        char[] chars = toClean.toCharArray();
        for (i = 0; i < chars.length - 1; ++i) {
            if (chars[i] != '\\' || chars[i + 1] != escapedChar) {
                buf.append(chars[i]);
                continue;
            }
            buf.append("&#x" + Integer.toString(chars[i + 1], 16) + ";");
            ++i;
        }
        if (i == chars.length - 1) {
            buf.append(chars[chars.length - 1]);
        }
        return buf.toString();
    }

    List<MXMLTagAttributeData> getAttributes(MXMLTagData tag) {
        MXMLTagAttributeData[] rawAttrs = tag.getAttributeDatas();
        if (rawAttrs != null) {
            ArrayList<MXMLTagAttributeData> attrs = new ArrayList<MXMLTagAttributeData>(rawAttrs.length);
            for (MXMLTagAttributeData attr : rawAttrs) {
                IMXMLSingleDataBindingNode db = null;
                db = this.parseBindingExpression(attr);
                if (db != null) {
                    this.databindings.add(this.generateBindingNode(attr, db));
                    continue;
                }
                attrs.add(attr);
            }
            return attrs;
        }
        return Collections.emptyList();
    }

    void processNode(MXMLUnitData node, StringWriter sw) {
        if (node instanceof MXMLTagData) {
            this.processNode((MXMLTagData)node, sw);
        } else if (node instanceof MXMLTextData) {
            this.processNode((MXMLTextData)node, sw);
        }
    }

    public List<MXMLBindingNode> getDatabindings() {
        return this.databindings;
    }
}

