/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASProjectScope;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.tree.mxml.XMLBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.problems.MXMLDualContentProblem;
import com.adobe.flash.compiler.problems.MXMLUnknownXMLFormatProblem;
import com.adobe.flash.compiler.problems.MXMLXMLOnlyOneRootTagProblem;
import com.adobe.flash.compiler.problems.MXMLXMLRequireContentProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLXMLNode;
import java.io.StringWriter;

class MXMLXMLNode
extends MXMLInstanceNode
implements IMXMLXMLNode {
    private MXMLTagData rootTag;
    private IMXMLXMLNode.XML_TYPE xmlType = IMXMLXMLNode.XML_TYPE.E4X;
    boolean multipleTags = false;
    private String xmlString;

    MXMLXMLNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLXMLID;
    }

    @Override
    public String getName() {
        return "XML";
    }

    @Override
    public IMXMLXMLNode.XML_TYPE getXMLType() {
        return this.xmlType;
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            String sourcePath = MXMLXMLNode.resolveSourceAttributePath(builder, attribute, info);
            if (sourcePath != null) {
                this.xmlString = builder.readExternalFile(attribute, sourcePath);
            }
        } else if (attribute.isSpecialAttribute("format")) {
            String attrValue = attribute.getRawValue().toLowerCase();
            if (attrValue.equals("e4x")) {
                this.xmlType = IMXMLXMLNode.XML_TYPE.E4X;
            } else if (attrValue.equals("xml")) {
                this.xmlType = IMXMLXMLNode.XML_TYPE.OLDXML;
            } else {
                MXMLUnknownXMLFormatProblem problem = new MXMLUnknownXMLFormatProblem(attribute);
                builder.addProblem(problem);
                this.xmlType = IMXMLXMLNode.XML_TYPE.OLDXML;
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        info.hasDualContent = true;
        if (this.rootTag == null) {
            this.rootTag = childTag;
        } else {
            this.multipleTags = true;
        }
    }

    @Override
    public IClassDefinition getClassReference(ICompilerProject project) {
        if (this.xmlType == IMXMLXMLNode.XML_TYPE.OLDXML) {
            ASProjectScope projectScope = (ASProjectScope)project.getScope();
            return (IClassDefinition)projectScope.findDefinitionByName("flash.xml.XMLNode");
        }
        return super.getClassReference(project);
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (info.hasSourceAttribute && info.hasDualContent) {
            MXMLDualContentProblem problem = new MXMLDualContentProblem(tag, tag.getShortName());
            builder.addProblem(problem);
            return;
        }
        if (this.multipleTags) {
            builder.addProblem(new MXMLXMLOnlyOneRootTagProblem(tag));
        }
        if (this.rootTag == null && !tag.isEmptyTag()) {
            builder.addProblem(new MXMLXMLRequireContentProblem(tag));
        }
        this.analyzeXML(builder);
        this.rootTag = null;
        if (this.xmlType == IMXMLXMLNode.XML_TYPE.OLDXML) {
            FlexProject project = builder.getProject();
            builder.addExpressionDependency(project.getXMLUtilClass());
        }
    }

    @Override
    public String getXMLString() {
        return this.xmlString == null ? "" : this.xmlString;
    }

    private void analyzeXML(MXMLTreeBuilder builder) {
        if (this.rootTag != null) {
            StringWriter writer = new StringWriter();
            XMLBuilder xmlBuilder = new XMLBuilder(this, this.rootTag, this.rootTag.getCompositePrefixMap(), builder);
            xmlBuilder.processNode(this.rootTag, writer);
            this.setChildren(xmlBuilder.getDatabindings().toArray(new IMXMLNode[0]));
            this.xmlString = writer.toString();
        }
    }
}

