/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.tree.mxml.XMLBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.problems.MXMLXMLListMixedContentProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLXMLListNode;
import java.io.StringWriter;
import java.util.ArrayList;

class MXMLXMLListNode
extends MXMLInstanceNode
implements IMXMLXMLListNode {
    private ArrayList<MXMLTagData> childTags = new ArrayList();
    private String xmlString;

    MXMLXMLListNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLXMLListID;
    }

    @Override
    public String getName() {
        return "XMLList";
    }

    @Override
    public String getXMLString() {
        return this.xmlString;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        this.childTags.add(childTag);
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        builder.addProblem(new MXMLXMLListMixedContentProblem(tag));
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.analyzeXML(builder);
        super.initializationComplete(builder, tag, info);
        this.childTags = null;
    }

    private void analyzeXML(MXMLTreeBuilder builder) {
        StringWriter sw = new StringWriter();
        for (MXMLTagData tag : this.childTags) {
            new XMLBuilder(this, tag, tag.getCompositePrefixMap(), builder).processNode(tag, sw);
        }
        this.xmlString = sw.toString();
    }
}

