/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.XMLName;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLWebServiceOperationNode;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLWebServiceNode;

class MXMLWebServiceNode
extends MXMLInstanceNode
implements IMXMLWebServiceNode {
    private static final String TAG_OPERATION = "operation";
    private static final String BASENAME_WEB_SERVICE_OPERATION = "WebServiceOperation";

    MXMLWebServiceNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLWebServiceID;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        if (childTag.getShortName().equals(TAG_OPERATION)) {
            FlexProject project = builder.getProject();
            XMLName name = new XMLName(childTag.getXMLName().getXMLNamespace(), BASENAME_WEB_SERVICE_OPERATION);
            String qname = builder.getFileScope().resolveXMLNameToQualifiedName(name, builder.getMXMLDialect());
            String webServiceOperationQName = project.getWebServiceOperationQName();
            if (qname != null && qname.equals(webServiceOperationQName)) {
                MXMLWebServiceOperationNode operationNode = new MXMLWebServiceOperationNode(this);
                operationNode.setClassReference(project, webServiceOperationQName);
                operationNode.initializeFromTag(builder, childTag);
                info.addChildNode(operationNode);
            }
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
    }
}

