/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.AppliedVectorDefinitionFactory;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.definitions.AppliedVectorDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASProjectScope;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.problems.MXMLIncompatibleVectorElementProblem;
import com.adobe.flash.compiler.problems.MXMLInvalidVectorFixedAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLInvalidVectorTypeAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLMissingVectorTypeAttributeProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLVectorNode;

class MXMLVectorNode
extends MXMLInstanceNode
implements IMXMLVectorNode {
    private static final String DOT_LESS_THAN_ESCAPED = ".&lt;";
    private static final String GREATER_THAN_ESCAPED = "&gt;";
    private ITypeDefinition type;
    private Boolean fixed = false;

    MXMLVectorNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLVectorID;
    }

    @Override
    public String getName() {
        return "Vector";
    }

    @Override
    public IClassDefinition getClassReference(ICompilerProject project) {
        ASProjectScope projectScope = (ASProjectScope)project.getScope();
        return projectScope.newVectorClass(this.type);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        String value = attribute.getRawValue();
        if (attribute.isSpecialAttribute("type")) {
            FlexProject project = builder.getProject();
            IDefinition def = this.resolveElementType(value, project);
            if (def instanceof ITypeDefinition) {
                this.type = (ITypeDefinition)def;
            } else {
                MXMLInvalidVectorTypeAttributeProblem problem = new MXMLInvalidVectorTypeAttributeProblem(attribute);
                builder.addProblem(problem);
            }
        } else if (attribute.isSpecialAttribute("fixed")) {
            value = attribute.getMXMLDialect().trim(value);
            if (value.equals("true")) {
                this.fixed = true;
            } else if (value.equals("false")) {
                this.fixed = false;
            } else {
                MXMLInvalidVectorFixedAttributeProblem problem = new MXMLInvalidVectorFixedAttributeProblem(attribute);
                builder.addProblem(problem);
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    private IDefinition resolveElementType(String value, FlexProject project) {
        int endIdx;
        IDefinition def = null;
        int dotLessIdx = value.indexOf(DOT_LESS_THAN_ESCAPED);
        if (dotLessIdx != -1 && (endIdx = value.lastIndexOf(GREATER_THAN_ESCAPED)) != -1) {
            ITypeDefinition vectorType;
            String typeArg = value.substring(dotLessIdx + 5, endIdx);
            IDefinition typeParam = this.resolveElementType(typeArg, project);
            String baseName = value.substring(0, dotLessIdx);
            IDefinition baseType = null;
            baseType = baseName.equals("Vector") ? project.getBuiltinType(IASLanguageConstants.BuiltinType.VECTOR) : project.getScope().findDefinitionByName(baseName);
            if (baseType instanceof ITypeDefinition && typeParam instanceof ITypeDefinition && baseType == (vectorType = project.getBuiltinType(IASLanguageConstants.BuiltinType.VECTOR))) {
                def = AppliedVectorDefinitionFactory.newVector(project, (ITypeDefinition)typeParam);
            }
        }
        if (def == null) {
            def = project.getScope().findDefinitionByName(value);
        }
        return def;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        FlexProject project = builder.getProject();
        String tagName = builder.getFileScope().resolveTagToQualifiedName(childTag);
        IDefinition definition = project.getScope().findDefinitionByName(tagName);
        if (definition instanceof ClassDefinition) {
            MXMLInstanceNode instanceNode = MXMLInstanceNode.createInstanceNode(builder, tagName, this);
            instanceNode.setClassReference(project, (ClassDefinition)definition);
            instanceNode.initializeFromTag(builder, childTag);
            info.addChildNode(instanceNode);
            if (!instanceNode.getClassReference(project).isInstanceOf(this.type, (ICompilerProject)project)) {
                MXMLIncompatibleVectorElementProblem problem = new MXMLIncompatibleVectorElementProblem(childTag);
                builder.addProblem(problem);
            }
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.setChildren(info.getChildNodeList().toArray(new MXMLInstanceNode[0]));
        if (this.type != null) {
            FlexProject project = builder.getProject();
            ITypeDefinition t = this.type;
            while (t instanceof AppliedVectorDefinition) {
                t = ((AppliedVectorDefinition)t).resolveElementType(project);
            }
            String qname = t.getQualifiedName();
            builder.addDependency(qname, DependencyType.EXPRESSION);
            if (this.getID() != null) {
                builder.addDependency(qname, DependencyType.SIGNATURE);
            }
        } else {
            MXMLMissingVectorTypeAttributeProblem problem = new MXMLMissingVectorTypeAttributeProblem(tag);
            builder.addProblem(problem);
        }
    }

    @Override
    public ITypeDefinition getType() {
        return this.type;
    }

    @Override
    public boolean getFixed() {
        return this.fixed;
    }
}

