/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.IFileSpecificationGetter;
import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.parsing.SourceFragmentsReader;
import com.adobe.flash.compiler.internal.parsing.as.ASParser;
import com.adobe.flash.compiler.internal.parsing.as.IProjectConfigVariables;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASProjectScope;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLArrayNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLBooleanNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLCompilerDirectiveParser;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLDataBindingParser;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLDeferredInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLFactoryNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLFileNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLFunctionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLIntNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLLiteralNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNumberNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLRegExpNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLStringNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLUintNode;
import com.adobe.flash.compiler.internal.units.MXMLCompilationUnit;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.mxml.IMXMLDataManager;
import com.adobe.flash.compiler.mxml.MXMLData;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.MXMLInvalidPercentageProblem;
import com.adobe.flash.compiler.problems.MXMLInvalidSourceAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLInvalidTextForTypeProblem;
import com.adobe.flash.compiler.problems.MXMLPercentageNotAllowedProblem;
import com.adobe.flash.compiler.problems.UnexpectedExceptionProblem;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassDefinitionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDataBindingNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLFileNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import com.adobe.flash.compiler.units.ICompilationUnit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class MXMLTreeBuilder {
    private static final Pattern percentagePattern = Pattern.compile("\\s*((\\d+)(.(\\d)+)?)\\s*%\\s*");
    private final MXMLCompilationUnit compilationUnit;
    private final IFileSpecificationGetter fileSpecGetter;
    private final FlexProject project;
    private final ASProjectScope projectScope;
    private final Workspace workspace;
    private final IFileSpecification fileSpecification;
    private final String path;
    private final MXMLData mxmlData;
    private final MXMLDialect mxmlDialect;
    private final String qname;
    private final MXMLFileScope fileScope;
    private final Collection<ICompilerProblem> problems;
    private MXMLFileNode fileNode;
    private IVariableDefinition percentProxyDefinition;

    public MXMLTreeBuilder(MXMLCompilationUnit compilationUnit, IFileSpecificationGetter fileSpecGetter, String qname, MXMLData mxmlData, MXMLFileScope fileScope, Collection<ICompilerProblem> problems) {
        this.compilationUnit = compilationUnit;
        this.fileSpecGetter = fileSpecGetter;
        this.project = compilationUnit.getProject();
        this.projectScope = this.project.getScope();
        this.workspace = this.project.getWorkspace();
        this.qname = qname;
        this.fileSpecification = fileSpecGetter.getFileSpecification(compilationUnit.getAbsoluteFilename());
        this.path = this.fileSpecification.getPath();
        this.mxmlData = mxmlData;
        this.mxmlDialect = mxmlData.getMXMLDialect();
        this.fileScope = fileScope;
        this.problems = problems;
    }

    public MXMLCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public FlexProject getProject() {
        return this.project;
    }

    public ASProjectScope getProjectScope() {
        return this.projectScope;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public IFileSpecification getFileSpecification() {
        return this.fileSpecification;
    }

    public String getPath() {
        return this.path;
    }

    public MXMLData getMXMLData() {
        return this.mxmlData;
    }

    public MXMLDialect getMXMLDialect() {
        return this.mxmlDialect;
    }

    public String getQName() {
        return this.qname;
    }

    public MXMLFileScope getFileScope() {
        return this.fileScope;
    }

    public Collection<ICompilerProblem> getProblems() {
        return this.problems;
    }

    public void addProblem(ICompilerProblem problem) {
        this.problems.add(problem);
    }

    public MXMLFileNode getFileNode() {
        return this.fileNode;
    }

    public IVariableDefinition getPercentProxyDefinition() {
        return this.percentProxyDefinition;
    }

    public ITypeDefinition getBuiltinType(String name) {
        return (ITypeDefinition)this.projectScope.findDefinitionByName(name);
    }

    public IMXMLFileNode build() {
        this.fileNode = new MXMLFileNode();
        try {
            this.fileNode.initialize(this);
        }
        catch (Throwable t) {
            UnexpectedExceptionProblem problem = new UnexpectedExceptionProblem(t);
            this.addProblem(problem);
        }
        return this.fileNode;
    }

    private Object parseValue(IMXMLNode propertyNode, ITypeDefinition type, String text, EnumSet<MXMLDialect.TextParsingFlags> flags) {
        Object result = null;
        String typeName = type.getQualifiedName();
        if (typeName.equals("Boolean")) {
            result = this.mxmlDialect.parseBoolean(this.project, text, flags);
        } else if (typeName.equals("int")) {
            result = this.mxmlDialect.parseInt(this.project, text, flags);
            if (result == null) {
                result = this.parsePercent(this.project, propertyNode, text, flags);
            }
        } else if (typeName.equals("uint")) {
            result = this.mxmlDialect.parseUint(this.project, text, flags);
            if (result == null) {
                result = this.parsePercent(this.project, propertyNode, text, flags);
            }
        } else if (typeName.equals("Number")) {
            result = this.mxmlDialect.parseNumber(this.project, text, flags);
            if (result == null) {
                result = this.parsePercent(this.project, propertyNode, text, flags);
            }
        } else if (typeName.equals("String")) {
            result = this.mxmlDialect.parseString(this.project, text, flags);
        } else if (typeName.equals("Array")) {
            result = this.mxmlDialect.parseArray(this.project, text, flags);
        } else if (typeName.equals("Object") || typeName.equals("*")) {
            result = this.mxmlDialect.parseObject(this.project, text, flags);
        }
        return result;
    }

    private Number parsePercent(FlexProject project, IMXMLNode propertyNode, String s, EnumSet<MXMLDialect.TextParsingFlags> flags) {
        if (flags != null && flags.contains((Object)MXMLDialect.TextParsingFlags.ALLOW_PERCENT)) {
            IVariableDefinition percentProxyDefinition;
            int percentIndex = s.indexOf(37);
            if (percentIndex == -1) {
                return null;
            }
            IVariableDefinition iVariableDefinition = percentProxyDefinition = propertyNode instanceof IMXMLPropertySpecifierNode ? ((IMXMLPropertySpecifierNode)propertyNode).getPercentProxyDefinition(project) : null;
            if (percentProxyDefinition != null) {
                String match;
                Matcher m = percentagePattern.matcher(s);
                String string = match = m.matches() ? m.group(1) + '%' : null;
                if (match != null) {
                    this.percentProxyDefinition = percentProxyDefinition;
                    return Double.valueOf(s.substring(0, percentIndex));
                }
                MXMLInvalidPercentageProblem problem = new MXMLInvalidPercentageProblem((SourceLocation)((Object)propertyNode), propertyNode.getName(), s);
                this.problems.add(problem);
            } else {
                MXMLPercentageNotAllowedProblem problem = new MXMLPercentageNotAllowedProblem((SourceLocation)((Object)propertyNode), propertyNode.getName(), s);
                this.problems.add(problem);
            }
        }
        return null;
    }

    private MXMLLiteralNode createLiteralNode(IMXMLNode propertyNode, ITypeDefinition type, ISourceFragment[] fragments, SourceLocation location, EnumSet<MXMLDialect.TextParsingFlags> flags, Object defaultValue) {
        Object value;
        MXMLLiteralNode literalNode = null;
        String text = SourceFragmentsReader.concatLogicalText(fragments);
        Object object = value = this.mxmlDialect.isWhitespace(text) ? defaultValue : this.parseValue(propertyNode, type, text, flags);
        if (value != null || type.getQualifiedName().equals("String")) {
            literalNode = new MXMLLiteralNode(null, value);
            literalNode.setSourceLocation(location);
        }
        return literalNode;
    }

    public NodeBase parseExpressionNode(ITypeDefinition type, ISourceFragment[] fragments, SourceLocation location, EnumSet<MXMLDialect.TextParsingFlags> flags, Object defaultValue, MXMLClassDefinitionNode classNode, boolean postProcess) {
        SourceFragmentsReader reader = new SourceFragmentsReader(location.getSourcePath(), fragments);
        IProjectConfigVariables projectConfigVariables = this.getProject().getProjectConfigVariables();
        ExpressionNodeBase expressionNode = ASParser.parseExpression(this.getWorkspace(), reader, this.problems, projectConfigVariables, location);
        if (expressionNode == null) {
            return null;
        }
        expressionNode.setParent(classNode);
        if (postProcess) {
            this.postProcess(expressionNode, classNode);
        }
        return expressionNode;
    }

    private void postProcess(NodeBase node, IMXMLClassDefinitionNode classNode) {
        EnumSet<PostProcessStep> postProcessSteps = EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, PostProcessStep.RECONNECT_DEFINITIONS);
        ASScope classScope = (ASScope)classNode.getClassDefinition().getContainedScope();
        node.runPostProcess(postProcessSteps, classScope);
    }

    public NodeBase createExpressionNode(IMXMLNode propertyNode, ITypeDefinition type, ISourceFragment[] fragments, SourceLocation location, EnumSet<MXMLDialect.TextParsingFlags> flags, Object defaultValue, MXMLClassDefinitionNode classNode) {
        Object result;
        NodeBase expressionNode = null;
        if (flags.contains((Object)MXMLDialect.TextParsingFlags.ALLOW_BINDING) && (result = MXMLDataBindingParser.parse(null, location, fragments, this.problems, this.workspace, this.mxmlDialect)) instanceof IMXMLDataBindingNode) {
            expressionNode = (NodeBase)result;
            classNode.setHasDataBindings();
        }
        if (expressionNode == null && flags.contains((Object)MXMLDialect.TextParsingFlags.ALLOW_COMPILER_DIRECTIVE)) {
            String text = SourceFragmentsReader.concatLogicalText(fragments);
            expressionNode = MXMLCompilerDirectiveParser.parse(this, propertyNode, location, text, type);
        }
        String typeName = type.getQualifiedName();
        if (expressionNode == null && (typeName.equals("Class") || typeName.equals("Function") || typeName.equals("RegExp"))) {
            expressionNode = this.parseExpressionNode(type, fragments, location, flags, defaultValue, classNode, false);
        }
        if (expressionNode == null) {
            expressionNode = this.createLiteralNode(propertyNode, type, fragments, location, flags, defaultValue);
        }
        if (expressionNode == null) {
            String text = SourceFragmentsReader.concatLogicalText(fragments);
            MXMLInvalidTextForTypeProblem problem = new MXMLInvalidTextForTypeProblem(location, text, typeName);
            this.addProblem(problem);
        }
        return expressionNode;
    }

    public MXMLInstanceNode createInstanceNode(NodeBase parent, ITypeDefinition type, ISourceFragment[] fragments, SourceLocation location, EnumSet<MXMLDialect.TextParsingFlags> flags, MXMLClassDefinitionNode classNode) {
        MXMLInstanceNode instanceNode = null;
        this.percentProxyDefinition = null;
        String typeName = type.getQualifiedName();
        if (typeName.equals(this.project.getFactoryInterface())) {
            instanceNode = new MXMLFactoryNode(parent);
            ((MXMLFactoryNode)instanceNode).initializeFromFragments(this, location, fragments);
        } else if (typeName.equals(this.project.getDeferredInstanceInterface()) || typeName.equals(this.project.getTransientDeferredInstanceInterface())) {
            instanceNode = new MXMLDeferredInstanceNode(parent);
            ((MXMLDeferredInstanceNode)instanceNode).initializeFromFragments(this, location, fragments);
        } else {
            NodeBase expressionNode = this.createExpressionNode((IMXMLNode)((Object)parent), type, fragments, location, flags, null, classNode);
            if (expressionNode instanceof MXMLInstanceNode) {
                instanceNode = (MXMLInstanceNode)expressionNode;
            } else if (expressionNode instanceof MXMLLiteralNode) {
                Object value = ((MXMLLiteralNode)expressionNode).getValue();
                if (value instanceof Boolean) {
                    instanceNode = new MXMLBooleanNode(parent);
                    ((MXMLBooleanNode)instanceNode).initialize(this, location, "Boolean", expressionNode);
                } else if (value instanceof Integer) {
                    instanceNode = new MXMLIntNode(parent);
                    ((MXMLIntNode)instanceNode).initialize(this, location, "int", expressionNode);
                } else if (value instanceof Long) {
                    instanceNode = new MXMLUintNode(parent);
                    ((MXMLUintNode)instanceNode).initialize(this, location, "uint", expressionNode);
                } else if (value instanceof Number) {
                    instanceNode = new MXMLNumberNode(parent);
                    ((MXMLNumberNode)instanceNode).initialize(this, location, "Number", expressionNode);
                } else if (value instanceof String || value == null) {
                    instanceNode = new MXMLStringNode(parent);
                    ((MXMLStringNode)instanceNode).initialize(this, location, "String", expressionNode);
                } else if (value instanceof List) {
                    instanceNode = new MXMLArrayNode(parent);
                    ((MXMLArrayNode)instanceNode).initialize(this, location, (List)value);
                } else assert (false);
            } else if (typeName.equals("Class")) {
                instanceNode = new MXMLClassNode(parent);
                ((MXMLClassNode)instanceNode).initialize(this, location, "Class", expressionNode);
                this.postProcess(instanceNode, classNode);
            } else if (typeName.equals("Function")) {
                instanceNode = new MXMLFunctionNode(parent);
                ((MXMLFunctionNode)instanceNode).initialize(this, location, "Function", expressionNode);
                this.postProcess(instanceNode, classNode);
            } else if (typeName.equals("RegExp")) {
                instanceNode = new MXMLRegExpNode(parent);
                ((MXMLRegExpNode)instanceNode).initialize(this, location, "RegExp", expressionNode);
                this.postProcess(instanceNode, classNode);
            }
        }
        if (instanceNode != null) {
            instanceNode.setParent(parent);
        }
        return instanceNode;
    }

    public String readExternalFile(MXMLTagAttributeData sourceAttribute, String resolvedSourcePath) {
        String text;
        Reader sourceFileReader;
        IFileSpecificationGetter fileSpecGetter = this.getFileSpecificationGetter();
        IFileSpecification sourceFileSpec = fileSpecGetter.getFileSpecification(resolvedSourcePath);
        try {
            sourceFileReader = sourceFileSpec.createReader();
        }
        catch (FileNotFoundException e) {
            MXMLInvalidSourceAttributeProblem problem = new MXMLInvalidSourceAttributeProblem(sourceAttribute, resolvedSourcePath);
            this.addProblem(problem);
            return null;
        }
        try {
            text = IOUtils.toString((Reader)sourceFileReader);
            IOUtils.closeQuietly((Reader)sourceFileReader);
        }
        catch (IOException e) {
            return null;
        }
        return text;
    }

    public MXMLData getExternalMXMLData(MXMLTagAttributeData sourceAttribute, String resolvedSourcePath) {
        File file = new File(resolvedSourcePath);
        if (!file.exists()) {
            MXMLInvalidSourceAttributeProblem problem = new MXMLInvalidSourceAttributeProblem(sourceAttribute, resolvedSourcePath);
            this.addProblem(problem);
            return null;
        }
        Workspace workspace = this.getWorkspace();
        IFileSpecification sourceFileSpec = workspace.getFileSpecification(resolvedSourcePath);
        IMXMLDataManager mxmlDataManager = workspace.getMXMLDataManager();
        return mxmlDataManager.get(sourceFileSpec);
    }

    public void addDependency(String qname, DependencyType type) {
        if (qname == null) {
            return;
        }
        ASProjectScope projectScope = this.getProjectScope();
        IDefinition definition = projectScope.findDefinitionByName(qname);
        if (definition == null) {
            return;
        }
        MXMLCompilationUnit thisCU = this.getCompilationUnit();
        ICompilationUnit otherCU = projectScope.getCompilationUnitForDefinition(definition);
        FlexProject project = this.getProject();
        project.addDependency((ICompilationUnit)thisCU, otherCU, type, qname);
    }

    public void addExpressionDependency(String qname) {
        this.addDependency(qname, DependencyType.EXPRESSION);
    }

    public String toString() {
        return this.fileNode != null ? this.fileNode.toString() : "";
    }

    public final IFileSpecificationGetter getFileSpecificationGetter() {
        return this.fileSpecGetter;
    }
}

