/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IStyleDefinition;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLPropertySpecifierNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.problems.MXMLInvalidStyleProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassReferenceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLStyleSpecifierNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;

class MXMLStyleSpecifierNode
extends MXMLPropertySpecifierNode
implements IMXMLStyleSpecifierNode {
    MXMLStyleSpecifierNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLStyleSpecifierID;
    }

    @Override
    protected void initializeFromAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializeFromAttribute(builder, attribute, info);
        this.validateStyle(builder, attribute);
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        this.validateStyle(builder, tag);
    }

    private void validateStyle(MXMLTreeBuilder builder, ISourceLocation source) {
        IStyleDefinition styleTag;
        ImmutableSet applicableThemes;
        IDefinition definition = this.getDefinition();
        if (definition instanceof IStyleDefinition && !(applicableThemes = ImmutableSet.copyOf((Object[])(styleTag = (IStyleDefinition)definition).getThemes())).isEmpty()) {
            boolean isStyleValid;
            ImmutableSet themeNames = ImmutableSet.copyOf(builder.getProject().getThemeNames());
            boolean bl = isStyleValid = !Sets.intersection((Set)themeNames, (Set)applicableThemes).isEmpty();
            if (!isStyleValid) {
                String componentType = this.getParent() instanceof IMXMLClassReferenceNode ? ((IMXMLClassReferenceNode)this.getParent()).getClassReference(builder.getProject()).getBaseName() : "";
                MXMLInvalidStyleProblem problem = new MXMLInvalidStyleProblem(source, this.getName(), componentType, styleTag.getThemes());
                builder.addProblem(problem);
            }
        }
    }
}

