/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.css.ICSSDocument;
import com.adobe.flash.compiler.internal.caches.CSSDocumentCache;
import com.adobe.flash.compiler.internal.css.CSSDocument;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.MXMLDualContentProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLStyleNode;
import java.util.Collection;
import org.antlr.runtime.ANTLRStringStream;

class MXMLStyleNode
extends MXMLNodeBase
implements IMXMLStyleNode {
    private ICSSDocument cssDocument;
    private String cssText;

    MXMLStyleNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLStyleID;
    }

    @Override
    public String getName() {
        return "Style";
    }

    @Override
    public ICSSDocument getCSSDocument(Collection<ICompilerProblem> problems) {
        if (this.cssDocument == null) {
            if (this.cssText != null && !this.cssText.isEmpty()) {
                ANTLRStringStream stream = new ANTLRStringStream(this.cssText);
                stream.name = this.getSourcePath();
                this.cssDocument = CSSDocument.parse(stream, problems);
            } else {
                this.cssDocument = CSSDocumentCache.EMPTY_CSS_DOCUMENT;
            }
        }
        return this.cssDocument;
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            String sourcePath = MXMLStyleNode.resolveSourceAttributePath(builder, attribute, info);
            if (sourcePath != null) {
                this.cssText = builder.readExternalFile(attribute, sourcePath);
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        info.hasDualContent = true;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (info.hasSourceAttribute && info.hasDualContent) {
            MXMLDualContentProblem problem = new MXMLDualContentProblem(tag, tag.getShortName());
            builder.addProblem(problem);
            return;
        }
        if (this.cssText == null) {
            this.cssText = tag.getCompilableText();
        }
        builder.getFileNode().getStyleNodes().add(this);
    }
}

