/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.as.ASParser;
import com.adobe.flash.compiler.internal.parsing.as.IncludeHandler;
import com.adobe.flash.compiler.internal.parsing.as.OffsetLookup;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.as.ScopedBlockNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLFileNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLUnitData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.MXMLDualContentProblem;
import com.adobe.flash.compiler.problems.UnexpectedExceptionProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLScriptNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

class MXMLScriptNode
extends MXMLNodeBase
implements IMXMLScriptNode {
    private IASNode[] asNodes;

    MXMLScriptNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLScriptID;
    }

    @Override
    public IASNode getChild(int i) {
        return this.asNodes != null ? this.asNodes[i] : null;
    }

    @Override
    public int getChildCount() {
        return this.asNodes != null ? this.asNodes.length : 0;
    }

    @Override
    public String getName() {
        return "Script";
    }

    @Override
    public IASNode[] getASNodes() {
        if (this.asNodes == null) {
            this.asNodes = new MXMLScriptNode[0];
        }
        return this.asNodes;
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            MXMLClassDefinitionNode classNode = this.getContainingClassNode();
            ASScope classScope = (ASScope)classNode.getClassDefinition().getContainedScope();
            String sourcePath = MXMLScriptNode.resolveSourceAttributePath(builder, attribute, info);
            if (sourcePath != null) {
                FlexProject project = builder.getProject();
                Workspace workspace = builder.getWorkspace();
                Collection<ICompilerProblem> problems = builder.getProblems();
                IFileSpecification sourceFileSpec = workspace.getFileSpecification(sourcePath);
                String scriptText = builder.readExternalFile(attribute, sourcePath);
                if (scriptText != null) {
                    IncludeHandler includeHandler = new IncludeHandler(builder.getFileSpecificationGetter());
                    includeHandler.setProjectAndCompilationUnit(project, builder.getCompilationUnit());
                    includeHandler.enterFile(sourcePath);
                    MXMLFileScope fileScope = builder.getFileScope();
                    OffsetLookup offsetLookup = fileScope.getOffsetLookup();
                    assert (offsetLookup != null) : "Expected OffsetLookup on FileScope.";
                    int[] absoluteOffset = offsetLookup.getAbsoluteOffset(sourcePath, 0);
                    ScopedBlockNode fragment = ASParser.parseFragment2(scriptText, sourceFileSpec.getPath(), absoluteOffset[0], 0, 0, problems, workspace, builder.getFileNode(), classScope, project.getProjectConfigVariables(), EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, PostProcessStep.RECONNECT_DEFINITIONS), true, includeHandler);
                    builder.getFileNode().updateIncludeTreeLastModified(includeHandler.getLastModified());
                    int n = fragment.getChildCount();
                    this.asNodes = new IASNode[n];
                    for (int i = 0; i < n; ++i) {
                        IASNode child;
                        this.asNodes[i] = child = fragment.getChild(i);
                        ((NodeBase)child).setParent(this);
                    }
                }
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        info.hasDualContent = true;
    }

    private MXMLClassDefinitionNode getContainingClassNode() {
        MXMLClassDefinitionNode result = (MXMLClassDefinitionNode)this.getAncestorOfType(MXMLClassDefinitionNode.class);
        assert (result != null);
        return result;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (info.hasSourceAttribute && info.hasDualContent) {
            MXMLDualContentProblem problem = new MXMLDualContentProblem(tag, tag.getShortName());
            builder.addProblem(problem);
            return;
        }
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        String sourcePath = tag.getParent().getFileSpecification().getPath();
        MXMLClassDefinitionNode classNode = this.getContainingClassNode();
        ASScope classScope = (ASScope)classNode.getClassDefinition().getContainedScope();
        FlexProject project = builder.getProject();
        OffsetLookup offsetLookup = classScope.getFileScope().getOffsetLookup();
        this.setSourcePath(sourcePath);
        try {
            ArrayList<ScopedBlockNode> scriptNodes = new ArrayList<ScopedBlockNode>();
            for (MXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
                MXMLTextData mxmlTextData;
                String text;
                if (!(unit instanceof MXMLTextData) || mxmlDialect.isWhitespace(text = (mxmlTextData = (MXMLTextData)unit).getCompilableText())) continue;
                assert (offsetLookup != null) : "Expected OffsetLookup on FileScope.";
                int localOffset = mxmlTextData.getParentUnitData().getAbsoluteEnd();
                int[] absoluteOffsets = offsetLookup.getAbsoluteOffset(sourcePath, localOffset);
                int absoluteOffset = absoluteOffsets[0];
                IncludeHandler includeHandler = IncludeHandler.createForASTBuilding(builder.getFileSpecificationGetter(), sourcePath, localOffset, absoluteOffset);
                EnumSet<PostProcessStep> postProcess = EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, PostProcessStep.RECONNECT_DEFINITIONS);
                ScopedBlockNode node = ASParser.parseInlineScript(builder.getFileNode(), mxmlTextData, builder.getProblems(), classScope, project.getProjectConfigVariables(), includeHandler, postProcess);
                MXMLFileNode filenode = builder.getFileNode();
                filenode.updateIncludeTreeLastModified(includeHandler.getLastModified());
                assert (node != null) : "Expected node from ASParser.getScopesFromInlineScript().";
                scriptNodes.add(node);
            }
            for (ScopedBlockNode script : scriptNodes) {
                int n = script.getChildCount();
                this.asNodes = new IASNode[n];
                for (int i = 0; i < n; ++i) {
                    IASNode child;
                    this.asNodes[i] = child = script.getChild(i);
                    ((NodeBase)child).setParent(this);
                }
            }
        }
        catch (Exception e) {
            builder.addProblem(new UnexpectedExceptionProblem(e));
        }
    }
}

