/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.problems.MXMLEmptyAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLIncludeInAndExcludeFromProblem;
import com.adobe.flash.compiler.problems.MXMLRequiredAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLSemanticProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLReparentNode;

class MXMLReparentNode
extends MXMLNodeBase
implements IMXMLReparentNode {
    private String target;
    private String[] includeIn;
    private String[] excludeFrom;

    MXMLReparentNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLReparentID;
    }

    @Override
    public String getName() {
        return "Reparent";
    }

    @Override
    public String[] getIncludeIn() {
        return this.includeIn;
    }

    @Override
    public String[] getExcludeFrom() {
        return this.excludeFrom;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("target")) {
            this.target = this.processTargetAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("includeIn")) {
            this.includeIn = this.processIncludeInOrExcludeFromAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("excludeFrom")) {
            this.excludeFrom = this.processIncludeInOrExcludeFromAttribute(builder, attribute);
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    private String processTargetAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute) {
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        String value = attribute.getRawValue();
        value = mxmlDialect.trim(value);
        return value;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLSemanticProblem problem;
        if (this.target == null) {
            problem = new MXMLRequiredAttributeProblem(tag, "target");
            builder.addProblem(problem);
        } else if (this.target.isEmpty()) {
            problem = new MXMLEmptyAttributeProblem(tag.getTagAttributeData("target"));
            builder.addProblem(problem);
        }
        if (this.includeIn != null && this.excludeFrom != null) {
            problem = new MXMLIncludeInAndExcludeFromProblem(tag);
            builder.addProblem(problem);
            this.includeIn = null;
            this.excludeFrom = null;
        }
        super.initializationComplete(builder, tag, info);
    }
}

