/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLArrayNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLComponentNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLDeferredInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLSpecifierNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLUnitData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.MXMLUnresolvedTagProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLInstanceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

class MXMLPropertySpecifierNode
extends MXMLSpecifierNodeBase
implements IMXMLPropertySpecifierNode {
    private static final EnumSet<MXMLDialect.TextParsingFlags> FLAGS = EnumSet.of(MXMLDialect.TextParsingFlags.ALLOW_ARRAY, new MXMLDialect.TextParsingFlags[]{MXMLDialect.TextParsingFlags.ALLOW_BINDING, MXMLDialect.TextParsingFlags.ALLOW_COLOR_NAME, MXMLDialect.TextParsingFlags.ALLOW_COMPILER_DIRECTIVE, MXMLDialect.TextParsingFlags.ALLOW_ESCAPED_COMPILER_DIRECTIVE, MXMLDialect.TextParsingFlags.ALLOW_PERCENT});
    private String dynamicName;
    private MXMLInstanceNode instanceNode;

    MXMLPropertySpecifierNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLPropertySpecifierID;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.instanceNode : null;
    }

    @Override
    public int getChildCount() {
        return this.instanceNode != null ? 1 : 0;
    }

    @Override
    public IMXMLInstanceNode getInstanceNode() {
        return this.instanceNode;
    }

    void setInstanceNode(MXMLInstanceNode instanceNode) {
        this.instanceNode = instanceNode;
    }

    private ITypeDefinition getPropertyType(MXMLTreeBuilder builder) {
        IDefinition definition = this.getDefinition();
        FlexProject project = builder.getProject();
        if (definition == null) {
            return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
        }
        return definition.resolveType(project);
    }

    protected String getPropertyTypeName(MXMLTreeBuilder builder) {
        ITypeDefinition propertyType = this.getPropertyType(builder);
        if (propertyType == null) {
            return "*";
        }
        return propertyType.getQualifiedName();
    }

    void setDynamicName(String dynamicName) {
        this.dynamicName = dynamicName;
    }

    @Override
    public String getName() {
        return this.dynamicName != null ? this.dynamicName : super.getName();
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void initializeFromAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializeFromAttribute(builder, attribute, info);
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] fragments = attribute.getValueFragments(problems);
        info.addSourceFragments(attribute.getSourcePath(), fragments);
        this.processFragments(builder, attribute, info);
        info.clearFragments();
    }

    private void processFragments(MXMLTreeBuilder builder, SourceLocation sourceLocation, MXMLNodeBase.MXMLNodeInfo info) {
        IVariableDefinition percentProxyDefinition;
        ITypeDefinition propertyType = this.getPropertyType(builder);
        ISourceFragment[] fragments = info.getSourceFragments();
        SourceLocation location = info.getSourceLocation();
        if (location == null) {
            location = sourceLocation;
        }
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        EnumSet<MXMLDialect.TextParsingFlags> flags = FLAGS;
        IDefinition definition = this.getDefinition();
        FlexProject project = builder.getProject();
        if (definition instanceof IVariableDefinition) {
            if (((IVariableDefinition)definition).hasCollapseWhiteSpace(project)) {
                flags.add(MXMLDialect.TextParsingFlags.COLLAPSE_WHITE_SPACE);
            }
            if (((IVariableDefinition)definition).hasRichTextContent(project)) {
                flags.add(MXMLDialect.TextParsingFlags.RICH_TEXT_CONTENT);
            }
        }
        this.instanceNode = builder.createInstanceNode(this, propertyType, fragments, location, flags, classNode);
        if (this.instanceNode == null) {
            this.markInvalidForCodeGen();
        }
        if ((percentProxyDefinition = builder.getPercentProxyDefinition()) != null) {
            this.setDefinition(percentProxyDefinition);
        }
    }

    @Override
    protected void initializeFromText(MXMLTreeBuilder builder, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializeFromText(builder, text, info);
        this.accumulateTextFragments(builder, text, info);
        this.processFragments(builder, text, info);
    }

    void initializeDefaultProperty(MXMLTreeBuilder builder, IVariableDefinition defaultPropertyDefinition, List<MXMLUnitData> contentUnits) {
        FlexProject project = builder.getProject();
        assert (contentUnits.isEmpty() || !builder.getFileScope().isScriptTag(contentUnits.get(0))) : "Script tags should not start a default property!";
        assert (contentUnits.isEmpty() || !builder.getFileScope().isScriptTag(contentUnits.get(contentUnits.size() - 1))) : "Trailing script tags should be removed from default property content units!";
        this.setLocation(builder, contentUnits);
        String propertyTypeName = this.getPropertyTypeName(builder);
        if (propertyTypeName.equals(project.getDeferredInstanceInterface()) || propertyTypeName.equals(project.getTransientDeferredInstanceInterface())) {
            this.instanceNode = new MXMLDeferredInstanceNode(this);
            ((MXMLDeferredInstanceNode)this.instanceNode).initializeDefaultProperty(builder, defaultPropertyDefinition, contentUnits);
        } else if (propertyTypeName.equals("Array")) {
            this.instanceNode = new MXMLArrayNode(this);
            ((MXMLArrayNode)this.instanceNode).initializeDefaultProperty(builder, defaultPropertyDefinition, contentUnits);
        } else if (contentUnits.size() == 1 && contentUnits.get(0) instanceof MXMLTagData) {
            MXMLTagData tag = (MXMLTagData)contentUnits.get(0);
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(tag);
            if (definition instanceof ClassDefinition) {
                this.instanceNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
                this.instanceNode.setClassReference(project, (ClassDefinition)definition);
                this.instanceNode.initializeFromTag(builder, tag);
            }
        }
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLFileScope fileScope = builder.getFileScope();
        if (fileScope.isComponentTag(childTag)) {
            this.instanceNode = new MXMLComponentNode(this);
            this.instanceNode.initializeFromTag(builder, childTag);
        } else {
            FlexProject project;
            String propertyTypeName = this.getPropertyTypeName(builder);
            if (propertyTypeName.equals((project = builder.getProject()).getDeferredInstanceInterface()) || propertyTypeName.equals(project.getTransientDeferredInstanceInterface())) {
                this.instanceNode = new MXMLDeferredInstanceNode(this);
                this.instanceNode.initializeFromTag(builder, tag);
            } else {
                IDefinition definition = builder.getFileScope().resolveTagToDefinition(childTag);
                if (definition instanceof ClassDefinition) {
                    this.instanceNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
                    this.instanceNode.setClassReference(project, (ClassDefinition)definition);
                    this.instanceNode.initializeFromTag(builder, childTag);
                } else {
                    MXMLUnresolvedTagProblem problem = new MXMLUnresolvedTagProblem(childTag);
                    builder.addProblem(problem);
                }
            }
        }
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        this.accumulateTextFragments(builder, text, info);
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        FlexProject project = builder.getProject();
        IDefinition definition = this.getDefinition();
        if (definition != null && definition.getTypeAsDisplayString().equals("Array") && (this.instanceNode == null || !this.instanceNode.getClassReference(project).getQualifiedName().equals("Array"))) {
            this.instanceNode = new MXMLArrayNode(this);
            this.instanceNode.setClassReference(project, "Array");
            ((MXMLArrayNode)this.instanceNode).initializeFromTag(builder, tag);
        }
        if (this.instanceNode == null) {
            this.processFragments(builder, tag, info);
        }
    }

    @Override
    public IVariableDefinition getPercentProxyDefinition(FlexProject project) {
        IClassDefinition classDefinition;
        IVariableDefinition propertyDefinition = (IVariableDefinition)this.getDefinition();
        String percentProxy = propertyDefinition.getPercentProxy(project);
        if (percentProxy == null) {
            return null;
        }
        ASScope classScope = (ASScope)propertyDefinition.getContainingScope();
        IDefinition proxyDefinition = classScope.getPropertyFromDef(project, classDefinition = (IClassDefinition)((Object)classScope.getDefinition()), percentProxy, false);
        if (!(proxyDefinition instanceof IVariableDefinition)) {
            return null;
        }
        return (IVariableDefinition)proxyDefinition;
    }
}

