/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLLiteralNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLNumberNode;

class MXMLNumberNode
extends MXMLExpressionNodeBase
implements IMXMLNumberNode {
    private static final Number DEFAULT = Double.NaN;

    MXMLNumberNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLNumberID;
    }

    @Override
    public String getName() {
        return "Number";
    }

    @Override
    public double getValue() {
        assert (this.getExpressionNode() instanceof MXMLLiteralNode) : "getValue() shouldn't be getting called on a non-literal MXMLNumberNode";
        MXMLLiteralNode literalNode = (MXMLLiteralNode)this.getExpressionNode();
        Object value = literalNode.getValue();
        if (value instanceof Integer) {
            return ((Integer)literalNode.getValue()).intValue();
        }
        if (value instanceof Long) {
            return ((Long)literalNode.getValue()).longValue();
        }
        return ((Number)literalNode.getValue()).doubleValue();
    }

    @Override
    public MXMLExpressionNodeBase.ExpressionType getExpressionType() {
        return MXMLExpressionNodeBase.ExpressionType.NUMBER;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        NodeBase expressionNode = this.createExpressionNodeFromFragments(builder, tag, info, DEFAULT);
        this.setExpressionNode(expressionNode);
        super.initializationComplete(builder, tag, info);
    }
}

