/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.parsing.SourceFragment;
import com.adobe.flash.compiler.internal.parsing.as.ASParser;
import com.adobe.flash.compiler.internal.parsing.as.IncludeHandler;
import com.adobe.flash.compiler.internal.parsing.as.OffsetLookup;
import com.adobe.flash.compiler.internal.parsing.as.StreamingASTokenizer;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLTokenizer;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.as.ScopedBlockNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLFileNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.mxml.IMXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLData;
import com.adobe.flash.compiler.mxml.MXMLNamespaceAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLUnitData;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.parsing.IMXMLToken;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.MXMLAttributeVersionProblem;
import com.adobe.flash.compiler.problems.MXMLEmptyAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLOtherLanguageNamespaceProblem;
import com.adobe.flash.compiler.problems.MXMLPrivateAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLUnexpectedAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLUnexpectedTagProblem;
import com.adobe.flash.compiler.problems.MXMLUnexpectedTextProblem;
import com.adobe.flash.compiler.problems.MXMLUnknownNamespaceProblem;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassDefinitionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDocumentNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLFileNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLSpecifierNode;
import com.adobe.flash.utils.FilenameNormalization;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public abstract class MXMLNodeBase
extends NodeBase
implements IMXMLNode {
    private static final ThreadLocal<StreamingASTokenizer> asTokenizer = new ThreadLocal<StreamingASTokenizer>(){

        @Override
        protected StreamingASTokenizer initialValue() {
            return new StreamingASTokenizer();
        }
    };
    private static final ThreadLocal<MXMLTokenizer> mxmlTokenizer = new ThreadLocal<MXMLTokenizer>(){

        @Override
        protected MXMLTokenizer initialValue() {
            return new MXMLTokenizer();
        }
    };
    private boolean validForCodeGen = true;

    public static String resolveSourceAttributePath(MXMLTreeBuilder builder, MXMLTagAttributeData attribute, MXMLNodeInfo info) {
        String resolvedPath;
        String sourcePath;
        if (info != null) {
            info.hasSourceAttribute = true;
        }
        if ((sourcePath = attribute.getMXMLDialect().trim(attribute.getRawValue())).isEmpty() && builder != null) {
            MXMLEmptyAttributeProblem problem = new MXMLEmptyAttributeProblem(attribute);
            builder.addProblem(problem);
            return null;
        }
        if (new File(sourcePath).isAbsolute()) {
            resolvedPath = sourcePath;
        } else {
            String mxmlPath = attribute.getParent().getParent().getPath();
            resolvedPath = FilenameUtils.getPrefix((String)mxmlPath) + FilenameUtils.getPath((String)mxmlPath);
            resolvedPath = FilenameUtils.concat((String)resolvedPath, (String)sourcePath);
        }
        String normalizedPath = FilenameNormalization.normalize(resolvedPath);
        if (builder != null) {
            builder.getFileScope().addSourceDependency(normalizedPath);
        }
        return normalizedPath;
    }

    protected static boolean isValidASIdentifier(String identifier) {
        IASToken[] tokens = asTokenizer.get().getTokens(identifier);
        return tokens != null && tokens.length == 1 && tokens[0].getType() == 15;
    }

    protected static boolean isValidXMLTagName(String tagName) {
        String s = "<" + tagName;
        IMXMLToken[] tokens = mxmlTokenizer.get().getTokens(s);
        return tokens != null && tokens.length == 1 && tokens[0].getType() == 138 && tokens[0].getText().equals(s);
    }

    MXMLNodeBase(NodeBase parent) {
        this.parent = parent;
    }

    @Override
    public boolean isValidForCodeGen() {
        return this.validForCodeGen;
    }

    void markInvalidForCodeGen() {
        this.validForCodeGen = false;
    }

    protected void initializeFromTag(MXMLTreeBuilder builder, MXMLTagData tag) {
        this.setLocation(tag);
        MXMLNodeInfo info = this.createNodeInfo(builder);
        for (MXMLTagAttributeData attribute : tag.getAttributeDatas()) {
            this.processAttribute(builder, tag, attribute, info);
        }
        for (MXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            this.processContentUnit(builder, tag, unit, info);
        }
        this.initializationComplete(builder, tag, info);
    }

    protected MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return null;
    }

    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeInfo info) {
        this.adjustOffsets(builder);
    }

    public void adjustOffsets(MXMLTreeBuilder builder) {
        MXMLFileScope fileScope = builder.getFileScope();
        assert (fileScope != null) : "Expected MXMLFileScope.";
        OffsetLookup offsetLookup = fileScope.getOffsetLookup();
        assert (offsetLookup != null) : "Expected OffsetLookup on file scope.";
        String path = this.getFileSpecification().getPath();
        int absoluteStart = offsetLookup.getAbsoluteOffset(path, this.getAbsoluteStart())[0];
        int absoluteEnd = offsetLookup.getAbsoluteOffset(path, this.getAbsoluteEnd())[0];
        this.setStart(absoluteStart);
        this.setEnd(absoluteEnd);
    }

    @Override
    public IASNode getChild(int i) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public IMXMLClassDefinitionNode getClassDefinitionNode() {
        return (IMXMLClassDefinitionNode)this.getAncestorOfType(IMXMLClassDefinitionNode.class);
    }

    @Override
    public IMXMLDocumentNode getDocumentNode() {
        return (IMXMLDocumentNode)this.getAncestorOfType(IMXMLDocumentNode.class);
    }

    @Override
    public IMXMLFileNode getFileNode() {
        return (IMXMLFileNode)this.getAncestorOfType(IMXMLFileNode.class);
    }

    private void processAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeInfo info) {
        if (attribute instanceof MXMLNamespaceAttributeData) {
            this.processNamespaceAttribute(builder, tag, (MXMLNamespaceAttributeData)attribute);
        } else if (MXMLNodeBase.isPrivateAttribute(attribute)) {
            this.processPrivateAttribute(builder, tag, attribute);
        } else {
            this.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    private void processNamespaceAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNamespaceAttributeData attribute) {
        String attributeURI = attribute.getNamespace();
        MXMLData mxmlData = attribute.getParent().getParent();
        String languageURI = mxmlData.getMXMLDialect().getLanguageNamespace();
        if (MXMLDialect.isLanguageNamespace(attributeURI) && !attributeURI.equals(languageURI)) {
            MXMLOtherLanguageNamespaceProblem problem = new MXMLOtherLanguageNamespaceProblem(attribute);
            builder.addProblem(problem);
        }
    }

    private static boolean isPrivateAttribute(MXMLTagAttributeData attribute) {
        String attributeURI = attribute.getURI();
        if (attributeURI == null) {
            return false;
        }
        String tagURI = attribute.getParent().getURI();
        MXMLData mxmlData = attribute.getParent().getParent();
        MXMLDialect mxmlDialect = mxmlData.getMXMLDialect();
        String languageURI = mxmlDialect.getLanguageNamespace();
        boolean isPrivate = false;
        if (mxmlDialect.isEqualToOrAfter(MXMLDialect.MXML_2009)) {
            isPrivate = !attributeURI.equals(languageURI) && !attributeURI.equals(tagURI);
        }
        return isPrivate;
    }

    private void processPrivateAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute) {
        MXMLPrivateAttributeProblem problem = new MXMLPrivateAttributeProblem(attribute);
        builder.addProblem(problem);
    }

    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeInfo info) {
        MXMLUnexpectedAttributeProblem problem = new MXMLUnexpectedAttributeProblem(attribute);
        builder.addProblem(problem);
    }

    private void processContentUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLUnitData unit, MXMLNodeInfo info) {
        if (unit instanceof MXMLTagData) {
            this.processChildTag(builder, tag, (MXMLTagData)unit, info);
        } else if (unit instanceof MXMLTextData) {
            this.processChildTextUnit(builder, tag, (MXMLTextData)unit, info);
        }
    }

    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeInfo info) {
        if (childTag.getURI() == null) {
            builder.addProblem(new MXMLUnknownNamespaceProblem(childTag, childTag.getPrefix()));
        } else {
            builder.addProblem(new MXMLUnexpectedTagProblem(childTag));
        }
    }

    private void processChildTextUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeInfo info) {
        switch (text.getTextType()) {
            case TEXT: 
            case WHITESPACE: 
            case CDATA: 
            case ENTITY: {
                if (tag.getMXMLDialect().isWhitespace(text.getCompilableText())) {
                    this.processChildWhitespaceUnit(builder, tag, text, info);
                    break;
                }
                this.processChildNonWhitespaceUnit(builder, tag, text, info);
                break;
            }
            case COMMENT: 
            case ASDOC: {
                break;
            }
            case DATABINDING: 
            case OTHER: {
                assert (false);
                break;
            }
        }
    }

    protected void processChildWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeInfo info) {
    }

    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeInfo info) {
        MXMLUnexpectedTextProblem problem = new MXMLUnexpectedTextProblem(text);
        builder.addProblem(problem);
    }

    public static List<ScopedBlockNode> processUnitAsAS(MXMLTreeBuilder builder, MXMLTagData tag, String sourcePath, ASScope containingScope, PostProcessStep buildOrReconnect, IMXMLFileNode ancestorFileNode) {
        assert (buildOrReconnect == PostProcessStep.POPULATE_SCOPE || buildOrReconnect == PostProcessStep.RECONNECT_DEFINITIONS);
        ArrayList<ScopedBlockNode> nodes = new ArrayList<ScopedBlockNode>(2);
        for (MXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            MXMLTextData mxmlTextData;
            if (!(unit instanceof MXMLTextData) || (mxmlTextData = (MXMLTextData)unit).getTextType() == IMXMLTextData.TextType.WHITESPACE) continue;
            Workspace workspace = builder.getWorkspace();
            FlexProject project = builder.getProject();
            Collection<ICompilerProblem> problems = builder.getProblems();
            IncludeHandler includeHandler = new IncludeHandler(builder.getFileSpecificationGetter());
            includeHandler.setProjectAndCompilationUnit(project, builder.getCompilationUnit());
            ScopedBlockNode node = ASParser.parseFragment2(mxmlTextData.getCompilableText(), sourcePath, mxmlTextData.getCompilableTextStart(), mxmlTextData.getCompilableTextLine() - 1, mxmlTextData.getCompilableTextColumn() - 1, problems, workspace, builder.getFileNode(), containingScope, project.getProjectConfigVariables(), EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, buildOrReconnect), true, includeHandler);
            ((MXMLFileNode)ancestorFileNode).updateIncludeTreeLastModified(includeHandler.getLastModified());
            nodes.add(node);
        }
        return nodes;
    }

    public void setLocation(String sourcePath, int start, int end, int line, int column) {
        this.setSourcePath(sourcePath);
        this.setStart(start);
        this.setEnd(end);
        this.setLine(line);
        this.setColumn(column);
    }

    public void setLocation(ISourceLocation location) {
        String sourcePath = location.getSourcePath();
        int start = location.getStart();
        int end = location.getEnd();
        int line = location.getLine();
        int column = location.getColumn();
        this.setLocation(sourcePath, start, end, line, column);
    }

    protected void setLocation(MXMLUnitData unit) {
        MXMLTagData startTag;
        MXMLTagData endTag;
        String sourcePath = unit.getSourcePath();
        int start = unit.getAbsoluteStart();
        int end = unit instanceof MXMLTagData ? ((endTag = (startTag = (MXMLTagData)unit).findMatchingEndTag()) != null ? endTag.getAbsoluteEnd() : startTag.getAbsoluteEnd()) : unit.getAbsoluteEnd();
        int line = unit.getLine();
        int column = unit.getColumn();
        this.setLocation(sourcePath, start, end, line, column);
    }

    protected void setLocation(MXMLTagAttributeData attribute) {
        String sourcePath = attribute.getSourcePath();
        int start = attribute.getAbsoluteStart();
        int end = attribute.getAbsoluteEnd();
        int line = attribute.getLine();
        int column = attribute.getColumn();
        this.setLocation(sourcePath, start, end, line, column);
    }

    protected void setLocation(MXMLTreeBuilder builder, List<MXMLUnitData> units) {
        MXMLTagData endTag;
        int n = units.size();
        MXMLUnitData firstUnit = units.get(0);
        MXMLUnitData lastUnit = units.get(n - 1);
        if (lastUnit instanceof MXMLTagData && lastUnit.isOpenAndNotEmptyTag() && (endTag = ((MXMLTagData)lastUnit).findMatchingEndTag()) != null) {
            lastUnit = endTag;
        }
        String sourcePath = firstUnit.getSourcePath();
        int start = firstUnit.getStart();
        int end = lastUnit.getEnd();
        int line = firstUnit.getLine();
        int column = firstUnit.getColumn();
        this.setLocation(sourcePath, start, end, line, column);
        this.adjustOffsets(builder);
    }

    protected void accumulateTextFragments(MXMLTreeBuilder builder, MXMLTextData text, MXMLNodeInfo info) {
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] fragments = text.getFragments(problems);
        info.addSourceFragments(text.getSourcePath(), fragments);
    }

    protected String[] processIncludeInOrExcludeFromAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute) {
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        if (mxmlDialect == MXMLDialect.MXML_2006) {
            MXMLAttributeVersionProblem problem = new MXMLAttributeVersionProblem(attribute, attribute.getName(), "2009");
            builder.addProblem(problem);
            return null;
        }
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        classNode.addStateDependentNode(builder, (IMXMLNode)this);
        return mxmlDialect.splitAndTrim(attribute.getRawValue());
    }

    protected static class MXMLNodeInfo {
        private MXMLTreeBuilder builder;
        private List<IMXMLNode> childNodeList = new ArrayList<IMXMLNode>();
        private String sourcePath;
        private List<ISourceFragment> sourceFragmentList = new ArrayList<ISourceFragment>();
        public boolean hasSourceAttribute = false;
        public boolean hasDualContent = false;
        protected Set<String> specifierSet = new HashSet<String>(0);

        public MXMLNodeInfo(MXMLTreeBuilder builder) {
            this.builder = builder;
        }

        public void addChildNode(IMXMLNode childNode) {
            this.childNodeList.add(childNode);
            if (childNode instanceof IMXMLSpecifierNode) {
                IMXMLSpecifierNode specifierNode = (IMXMLSpecifierNode)childNode;
                String suffix = specifierNode.getSuffix() != null ? specifierNode.getSuffix() : "";
                this.specifierSet.add(specifierNode.getName() + '.' + suffix);
            }
        }

        public List<IMXMLNode> getChildNodeList() {
            return this.childNodeList;
        }

        public void addSourceFragments(String sourcePath, ISourceFragment[] sourceFragments) {
            this.sourcePath = sourcePath;
            for (ISourceFragment sourceFragment : sourceFragments) {
                this.sourceFragmentList.add(sourceFragment);
            }
        }

        public void clearFragments() {
            this.sourceFragmentList.clear();
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public ISourceFragment[] getSourceFragments() {
            MXMLFileScope fileScope = this.builder.getFileScope();
            OffsetLookup offsetLookup = fileScope.getOffsetLookup();
            assert (offsetLookup != null) : "Expected OffsetLookup on FileScope.";
            for (ISourceFragment fragment : this.sourceFragmentList) {
                int physicalStart = fragment.getPhysicalStart();
                int[] absoluteOffsets = offsetLookup.getAbsoluteOffset(this.sourcePath, physicalStart);
                ((SourceFragment)fragment).setPhysicalStart(absoluteOffsets[0]);
            }
            return this.sourceFragmentList.toArray(new ISourceFragment[0]);
        }

        public SourceLocation getSourceLocation() {
            int n = this.sourceFragmentList.size();
            if (n == 0) {
                return null;
            }
            ISourceFragment firstFragment = this.sourceFragmentList.get(0);
            ISourceFragment lastFragment = this.sourceFragmentList.get(n - 1);
            int start = firstFragment.getPhysicalStart();
            int end = lastFragment.getPhysicalStart() + lastFragment.getPhysicalText().length();
            int line = firstFragment.getPhysicalLine();
            int column = firstFragment.getPhysicalColumn();
            return new SourceLocation(this.sourcePath, start, end, line, column);
        }

        public boolean hasSpecifierWithName(String name, String stateName) {
            return this.specifierSet.contains(name + '.' + stateName);
        }
    }
}

