/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLModelPropertyContainerNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLInstanceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLModelPropertyNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLNode;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

class MXMLModelPropertyNode
extends MXMLModelPropertyContainerNodeBase
implements IMXMLModelPropertyNode {
    private static final EnumSet<MXMLDialect.TextParsingFlags> FLAGS = EnumSet.of(MXMLDialect.TextParsingFlags.ALLOW_ARRAY, MXMLDialect.TextParsingFlags.ALLOW_BINDING, MXMLDialect.TextParsingFlags.ALLOW_COMPILER_DIRECTIVE, MXMLDialect.TextParsingFlags.ALLOW_ESCAPED_COMPILER_DIRECTIVE);
    private MXMLInstanceNode instanceNode = null;

    MXMLModelPropertyNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLModelPropertyID;
    }

    @Override
    public int getChildCount() {
        return this.instanceNode != null ? 1 : super.getChildCount();
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 && this.instanceNode != null ? this.instanceNode : super.getChild(i);
    }

    @Override
    public boolean hasLeafValue() {
        return this.instanceNode != null;
    }

    @Override
    public IMXMLInstanceNode getInstanceNode() {
        return this.instanceNode;
    }

    @Override
    protected void initializeFromAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute) {
        super.initializeFromAttribute(builder, attribute);
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] fragments = attribute.getValueFragments(problems);
        SourceLocation location = attribute.getValueLocation();
        this.instanceNode = this.createInstanceNode(builder, fragments, location);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLModelPropertyNode propertyNode = new MXMLModelPropertyNode(this);
        propertyNode.initializeFromAttribute(builder, attribute);
        info.addChildNode(propertyNode);
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] fragments = text.getFragments(problems);
        MXMLInstanceNode instanceNode = this.createInstanceNode(builder, fragments, text);
        info.addChildNode(instanceNode);
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        List<IMXMLNode> childNodeList = info.getChildNodeList();
        if (childNodeList.size() == 1 && childNodeList.get(0) instanceof IMXMLInstanceNode) {
            this.instanceNode = (MXMLInstanceNode)childNodeList.get(0);
        } else {
            this.setPropertyNodes(childNodeList.toArray(new IMXMLModelPropertyNode[0]));
        }
        super.initializationComplete(builder, tag, info);
    }

    private MXMLInstanceNode createInstanceNode(MXMLTreeBuilder builder, ISourceFragment[] fragments, SourceLocation location) {
        IClassDefinition anyType = ClassDefinition.getAnyTypeClassDefinition();
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        return builder.createInstanceNode(this, anyType, fragments, location, FLAGS, classNode);
    }
}

