/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLModelPropertyNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLModelPropertyContainerNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLModelPropertyNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;

abstract class MXMLModelPropertyContainerNodeBase
extends MXMLNodeBase
implements IMXMLModelPropertyContainerNode {
    private static final IMXMLModelPropertyNode[] NO_PROPERTY_NODES = new IMXMLModelPropertyNode[0];
    private String name;
    private IMXMLModelPropertyNode[] propertyNodes = NO_PROPERTY_NODES;
    private List<String> propertyNameList;
    private ListMultimap<String, IMXMLModelPropertyNode> propertyMultimap;
    private int index = -1;

    MXMLModelPropertyContainerNodeBase(NodeBase parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getChildCount() {
        return this.propertyNodes.length;
    }

    @Override
    public IASNode getChild(int i) {
        return this.propertyNodes[i];
    }

    @Override
    public IMXMLModelPropertyNode[] getPropertyNodes() {
        return this.propertyNodes;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNameList != null ? this.propertyNameList.toArray(new String[0]) : new String[]{};
    }

    @Override
    public IMXMLModelPropertyNode[] getPropertyNodes(String propertyName) {
        return this.propertyMultimap != null ? this.propertyMultimap.get((Object)propertyName).toArray(new IMXMLModelPropertyNode[0]) : new IMXMLModelPropertyNode[]{};
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    protected void initializeFromAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute) {
        this.name = attribute.getShortName();
        this.setLocation(attribute);
    }

    @Override
    protected void initializeFromTag(MXMLTreeBuilder builder, MXMLTagData tag) {
        this.name = tag.getShortName();
        super.initializeFromTag(builder, tag);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.getPrefix() != null) {
            // empty if block
        }
        MXMLModelPropertyNode propertyNode = new MXMLModelPropertyNode(this);
        propertyNode.initializeFromAttribute(builder, attribute);
        info.addChildNode(propertyNode);
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        if (childTag.getPrefix() != null) {
            // empty if block
        }
        MXMLModelPropertyNode propertyNode = new MXMLModelPropertyNode(this);
        propertyNode.initializeFromTag(builder, childTag);
        info.addChildNode(propertyNode);
    }

    void setPropertyNodes(IMXMLModelPropertyNode[] propertyNodes) {
        this.propertyNodes = propertyNodes;
        for (IMXMLModelPropertyNode propertyNode : propertyNodes) {
            int n;
            String propertyName = propertyNode.getName();
            if (this.propertyMultimap == null) {
                this.propertyMultimap = ArrayListMultimap.create();
            }
            if (this.propertyNameList == null) {
                this.propertyNameList = new ArrayList<String>();
            }
            if ((n = this.propertyMultimap.get((Object)propertyName).size()) == 0) {
                this.propertyNameList.add(propertyName);
            }
            this.propertyMultimap.put((Object)propertyName, (Object)propertyNode);
        }
        if (this.propertyNameList != null) {
            for (String propertyName : this.propertyNameList) {
                List list = this.propertyMultimap.get((Object)propertyName);
                if (list.size() <= 1) continue;
                int i = 0;
                for (IMXMLModelPropertyNode node : list) {
                    ((MXMLModelPropertyNode)node).setIndex(i++);
                }
            }
        }
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        int index = this.getIndex();
        if (index != -1) {
            sb.append(' ');
            sb.append('[');
            sb.append(index);
            sb.append(']');
        }
        return true;
    }
}

