/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLModelRootNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLData;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.problems.MXMLDualContentProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLModelNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLModelRootNode;

class MXMLModelNode
extends MXMLInstanceNode
implements IMXMLModelNode {
    private MXMLModelRootNode rootNode;

    MXMLModelNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLModelID;
    }

    @Override
    public String getName() {
        return "Model";
    }

    @Override
    public int getChildCount() {
        return this.rootNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.rootNode : null;
    }

    @Override
    public IMXMLModelRootNode getRootNode() {
        return this.rootNode;
    }

    @Override
    protected void initializeFromTag(MXMLTreeBuilder builder, MXMLTagData tag) {
        FlexProject project = builder.getProject();
        String qname = project.getModelClass();
        this.setClassReference(project, qname);
        super.initializeFromTag(builder, tag);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            MXMLData mxmlData;
            String sourcePath = MXMLModelNode.resolveSourceAttributePath(builder, attribute, info);
            if (sourcePath != null && (mxmlData = builder.getExternalMXMLData(attribute, sourcePath)) != null) {
                MXMLTagData rootTag = mxmlData.getRootTag();
                this.rootNode = new MXMLModelRootNode(this);
                this.rootNode.initializeFromTag(builder, rootTag);
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        info.hasDualContent = true;
        if (this.rootNode == null) {
            this.rootNode = new MXMLModelRootNode(this);
            this.rootNode.initializeFromTag(builder, childTag);
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (info.hasSourceAttribute && info.hasDualContent) {
            MXMLDualContentProblem problem = new MXMLDualContentProblem(tag, tag.getShortName());
            builder.addProblem(problem);
        }
    }
}

