/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLArrayNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLBooleanNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassReferenceNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLDesignLayerNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLFunctionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLHTTPServiceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLIntNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNumberNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLObjectNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLRegExpNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLRemoteObjectNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLStateNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLStringNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLUintNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLVectorNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLWebServiceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLXMLListNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLXMLNode;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.problems.MXMLAttributeVersionProblem;
import com.adobe.flash.compiler.problems.MXMLDuplicateIDProblem;
import com.adobe.flash.compiler.problems.MXMLIncludeInAndExcludeFromProblem;
import com.adobe.flash.compiler.problems.MXMLInvalidIDProblem;
import com.adobe.flash.compiler.problems.MXMLInvalidItemCreationPolicyProblem;
import com.adobe.flash.compiler.problems.MXMLInvalidItemDestructionPolicyProblem;
import com.adobe.flash.compiler.scopes.IDefinitionSet;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassReferenceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLInstanceNode;

class MXMLInstanceNode
extends MXMLClassReferenceNodeBase
implements IMXMLInstanceNode {
    private String id;
    private String[] includeIn;
    private String[] excludeFrom;
    private String itemCreationPolicy;
    private String itemDestructionPolicy;

    protected static MXMLInstanceNode createInstanceNode(MXMLTreeBuilder builder, String instanceType, NodeBase parent) {
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        if (instanceType.equals("Boolean")) {
            return new MXMLBooleanNode(parent);
        }
        if (instanceType.equals("int")) {
            return new MXMLIntNode(parent);
        }
        if (instanceType.equals("uint")) {
            return new MXMLUintNode(parent);
        }
        if (instanceType.equals("Number")) {
            return new MXMLNumberNode(parent);
        }
        if (instanceType.equals("String")) {
            return new MXMLStringNode(parent);
        }
        if (instanceType.equals("Class")) {
            return new MXMLClassNode(parent);
        }
        if (instanceType.equals("Object")) {
            return new MXMLObjectNode(parent);
        }
        if (instanceType.equals("Array")) {
            return new MXMLArrayNode(parent);
        }
        if (instanceType.equals(IASLanguageConstants.Vector_qname)) {
            return new MXMLVectorNode(parent);
        }
        if (instanceType.equals("mx.states.State") && mxmlDialect != MXMLDialect.MXML_2006) {
            return new MXMLStateNode(parent);
        }
        if (instanceType.equals(builder.getProject().getWebServiceQName())) {
            return new MXMLWebServiceNode(parent);
        }
        if (instanceType.equals(builder.getProject().getRemoteObjectQName())) {
            return new MXMLRemoteObjectNode(parent);
        }
        if (instanceType.equals(builder.getProject().getHTTPServiceQName())) {
            return new MXMLHTTPServiceNode(parent);
        }
        if (instanceType.equals(builder.getProject().getDesignLayerQName())) {
            return new MXMLDesignLayerNode(parent);
        }
        if (instanceType.equals("XML")) {
            return new MXMLXMLNode(parent);
        }
        if (instanceType.equals("XMLList")) {
            return new MXMLXMLListNode(parent);
        }
        if (instanceType.equals("Function")) {
            return new MXMLFunctionNode(parent);
        }
        if (instanceType.equals("RegExp")) {
            return new MXMLRegExpNode(parent);
        }
        return new MXMLInstanceNode(parent);
    }

    MXMLInstanceNode(NodeBase parent) {
        super(parent);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("id")) {
            this.id = this.processIDAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("includeIn")) {
            this.includeIn = this.processIncludeInOrExcludeFromAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("excludeFrom")) {
            this.excludeFrom = this.processIncludeInOrExcludeFromAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("itemCreationPolicy")) {
            this.itemCreationPolicy = this.processItemCreationPolicyAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("itemDestructionPolicy")) {
            this.itemDestructionPolicy = this.processItemDestructionPolicyAttribute(builder, attribute);
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    private String processIDAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute) {
        String value = attribute.getRawValue();
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        value = mxmlDialect.trim(value);
        if (!MXMLInstanceNode.isValidASIdentifier(value)) {
            MXMLInvalidIDProblem problem = new MXMLInvalidIDProblem(attribute);
            builder.addProblem(problem);
            return null;
        }
        IMXMLInstanceNode previousNodeWithSameID = ((MXMLClassDefinitionNode)this.getClassDefinitionNode()).addNodeWithID(value, this);
        if (previousNodeWithSameID != null) {
            MXMLDuplicateIDProblem problem = new MXMLDuplicateIDProblem(attribute);
            builder.addProblem(problem);
            return null;
        }
        return value;
    }

    protected String processItemCreationPolicyAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute) {
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        if (mxmlDialect == MXMLDialect.MXML_2006) {
            MXMLAttributeVersionProblem problem = new MXMLAttributeVersionProblem(attribute, attribute.getName(), "2009");
            builder.addProblem(problem);
            return null;
        }
        String value = attribute.getRawValue();
        if (!(value = mxmlDialect.trim(value)).equals("immediate") && !value.equals("deferred")) {
            MXMLInvalidItemCreationPolicyProblem problem = new MXMLInvalidItemCreationPolicyProblem(attribute);
            builder.addProblem(problem);
            return null;
        }
        return value;
    }

    protected String processItemDestructionPolicyAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute) {
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        if (mxmlDialect == MXMLDialect.MXML_2006) {
            MXMLAttributeVersionProblem problem = new MXMLAttributeVersionProblem(attribute, attribute.getName(), "2009");
            builder.addProblem(problem);
            return null;
        }
        String value = attribute.getRawValue();
        if (!(value = mxmlDialect.trim(value)).equals("auto") && !value.equals("never")) {
            MXMLInvalidItemDestructionPolicyProblem problem = new MXMLInvalidItemDestructionPolicyProblem(attribute);
            builder.addProblem(problem);
            return null;
        }
        return value;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (this.id == null) {
            ((MXMLClassDefinitionNode)this.getClassDefinitionNode()).generateID(this);
        }
        if (this.includeIn != null && this.excludeFrom != null) {
            MXMLIncludeInAndExcludeFromProblem problem = new MXMLIncludeInAndExcludeFromProblem(tag);
            builder.addProblem(problem);
            this.includeIn = null;
            this.excludeFrom = null;
        }
        FlexProject project = builder.getProject();
        IClassDefinition classReference = this.getClassReference(project);
        String qname = classReference.getQualifiedName();
        builder.addDependency(qname, DependencyType.EXPRESSION);
        if (this.id != null) {
            builder.addDependency(qname, DependencyType.SIGNATURE);
        }
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLInstanceID;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getEffectiveID() {
        return this.id != null ? this.id : this.getClassDefinitionNode().getGeneratedID(this);
    }

    @Override
    public IVariableDefinition resolveID() {
        MXMLClassDefinitionNode classDefinitionNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        IClassDefinition classDefinition = classDefinitionNode.getClassDefinition();
        ASScope classScope = (ASScope)classDefinition.getContainedScope();
        IDefinitionSet definitionSet = classScope.getLocalDefinitionSetByName(this.id);
        int n = definitionSet.getSize();
        for (int i = 0; i < n; ++i) {
            IDefinition definition = definitionSet.getDefinition(i);
            if (!(definition instanceof IVariableDefinition)) continue;
            return (IVariableDefinition)definition;
        }
        return null;
    }

    @Override
    public String[] getIncludeIn() {
        return this.includeIn;
    }

    @Override
    public String[] getExcludeFrom() {
        return this.excludeFrom;
    }

    @Override
    public String getItemCreationPolicy() {
        return this.itemCreationPolicy;
    }

    @Override
    public String getItemDestructionPolicy() {
        return this.itemDestructionPolicy;
    }

    @Override
    public boolean needsDescriptor() {
        IASNode parent;
        if (this.isContainer()) {
            return true;
        }
        return this.isDeferredInstantiationUIComponent() && (parent = this.getParent()) instanceof IMXMLClassReferenceNode && ((IMXMLClassReferenceNode)parent).isContainer();
    }

    @Override
    public boolean needsDocumentDescriptor() {
        return this.isContainer() && this.getParent() instanceof IMXMLInstanceNode && !((IMXMLInstanceNode)this.getParent()).isContainer();
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        super.buildInnerString(sb);
        String id = this.getID();
        if (id != null) {
            sb.append(' ');
            sb.append("id=");
            sb.append('\"');
            sb.append(id);
            sb.append('\"');
        }
        return true;
    }
}

