/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.parsing.SourceFragment;
import com.adobe.flash.compiler.internal.parsing.SourceFragmentsReader;
import com.adobe.flash.compiler.internal.parsing.as.ASParser;
import com.adobe.flash.compiler.internal.parsing.as.StreamingASTokenizer;
import com.adobe.flash.compiler.internal.parsing.as.StreamingTokenBuffer;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.FileNode;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IClassNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLImplementsNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

class MXMLImplementsNode
extends MXMLNodeBase
implements IMXMLImplementsNode {
    private static final IIdentifierNode[] NO_INTERFACE_NODES = new IIdentifierNode[0];
    private static final String STRING_TO_PREPEND = "internal class C implements ";
    private static final String STRING_TO_APPEND = " {}";
    private IIdentifierNode[] interfaceNodes = NO_INTERFACE_NODES;

    MXMLImplementsNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLImplementsID;
    }

    @Override
    public String getName() {
        return "implements";
    }

    @Override
    public int getChildCount() {
        return this.interfaceNodes.length;
    }

    @Override
    public IASNode getChild(int i) {
        return this.interfaceNodes[i];
    }

    @Override
    public IIdentifierNode[] getInterfaceNodes() {
        return this.interfaceNodes;
    }

    protected void initializeFromAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute) {
        this.setLocation(attribute);
        this.adjustOffsets(builder);
        Workspace workspace = builder.getWorkspace();
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] valueFragments = attribute.getValueFragments(problems);
        int n = valueFragments.length;
        ISourceFragment[] fragments = new ISourceFragment[n + 2];
        fragments[0] = new SourceFragment(STRING_TO_PREPEND, STRING_TO_PREPEND, 0, 0, 0);
        for (int i = 0; i < n; ++i) {
            fragments[i + 1] = valueFragments[i];
        }
        fragments[n + 1] = new SourceFragment(STRING_TO_APPEND, STRING_TO_APPEND, 0, 0, 0);
        SourceFragmentsReader reader = new SourceFragmentsReader(attribute.getSourcePath(), fragments);
        StreamingASTokenizer tokenizer = new StreamingASTokenizer();
        tokenizer.setReader(reader);
        StreamingTokenBuffer buffer = new StreamingTokenBuffer(tokenizer);
        ASParser parser = new ASParser(workspace, buffer);
        FileNode fileNode = new FileNode(builder.getFileSpecificationGetter());
        parser.parseFile(fileNode, (EnumSet)EnumSet.of(PostProcessStep.CALCULATE_OFFSETS));
        problems.addAll(tokenizer.getTokenizationProblems());
        problems.addAll(parser.getSyntaxProblems());
        ArrayList<IIdentifierNode> interfaceNodeList = new ArrayList<IIdentifierNode>();
        if (fileNode.getChildCount() == 1 && fileNode.getChild(0) instanceof IClassNode) {
            IClassNode classNode = (IClassNode)fileNode.getChild(0);
            for (IExpressionNode interfaceNode : classNode.getImplementedInterfaceNodes()) {
                if (!(interfaceNode instanceof IIdentifierNode)) continue;
                interfaceNodeList.add((IIdentifierNode)interfaceNode);
                ((NodeBase)((Object)interfaceNode)).setParent(this);
            }
        }
        this.interfaceNodes = interfaceNodeList.toArray(new IIdentifierNode[0]);
    }
}

