/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IFunctionDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLFunctionNode;

class MXMLFunctionNode
extends MXMLExpressionNodeBase
implements IMXMLFunctionNode {
    private static final Object DEFAULT = null;

    MXMLFunctionNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLFunctionID;
    }

    @Override
    public String getName() {
        return "Function";
    }

    @Override
    public IFunctionDefinition getValue(ICompilerProject project) {
        IDefinition d;
        assert (this.getExpressionNode() instanceof IExpressionNode) : "getValue() shouldn't be getting called on a non-expression MXMLFunctionNode";
        IExpressionNode expressionNode = (IExpressionNode)this.getExpressionNode();
        if (expressionNode != null && (d = expressionNode.resolve(project)) instanceof IFunctionDefinition) {
            return (IFunctionDefinition)d;
        }
        return null;
    }

    @Override
    public MXMLExpressionNodeBase.ExpressionType getExpressionType() {
        return MXMLExpressionNodeBase.ExpressionType.FUNCTION;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        NodeBase expressionNode = this.parseExpressionNodeFromFragments(builder, tag, info, DEFAULT);
        this.setExpressionNode(expressionNode);
        ITypeDefinition functionType = builder.getBuiltinType("Function");
        this.checkExpressionType(builder, functionType);
        super.initializationComplete(builder, tag, info);
    }
}

