/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.semantics.SemanticUtils;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.problems.ImplicitCoercionToUnrelatedTypeProblem;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLExpressionNode;
import java.util.EnumSet;

abstract class MXMLExpressionNodeBase
extends MXMLInstanceNode
implements IMXMLExpressionNode {
    protected static final EnumSet<MXMLDialect.TextParsingFlags> FLAGS = EnumSet.of(MXMLDialect.TextParsingFlags.ALLOW_BINDING, MXMLDialect.TextParsingFlags.ALLOW_COMPILER_DIRECTIVE);
    private IASNode expressionNode;

    MXMLExpressionNodeBase(NodeBase parent) {
        super(parent);
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.expressionNode : null;
    }

    @Override
    public int getChildCount() {
        return this.expressionNode == null ? 0 : 1;
    }

    @Override
    public IASNode getExpressionNode() {
        return this.expressionNode;
    }

    void setExpressionNode(NodeBase value) {
        this.expressionNode = value;
        if (value != null) {
            value.setParent(this);
        }
    }

    public abstract ExpressionType getExpressionType();

    public void initialize(MXMLTreeBuilder builder, SourceLocation location, String type, NodeBase expressionNode) {
        this.setLocation(location);
        this.setClassReference(builder.getProject(), type);
        this.setExpressionNode(expressionNode);
    }

    @Override
    protected void processChildWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        this.accumulateTextFragments(builder, text, info);
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        info.hasDualContent = true;
        this.accumulateTextFragments(builder, text, info);
    }

    protected NodeBase createExpressionNodeFromFragments(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info, Object defaultValue) {
        ITypeDefinition type = builder.getBuiltinType(this.getName());
        ISourceFragment[] fragments = info.getSourceFragments();
        SourceLocation location = info.getSourceLocation();
        if (location == null) {
            location = tag.getLocationOfChildUnits();
        }
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        return builder.createExpressionNode(null, type, fragments, location, FLAGS, defaultValue, classNode);
    }

    protected NodeBase parseExpressionNodeFromFragments(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info, Object defaultValue) {
        ITypeDefinition type = builder.getBuiltinType(this.getName());
        ISourceFragment[] fragments = info.getSourceFragments();
        SourceLocation location = info.getSourceLocation();
        if (location == null) {
            location = tag.getLocationOfChildUnits();
        }
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        return builder.parseExpressionNode(type, fragments, location, FLAGS, defaultValue, classNode, true);
    }

    protected void checkExpressionType(MXMLTreeBuilder builder, IDefinition expectedType) {
        FlexProject project;
        ITypeDefinition exprType;
        IExpressionNode expressionNode = (IExpressionNode)this.getExpressionNode();
        if (expressionNode != null && (exprType = expressionNode.resolveType(project = builder.getProject())) != null && !SemanticUtils.isValidTypeConversion(expectedType, exprType, project, builder.getCompilationUnit().isInvisible())) {
            ImplicitCoercionToUnrelatedTypeProblem problem = new ImplicitCoercionToUnrelatedTypeProblem(expressionNode, exprType.getBaseName(), expectedType.getBaseName());
            builder.addProblem(problem);
        }
    }

    protected static enum ExpressionType {
        BOOLEAN,
        INT,
        UINT,
        NUMBER,
        STRING,
        CLASS,
        FUNCTION,
        REGEXP;

    }
}

