/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.definitions.IParameterDefinition;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.internal.definitions.DefinitionBase;
import com.adobe.flash.compiler.internal.definitions.ParameterDefinition;
import com.adobe.flash.compiler.internal.definitions.mxml.MXMLEventHandlerScope;
import com.adobe.flash.compiler.internal.parsing.as.ASParser;
import com.adobe.flash.compiler.internal.parsing.as.IncludeHandler;
import com.adobe.flash.compiler.internal.parsing.as.OffsetLookup;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.as.ScopedBlockNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLFileNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLSpecifierNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.MXMLEmptyEventHandlerProblem;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IImportNode;
import com.adobe.flash.compiler.tree.as.IScopedNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassReferenceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLEventSpecifierNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

class MXMLEventSpecifierNode
extends MXMLSpecifierNodeBase
implements IMXMLEventSpecifierNode,
IScopedNode {
    private NodeBase[] asNodes;
    private final MXMLEventHandlerScope scope = new MXMLEventHandlerScope(this);

    MXMLEventSpecifierNode(NodeBase parent) {
        super(parent);
    }

    @Override
    protected void initializeFromAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializeFromAttribute(builder, attribute, info);
        FlexProject project = builder.getProject();
        Workspace workspace = builder.getWorkspace();
        Collection<ICompilerProblem> problems = builder.getProblems();
        this.setSourcePath(attribute.getParent().getParent().getFileSpecification().getPath());
        int startOffsetLocal = attribute.getValueStart();
        MXMLFileScope fileScope = builder.getFileScope();
        OffsetLookup offsetLookup = fileScope.getOffsetLookup();
        assert (offsetLookup != null) : "Expected OffsetLookup on FileScope.";
        String filePath = this.getContainingFilePath();
        int[] absoluteOffsets = offsetLookup.getAbsoluteOffset(filePath, startOffsetLocal);
        int startOffsetAbsolute = absoluteOffsets[0];
        IncludeHandler includeHandler = IncludeHandler.createForASTBuilding(builder.getFileSpecificationGetter(), filePath, startOffsetLocal, startOffsetAbsolute);
        includeHandler.setProjectAndCompilationUnit(project, builder.getCompilationUnit());
        String scriptFragment = attribute.getRawValue();
        if (scriptFragment.isEmpty()) {
            MXMLEmptyEventHandlerProblem problem = new MXMLEmptyEventHandlerProblem(attribute);
            problems.add(problem);
        }
        ScopedBlockNode node = ASParser.parseFragment2(scriptFragment, filePath, 0, attribute.getValueLine(), attribute.getValueColumn(), problems, workspace, builder.getFileNode(), this.scope, project.getProjectConfigVariables(), EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, PostProcessStep.POPULATE_SCOPE), true, includeHandler);
        builder.getFileNode().updateIncludeTreeLastModified(includeHandler.getLastModified());
        this.processHandlerCode(builder, Collections.singletonList(node));
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        String path = builder.getPath();
        MXMLFileNode fileNode = builder.getFileNode();
        this.processHandlerCode(builder, MXMLEventSpecifierNode.processUnitAsAS(builder, tag, path, this.scope, PostProcessStep.POPULATE_SCOPE, fileNode));
    }

    private void processHandlerCode(MXMLTreeBuilder builder, List<ScopedBlockNode> scripts) {
        IReference typeRef = ((DefinitionBase)this.getDefinition()).getTypeReference();
        this.scope.buildEventParameter(typeRef);
        typeRef.resolve(builder.getProject(), this.scope, DependencyType.EXPRESSION, true);
        for (ScopedBlockNode script : scripts) {
            int n = script.getChildCount();
            this.asNodes = new NodeBase[n];
            for (int i = 0; i < n; ++i) {
                NodeBase child;
                this.asNodes[i] = child = (NodeBase)script.getChild(i);
                child.setParent(this);
            }
        }
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLEventSpecifierID;
    }

    @Override
    public IASNode getChild(int i) {
        return this.asNodes != null ? this.asNodes[i] : null;
    }

    @Override
    public int getChildCount() {
        return this.asNodes != null ? this.asNodes.length : 0;
    }

    @Override
    public IASNode[] getASNodes() {
        return this.asNodes;
    }

    @Override
    public IASScope getScope() {
        return this.scope;
    }

    @Override
    public void getAllImports(Collection<String> imports) {
        ((MXMLClassDefinitionNode)this.getClassDefinitionNode()).getAllImports(imports);
    }

    @Override
    public void getAllImportNodes(Collection<IImportNode> imports) {
        ((MXMLClassDefinitionNode)this.getClassDefinitionNode()).getAllImportNodes(imports);
    }

    @Override
    public IParameterDefinition getEventParameterDefinition() {
        ParameterDefinition result = this.scope.getEventParameterDefinition();
        assert (result != null) : "Even parameter definition should be built before it is accessed";
        return result;
    }

    @Override
    public boolean needsPublicHandler() {
        return ((IMXMLClassReferenceNode)this.getParent()).needsDescriptor();
    }
}

